/**
 * Copyright bkzen ( http://wonderfl.net/user/bkzen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/reqT
 */

// forked from narutohyper's Logo and the view is set
package {
    import flash.events.Event;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    
    [SWF(backgroundColor="#000000", frameRate="100", width="800", height="600")]
    public class Main extends Sprite {
        
        private var bmd:BitmapData;
        private var bmp:Bitmap;
        private var test:Test;
        private var pieces: Vector.<Piece> = new Vector.<Piece>(16, true);
        
        public function Main() 
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            stage.quality = StageQuality.LOW;
            test = new Test();
            bmd = new BitmapData(440, 440, false, 0);
            for (var i: int = 0; i < 16; i++) addChild(pieces[i] = new Piece(bmd, i));
            addEventListener(Event.ENTER_FRAME, loop);
            shuffle();
            for (i = 0; i < 16; i++) pieces[i].move(i);
        }
        private function loop(e:Event): void
        {
            bmd.lock();
            bmd.fillRect(bmd.rect, 0);
            bmd.draw(test);
            bmd.unlock();
        }
        
        private function shuffle(): void 
        {
            for (var i: int = 0, to: int ; i < 200; i++ ) { for (var j: int = 0; j < 2; j++ ) { // 0 - 15 で偶数回シャッフルすれば解けない問題は作られない。
                var from: int = Math.random() * 15;
                do { to = Math.random() * 15; } while (from == to);
                swap(from, to);
            }}
        }
        private function swap(from: int, to: int, slideX: int = 0, slideY: int = 0): void
        {
            var p: Piece = pieces[from];
            pieces[from] = pieces[to];
            pieces[to] = p;
        }

    }
}
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Shape;

class Piece extends Sprite
{
    private var bmp: Bitmap, sh: Shape, index: int;
    public var point: int;
    function Piece(bmd: BitmapData, index: int)
    {
        addChild(bmp = new Bitmap(bmd));
        bmp.mask = addChild(sh = new Shape());
        sh.graphics.beginFill(0);
        sh.graphics.drawRect(1, 1, 108, 108);
        bmp.x = - (x = (index % 4)     * 110);
        bmp.y = - (y = (index / 4 | 0) * 110);
        this.index = index;
    }
    public function move(index: int): void
    {
        point = index;
        x = (index % 4)     * 110;
        y = (index / 4 | 0) * 110;
        if (index == 15) visible = false;
    }
    
    public function check(): Boolean
    {
        return index == point;
    }
    
}



import alternativ7.Alternativa3D
import alternativ7.engine3d.containers.ConflictContainer;
import alternativ7.engine3d.containers.DistanceSortContainer
import alternativ7.engine3d.controllers.SimpleObjectController;
import alternativ7.engine3d.core.Camera3D;
import alternativ7.engine3d.core.Debug;
import alternativ7.engine3d.core.MipMapping;
import alternativ7.engine3d.core.Object3D;
import alternativ7.engine3d.core.Object3DContainer
import alternativ7.engine3d.core.Sorting;
import alternativ7.engine3d.core.View;
import alternativ7.engine3d.materials.TextureMaterial;
import alternativ7.engine3d.objects.Sprite3D;
import alternativ7.engine3d.primitives.Box;
import alternativ7.engine3d.core.Canvas
import alternativ7.engine3d.primitives.Plane;
import alternativ7.engine3d.core.Clipping;
import alternativ7.engine3d.core.MouseEvent3D;

import flash.display.BitmapData;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.KeyboardEvent;
import flash.geom.ColorTransform;
import flash.system.Capabilities;
import flash.ui.Keyboard;
import flash.filters.GlowFilter;
import flash.display.BlendMode;

import flash.utils.describeType;

class Test extends Sprite
{
    private var camera1:Camera3D;
    private var camera2:Camera3D;
    private var camera3:Camera3D;
    private var camera4:Camera3D;
    private var controller1:SimpleObjectController;
    private var controller2:SimpleObjectController;
    private var controller3:SimpleObjectController;
    private var controller4:SimpleObjectController;
    
    private var anim:Boolean = true;
    private var animObject:DistanceSortContainer
    
    private var frame:Sprite = new Sprite();
    private var boxs:Vector.<Box>=new Vector.<Box>()
    
    
    
    public function Test() {
        
        // Camera
        camera1 = new Camera3D();
        camera2 = new Camera3D();
        camera3 = new Camera3D();
        camera4 = new Camera3D();

        camera1.view = new View(400, 300,false);
        camera2.view = new View(400, 300);
        camera3.view = new View(400, 300);
        camera4.view = new View(400, 300);
        addChild(camera1.view);
        addChild(camera2.view);
        addChild(camera3.view);
        addChild(camera4.view);
        
        camera1.y = -3000;
        camera2.x = -3000;
        camera3.z = -3000;
        camera4.y = -3000;
        camera4.z = -3000;

        
        // Camera controller
        controller1 = new SimpleObjectController(this, camera1, 200, 3);
        controller2 = new SimpleObjectController(this, camera2, 200, 3);
        controller3 = new SimpleObjectController(this, camera3, 200, 3);
        controller4 = new SimpleObjectController(this, camera4, 200, 3);
        controller1.lookAtXYZ(0, 0, 0);
        controller2.lookAtXYZ(0, 0, 0);
        controller3.lookAtXYZ(0, 0, 0);
        controller4.lookAtXYZ(0, 0, 0);
        
        // Root object
        var container:DistanceSortContainer = new DistanceSortContainer();
        
        // Box
        var material:TextureMaterial = new TextureMaterial();
        material.texture = new BitmapData(60, 60, false, 0);
        material.texture.perlinNoise(30, 30, 5, 0, false, true, 6);
        material.repeat = false;
        material.smooth = true;
        material.mipMapping = MipMapping.OBJECT_DISTANCE 
        
        animObject = new DistanceSortContainer();
        var boxCounter:uint=0
        for (var sx:uint = 0; sx < 4; sx++ ) {
            for (var sy:uint = 0; sy < 4; sy++ ) {
                for (var sz:uint = 0; sz < 4; sz++ ) {
                    boxs[boxCounter] = new Box(100, 100, 100, 1, 1, 1);
                    boxs[boxCounter].setMaterialToAllFaces(material);
                    boxs[boxCounter].sorting = Sorting.AVERAGE_Z;

                    boxs[boxCounter].x = sx*200-(2*200);
                    boxs[boxCounter].y = sy*200-(2*200);
                    boxs[boxCounter].z = sz*200-(2*200);
                    animObject.addChild(boxs[boxCounter]);
                    boxCounter++
                }
            }
        }
        container.addChild(animObject);

        // Adding
        container.addChild(camera1);
        container.addChild(camera2);
        container.addChild(camera3);
        container.addChild(camera4);
        
        // Mouse events
        container.addEventListener(MouseEvent3D.MOUSE_WHEEL, onMouseWheel);
        
        // Debug
        addChild(camera1.diagram);
        
        // Info
        onResize();

        addEventListener(Event.ENTER_FRAME, onEnterFrame);


        //animObject = box;
    }

    public function onEnterFrame(e:Event = null):void {
        if (anim && animObject != null) {
            animObject.rotationX += 1*Math.PI/180;
            animObject.rotationY -= 0.5*Math.PI/180;
            animObject.rotationZ += 0.5*Math.PI/180;
        }
        
        controller1.update();
        controller2.update();
        controller3.update();
        controller4.update();
        camera1.render();
        camera2.render();
        camera3.render();
        camera4.render();
    }
    
    private function onMouseWheel(e:MouseEvent3D):void {
        if (e.target is Sprite3D) {
            (e.target as Sprite3D).rotation += e.delta/20;
        } else {
            (e.target as Object3D).rotationZ += e.delta/20;
        }
    }
    
    private function onKeyDown(e:KeyboardEvent):void {
        switch (e.keyCode) {
            case Keyboard.TAB:
                //camera.debug = !camera.debug;
                break;
            case Keyboard.ENTER:
                break;
            case Keyboard.SPACE:
                anim = !anim;
                break;
            case 81: // Q
                //if (stage.quality == "HIGH") {
                    //stage.quality = StageQuality.LOW;
                //} else {
                    //stage.quality = StageQuality.HIGH;
                //}
                break;
        }
    }

    public function onResize(e:Event = null):void {
        var pd:Number = 100;
        camera1.view.x = 0;
        camera1.view.y = 0;
        camera2.view.x = 440 / 2;
        camera2.view.y = 0;
        camera3.view.x = 0;
        camera3.view.y = 440 / 2;
        camera4.view.x = 440 / 2;
        camera4.view.y = 440 / 2;
        camera1.view.width = 440 / 2;
        camera1.view.height = 440 / 2;
        camera2.view.width = 440 / 2;
        camera2.view.height = 440 / 2;
        camera3.view.width = 440 / 2;
        camera3.view.height = 440 / 2;
        camera4.view.width = 440 / 2;
        camera4.view.height = 440 / 2+100;
        
    }
}