/**
 * Copyright Yuichi ( http://wonderfl.net/user/Yuichi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/re3W
 */

package {
    import flash.events.Event;
    import flash.display.Sprite;
    import caurina.transitions.Tweener;
    
    public class Main extends Sprite {
        private static const MIN_LEN:int = 4;
        private static const MAX_LEN:int = 16;
        
        private static const MIN_SIZE:int = 24;
        private static const MAX_SIZE:int = 48;
        
        private static const CHARS:String = ""
          + "abcdefghijklmnopqrstuvwxyz"
          + "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
        ;
        
        private static const NUM_TEXTS:int = 32;
        
        private var texts:Vector.<Text>;
        
        public function Main() {
            addEventListener(Event.ADDED_TO_STAGE, init);
            if(stage) init();
        }
        
        private function init(e:Event = null):void{
            removeEventListener(Event.ADDED_TO_STAGE, init);
            texts = new Vector.<Text>(NUM_TEXTS, true);
            for(var i:int = 0; i < NUM_TEXTS; i++){
                loop(i);
            }
        }
        
        private function loop(i:int):void{
            if(texts[i]){
                removeChild(texts[i]);
            }

            var len:int = MIN_LEN + (MAX_LEN - MIN_LEN) * Math.random();
            var str:String = "";
            for(var j:int = 0; j < len; j++){
                str += CHARS.charAt(CHARS.length * Math.random());
            }
            texts[i] = new Text(str, MIN_SIZE + (MAX_SIZE - MIN_SIZE) * Math.random(), 0x1000000 * Math.random());
            texts[i].x = stage.stageWidth * Math.random() - texts[i].width / 2;
            texts[i].y = stage.stageHeight * Math.random() - texts[i].height / 2;
            texts[i].alpha = 0;
            addChild(texts[i]);
            Tweener.addTween(texts[i], {alpha:1, delay:3 * Math.random(), time:1});
            Tweener.addTween(texts[i], {alpha:0, delay:3 + 3 * Math.random(), time:1, onComplete:loop, onCompleteParams:[i]});
        }
    }
}
import flash.text.TextFormat;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;

internal class Text extends TextField{
    private var format:TextFormat;
    
    public function Text(text:String, size:Number=16, color:uint=0x000000){
        // init format
        format = new TextFormat(null, size, color);
        defaultTextFormat = format;
        
        // init
        this.text = text;
        autoSize = TextFieldAutoSize.LEFT;
        this.mouseEnabled = false;
    }

}
