/**
 * Copyright Aksor.Al ( http://wonderfl.net/user/Aksor.Al )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rdT5
 */

/*
To use, call a new instance of BeatMapper:
 var myBeatMapper= new BeatMapper(beatNum:Number, isFreq:Boolean);

beatNum= a positive number between 1 and 256. This number of divisions you would like soundwave to split into.

isFreq= false returns a soundwave, true returns a frequency spectrum

All, the beat values (which range from -1 to 1) are stored in the the array named beatValue. You can call on the value of any of the beats in they array by it's index number. In the example below, all the beats value are accessed through a for loop:

 for (var j:uint=0; j<myBeatMapper.beatNum; j++)
 {
 //do whatever you want with beatValue[j];

 beatX= j*spacing + 15;
 beatY= myBeatMapper.beatValue[j]*maxAmp+startPos;
 graphics.drawCircle(beatX, beatY, 5);

 }//for

*/

package soundSpectrumCode
{
 import flash.utils.ByteArray;
 import flash.media.SoundMixer;
 import flash.events.Event;
 import flash.display.MovieClip;

 public class BeatMapper extends MovieClip
 {
 public var beatNum:Number; // 1-256 . Splits up wave into bars.
 public var isFreq:Boolean; //false give raw wave outpout, true gives frequency
 public var ba:ByteArray= new ByteArray();
 public var beatValue:Array=new Array;

 private var divisor:Number;
 private var remainder:Number;

 public function BeatMapper(numberOfBeats:Number, isFrequency:Boolean)
 {

 trace("hi from Soundbeat");
 beatNum= numberOfBeats;
 isFreq= isFrequency;

 divisor =Math.floor(256/beatNum);
 remainder= 256%divisor;

 addEventListener(Event.ENTER_FRAME, loop);

 } //SoundBeat

 private function loop(e:Event)
 {
 SoundMixer.computeSpectrum(ba, isFreq); //512 pieces, 256 each left and right. Each value btwn -1 and 1

 var oneBeat:Number= 0;
 var whichBeat:uint= 0;

 for(var i:uint=1; i<=256; i++) //only first 256 (left channel)
 {
 oneBeat += ba.readFloat();

 if(whichBeat==beatNum-1)
 {
 if(i==256)
 {
 beatValue[whichBeat]= oneBeat/(divisor+remainder);
 }// if if
 }
 else if(i%divisor == 0)
 {
 beatValue[whichBeat]= oneBeat/(divisor);
 oneBeat= 0; //new start of one beat
 whichBeat++;
 } //if else if

 }//for
 } //loop

 } //class
} //package