/**
 * Copyright kappaLab ( http://wonderfl.net/user/kappaLab )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rdDe
 */

// forked from Mae_ITR's flash on 2009-11-27
package 
{

    //挫折orz　いろいろヒドイデス　メモリリークとか
 
	import flash.display.GradientType;    
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Matrix;
	import flash.geom.Vector3D;

	import org.papervision3d.view.BasicView;
	import org.papervision3d.objects.DisplayObject3D;

	import org.papervision3d.core.geom.Pixels;
	import org.papervision3d.core.geom.renderables.Pixel3D; 
    import org.papervision3d.view.layer.BitmapEffectLayer;
	import org.papervision3d.core.effects.BitmapLayerEffect; 
    import org.papervision3d.core.effects.utils.BitmapClearMode;
	
	import caurina.transitions.Tweener;

	public class Main extends BasicView
	{
		private var _target:DisplayObject3D;
		private var _pixels:Pixels;
		private var _tails:Vector.<Tail>;
		private var _marker:Marker;
		private var _cameraTarget:Vector3D;
		private var _cv:Vector3D;
		
		public function Main():void 
		{
			super(0, 0, true, false);
			initScene();
			initDisplayObject3D();
			initTween();
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			startRendering();
		}
		
		private function initScene():void
		{
			drawBG();
			
			this.camera.x = this.camera.y = 100;
			this.camera.z = -100;
			_cameraTarget = new Vector3D();
			_cv = new Vector3D();
			_target = new DisplayObject3D();
			scene.addChild(_target);
			_target.x = _target.y = _target.z = 0;
			this.camera.target = _target;
		}
		
		private function initDisplayObject3D():void
		{
			var layer:BitmapEffectLayer = new BitmapEffectLayer(viewport, this.stage.stageWidth, this.stage.stageHeight, true, 0, BitmapClearMode.CLEAR_PRE, true);
			layer.clearBeforeRender = true;
            viewport.containerSprite.addLayer(layer);
			
			_pixels = new Pixels(layer);
            scene.addChild(_pixels); 
            var dotDensity:int = 20; 
			for (var i:int = 0; i <= dotDensity;i++ ) {
				for (var j:int = 0; j <= dotDensity; j++ ) {
					var p:Pixel3D = new Pixel3D(0xff000000,
													(i - dotDensity / 2) * 5000/dotDensity,
													0,
													(j - dotDensity / 2) * 5000/dotDensity													
												); 
					_pixels.addPixel3D(p);
				}
			}
			
			_marker = new Marker();
			scene.addChild(_marker);
			
			_tails = new Vector.<Tail>();
			for (var k:int = 0; k < 4;k++ ) {
				var tail:Tail = new Tail(_target, 0x999999, 100);
				_tails.push(tail);
				scene.addChild(tail);
			}			
		}
		
		private function initTween():void
		{
			tweenTarget(_target);
			tweenCameraTarget(_cameraTarget);
		}
		
		private function onEnterFrame(e:Event):void 
		{	
			_cv.x += (_cameraTarget.x - camera.x)/50;
			_cv.y += (_cameraTarget.y - camera.y)/50;
			_cv.z += (_cameraTarget.z - camera.z)/50;
			_cv.x /= 1.05;
			_cv.y /= 1.05;
			_cv.z /= 1.05;
			camera.x += _cv.x;
			camera.y += _cv.y;
			camera.z += _cv.z;
			for (var i:int = 0; i < _tails.length; i++ ) {
				_tails[i].cruising();
			}
			_marker.x = _target.x;
			_marker.z = _target.z;
			_marker.drawPole(_target.y );
			
		}
		private function tweenTarget(obj:DisplayObject3D):void {
			Tweener.addTween(obj, {
				x:Math.random() * 2000 -1000,
				y:Math.random() * 2000 -1000,
				z:Math.random() * 2000 -1000,
				time:Math.random()*2+1,
				transition    :"easeOutExpo",				
				onComplete:updateTarget,
				onCompleteParams:[obj]
				
			});			
		}
		
		private function updateTarget(obj:DisplayObject3D):void {
			Tweener.removeTweens(obj);
			tweenTarget(obj);
		}
		
		private function tweenCameraTarget(target:Vector3D):void {
			Tweener.addTween(target, {
				x:Math.random() * 500 - 250,
				y:Math.random() * 500 - 250,
				z:Math.random() * 500 - 250,
				time:Math.random() + 1,
				transition    :"easeOutExpo",				
				onComplete:updateCameraTarget,
				onCompleteParams:[target]
				
			});			
		}
		
		private function updateCameraTarget(target:Vector3D):void {
			Tweener.removeTweens(target);
			tweenCameraTarget(target);
		}
			
		private function drawBG():void
		{
			var acol:Array = new Array(0xFFFFFF,0x000000);
            var aalpha:Array = new Array(.1, .15);
            var aratio:Array = new Array(0, 255);
            var mt:Matrix = new Matrix();
            mt.createGradientBox(stage.stageWidth,stage.stageHeight, 0, 0, 0);
			this.graphics.clear();
            this.graphics.beginGradientFill(GradientType.RADIAL, acol, aalpha, aratio,mt);
            this.graphics.drawRect(0, 0, stage.stageWidth,stage.stageHeight);
            this.graphics.endFill();
		}
		
		
	}
	
}

import flash.display.DisplayObject;
import flash.geom.Vector3D;
import org.papervision3d.core.geom.Lines3D;
import org.papervision3d.core.geom.renderables.*;
import org.papervision3d.materials.special.LineMaterial;
import org.papervision3d.objects.DisplayObject3D;

class Tail extends Lines3D
{
	private var _tailLines:Vector.<Line3D>;
	private var _length:int;
	private var _target:DisplayObject3D;
	private var _color:uint = 0xffffff;
	
	private var vs:Number; 
	private var v:Vector3D
	private var line:Line3D;
	private var oldPos:Vector3D;
	private var Pos:Vector3D;
		
		
	public function Tail(target:DisplayObject3D,color:uint,length:int) 
	{
		
		_color = color;
		_length = length;
		_target = target;
		super(new LineMaterial(_color));
		_tailLines = new Vector.<Line3D>();
		init();
		
	}
	
	private function init():void
	{
		vs = Math.random() * 80 + 20;
		v = new Vector3D();
		Pos = new Vector3D();
		oldPos = new Vector3D();
		Pos.x = Math.random() * 2000 -1000;
		Pos.y = Math.random() * 2000 -1000;
		Pos.z = Math.random() * 2000 -1000;
	}
	public function cruising():void
	{
		v.x += (_target.x - oldPos.x)/vs;
		v.y += (_target.y - oldPos.y)/vs;
		v.z += (_target.z - oldPos.z)/vs;
		v.x /= 1.05;
		v.y /= 1.05;
		v.z /= 1.05;
		oldPos = Pos.clone();
		Pos.x += v.x;
		Pos.y += v.y;
		Pos.z += v.z;
		line = new Line3D(this, new LineMaterial(_color), 1, new Vertex3D(oldPos.x,oldPos.y,oldPos.z),new Vertex3D(Pos.x,Pos.y,Pos.z));
		addLine(line);
		_tailLines.reverse();
		_tailLines.push(line);
		_tailLines.reverse();
		for (var i:int = 0; i < _tailLines.length; i++ ) {
			_tailLines[i].size = (1 - i/_tailLines.length);
			_tailLines[i].material.lineAlpha = 1 - i/_tailLines.length; 	
		}
		if ( _tailLines.length >= _length) {
			removeLine(_tailLines[ _tailLines.length - 1]);
			_tailLines[ _tailLines.length - 1].material.destroy();			
			_tailLines[ _tailLines.length - 1] = null;				
			_tailLines.pop();
		}
	}
	
}

import org.papervision3d.objects.DisplayObject3D;
import org.papervision3d.materials.special.VectorShapeMaterial;
import org.papervision3d.objects.special.Graphics3D;
import org.papervision3d.objects.special.VectorShape3D;
import org.papervision3d.core.geom.Lines3D;
import org.papervision3d.core.geom.renderables.*;
import org.papervision3d.materials.special.LineMaterial;
	
class Marker extends DisplayObject3D
{
	private var vshape_marker:VectorShape3D;
	private var vshape_marker2:VectorShape3D;
	private var pole:Lines3D;
	
	public function Marker()
	{
		init();
	}
	
	private function init():void
	{			
		vshape_marker = new VectorShape3D(new VectorShapeMaterial());
		vshape_marker.rotationX = 90;
		drawMaker(vshape_marker.graphics);			
		addChild(vshape_marker);
		
		vshape_marker2 = new VectorShape3D(new VectorShapeMaterial());
		vshape_marker2.rotationX = 90;
		drawMaker(vshape_marker2.graphics);
		addChild(vshape_marker2);
			
		pole = new Lines3D(new LineMaterial(0x999999, 0.3));
		pole.addNewLine(0.5, 0, 0, 0, 0, 1, 0);
		addChild(pole);			
	}
	
	private function drawMaker(g:Graphics3D):void {
		g.clear();
		g.lineStyle(.5, 0xCCCCCC, 0.5);
		g.moveTo(10, 0);
		g.lineTo( -10, 0);
		g.moveTo(0, 10);
		g.lineTo( 0, -10);
	}
	
	public function drawPole(h:Number):void {
		pole.scaleY = h;
		vshape_marker2.y = h;
	}
		
}
