/**
 * Copyright termat ( http://wonderfl.net/user/termat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rcdF
 */

package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;

	[SWF(width = "480", height = "480", backgroundColor = "0xffffff", fps = "60")] 
	public class Practice75 extends Sprite{
		private var list:Array;
		private var id:int = 0;
		
		public function Practice75() {
			list = new Array();
			addEventListener(Event.ENTER_FRAME, update);
		}
		
		private function update(e:Event):void {
			graphics.clear();
			var c:Circle = new Circle();
			c.x = mouseX;c.y = mouseY;
			c.radius = 1;
			c.color = getColor(id, 1.0);
			id = (id+1) % 360;
			list.push(c);
			for (var i:int = 0; i < list.length; i++) {
				var obj:Circle = list.shift();
				obj.draw(graphics);
				if (obj.radius < 480) list.push(obj);
			}
		}
		
		private function getColor(i:int, saturation:Number):uint {
			var h:Number = i / 60;
			var ii:Number = Math.floor(h);
			var ff:Number = h - ii;
			var p1:Number = (1.0 - saturation);
			var p2:Number = (1.0 - saturation * ff);
			var p3:Number = (1.0 - saturation * (1.0 - ff));
			var rv:Number, gv:Number, bv:Number;
			switch(ii) {
			case 0:
				rv = 1.0, gv = p3, bv = p1;
				break;
			case 1:
				rv = p2, gv = 1.0, bv = p1;
				break;
			case 2:
				rv = p1, gv = 1.0, bv = p3;
				break;
			case 3:
				rv = p1, gv = p2, bv = 1.0;
				break;
			case 4:
				rv = p3, gv = p1, bv = 1.0;
				break;
			default:
				rv = 1.0, gv = p1, bv = p2;
			}
			var color:uint = (Math.max(0, Math.min(255, rv * 255)) << 16) + (Math.max(0, Math.min(255, gv * 255)) << 8) + Math.max(0, Math.min(255, bv * 255));
			return color;
		}
	}
}
import flash.display.MovieClip;
import flash.display.Graphics;
class Circle{
	public var x:Number = 0;
	public var y:Number = 0;
	private var width:Number = 2;
	public var radius:Number = 1;
	public var color:uint = 0x000000;
	public var alpha:Number = 1.0;
	
	public function draw(g:Graphics):void {
		g.lineStyle(width, color);
		g.drawCircle(x, y, radius);
		radius += 4;
		alpha *= 0.9;
	}
	
}