/**
 * Copyright flash.technologist ( http://wonderfl.net/user/flash.technologist )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rcIh
 */

package
{
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.media.Camera;
    import flash.media.Microphone;
    import flash.media.Video;
    import flash.media.scanHardware;
    import flash.text.TextField;
    import flash.utils.Timer;
    
    public class BrowserPermissionTest extends Sprite
    {
        private var output:TextField;
        private var timer:Timer;
        
        public function BrowserPermissionTest()
        {
            super();
            
            addEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
        }
        
        private function addedToStageHandler(event:Event):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
            
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            output = new TextField();
            output.border = true;
            output.multiline = true;
            output.wordWrap = true;
            output.x = output.y = 10;
            addChild(output);
            
            updateView();
            stage.addEventListener(Event.RESIZE, stage_resizeHandler);
            
            var i:int;
            var numCameras:int = 0;
            var numMicrophones:int = 0;
            
            if (Camera.isSupported)
            {
                var cameraNames:Array = Camera.names;
                numCameras = cameraNames ? cameraNames.length : 0;
                if (numCameras > 0)
                {
                    log("Cameras:");
                    for (i = 0; i < numCameras; i++)
                    {
                        var cameraName:String = cameraNames[i];
                        log((i + 1) + ". \"" + cameraName + "\"");
                    }
                }
                else
                {
                    log("Camera not found.");
                }
            }
            else
            {
                log("Camera is not supported.");
            }
            
            log("");
            
            if (Microphone.isSupported)
            {
                var microphoneNames:Array = Microphone.names;
                numMicrophones = microphoneNames ? microphoneNames.length : 0;
                if (numMicrophones > 0)
                {
                    log("Microphones:");
                    for (i = 0; i < numMicrophones; i++)
                    {
                        var microphoneName:String = microphoneNames[i];
                        log((i + 1) + ". \"" + microphoneName + "\"");
                    }
                }
                else
                {
                    log("Microphone not found.");
                }
            }
            else
            {
                log("Microphone is not supported.");
            }
            
            log("");

            if (numCameras > 0 || numMicrophones > 0)
            {
                if (numCameras > 0)
                {
                    var defaultCamera:Camera = Camera.getCamera();
                    var video:Video = new Video(1, 1);
                    addChild(video);
                    video.attachCamera(defaultCamera);
                    defaultCamera.muted ? devicesMutedInFlashPlayer() : devicesUnmutedInFlashPlayer();
                }
                else if (numMicrophones > 0)
                {
                    var defaultMicrophone:Microphone = Microphone.getMicrophone();
                    defaultMicrophone.setLoopBack(true);
                    defaultMicrophone.muted ? devicesMutedInFlashPlayer() : devicesUnmutedInFlashPlayer();
                }
                else
                {
                    log("No devices found for test.");
                }                
            }
        }
        
        private function devicesMutedInFlashPlayer():void
        {
            log("Devices are muted in Flash Player.");
            log("Starting permission check timer...");
            
            timer = new Timer(100);
            timer.addEventListener(TimerEvent.TIMER, flashPlayerPermissionTimer_timerHandler);
            timer.start();
        }
        
        private function flashPlayerPermissionTimer_timerHandler(event:TimerEvent):void
        {
            var defaultCamera:Camera = Camera.getCamera();
            if (!isDevicesMutedInFlashPlayer())
            {
                timer.stop();
                timer.removeEventListener(TimerEvent.TIMER, flashPlayerPermissionTimer_timerHandler);
                timer = null;
                
                devicesUnmutedInFlashPlayer();
            }
        }
        
        private function devicesUnmutedInFlashPlayer():void
        {
            log("Devices are unmuted in Flash Player.");
            isDevicesMutedInBrowser() ? devicesMutedInBrowser() : devicesUnmutedInBrowser();
        }
        
        private function devicesMutedInBrowser():void
        {
            log("Devices are muted in browser.");
            log("Starting permission check timer...");
            
            timer = new Timer(100);
            timer.addEventListener(TimerEvent.TIMER, browserPermissionTimer_timerHandler);
            timer.start();
        }
        
        private function browserPermissionTimer_timerHandler(event:TimerEvent):void
        {
            scanHardware();
            if (!isDevicesMutedInBrowser())
            {
                timer.stop();
                timer.removeEventListener(TimerEvent.TIMER, browserPermissionTimer_timerHandler);
                timer = null;
                
                devicesUnmutedInBrowser();
            }
        }
        
        private function devicesUnmutedInBrowser():void
        {
            log("Devices are unmuted in browser.");
        }
        
        private function isDevicesMutedInFlashPlayer():Boolean
        {
            var cameraNames:Array = Camera.names;
            var numCameras:int = cameraNames ? cameraNames.length : 0;
            if (numCameras > 0)
            {
                var defaultCamera:Camera = Camera.getCamera();
                return defaultCamera.muted;
            }
            else
            {
                var microphoneNames:Array = Camera.names;
                var numMicrophones:int = microphoneNames ? microphoneNames.length : 0;
                if (numMicrophones > 0)
                {
                    var defaultMicrophone:Microphone = Microphone.getMicrophone();
                    return defaultMicrophone.muted;
                }
            }
            return true;
        }
        
        private function isDevicesMutedInBrowser():Boolean
        {
            var cameraNames:Array = Camera.names;
            var numCameras:int = cameraNames.length;
            for (var i:int = 0; i < numCameras; i++)
            {
                var cameraName:String = cameraNames[i];
                if (cameraName != " ")
                {
                    return false;
                }
            }

            var microphoneNames:Array = Microphone.names;
            var numMicrophones:int = microphoneNames.length;
            for (i = 0; i < numMicrophones; i++)
            {
                var microphoneName:String = microphoneNames[i];
                if (microphoneName != " ")
                {
                    return false;
                }
            }
            
            return true;
        }
        
        private function log(text:String):void
        {
            output.appendText(text + "\n");
        }
        
        private function updateView():void
        {
            output.width = stage.stageWidth - 2 * output.x;
            output.height = stage.stageHeight - 2 * output.y;
        }
        
        private function stage_resizeHandler(event:Event):void
        {
            updateView();
        }
    }
}