/**
 * Copyright geko ( http://wonderfl.net/user/geko )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rc1N
 */

package {
    import flash.display.*;
    import flash.events.*;
    
    public class Text2Code extends Sprite {
        public var memoPad:MemoPad;
        public var canvas:Sprite;
        
        public function Text2Code() {
            memoPad = new MemoPad(this, stage.stageWidth/2-200, stage.stageHeight/2-200, 400, 400);
            memoPad.addEventListener(MemoPad.RUN, function run(event:Event):void{
                text2Code(memoPad.texts);
            });
        }
        
        //文字列からコードに変換
        public function text2Code(codeList:Array):void{
            var codes:Array;
            memoPad.code.appendText("\nrunning\n"+codeList.toString()+"\n");
            for each(var text:String in codeList){
                codes = text.split(".");
                //memoPad.code.appendText("\n"+codes.toString());
                for each(var code:String in codes){
                    memoPad.code.appendText("\n"+String(isMethod(code)));
                }

            }
        }
        
        public function isMethod(code:String):Boolean{
            var regExp:RegExp = /(a-zA-Z0-9)*\(.*\)/;
            return regExp.test(code);
        }

    }
}

import flash.display.DisplayObjectContainer;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.text.TextField;
import flash.text.TextFormat;
import com.bit101.components.PushButton;
import com.bit101.components.HSlider;
import com.bit101.components.VSlider;

//行数付き文字入力フィールド
class MemoPad extends Sprite{
    static public const RUN:String = "run";
    static public const STOP:String = "stop";
    static public const SAVE:String = "save";
    public var code:TextField = new TextField();  //本文
    private var lineNumber:TextField = new TextField(); //行数
    private var hSlider:HSlider;
    private var vSlider:VSlider;
    private var clearBt:PushButton;
    private var runBt:PushButton;
    private var saveBt:PushButton;
    
    public function MemoPad(parent:DisplayObjectContainer = null, x:Number = 0, y:Number = 0, width:Number = 100, height:Number = 100):void{
        //TextFieldの設定
        code.defaultTextFormat = new TextFormat(null, 12, 0x666666);
        code.x = 25;
        code.y = 5;
        code.multiline = true;
        code.type = "input";
        lineNumber.defaultTextFormat = new TextFormat(null, 11, 0x888888, null, null, null, null, null, "right", null, null, null, 1);
        lineNumber.x = 0;
        lineNumber.y = 7;
        lineNumber.multiline = true;
        lineNumber.mouseEnabled = false;
        addChild(code);
        addChild(lineNumber);
        //イベントリスナー
        code.addEventListener(Event.CHANGE, function change(event:Event):void{
            setLineNumber();
            lineNumber.scrollV = code.scrollV;
            hSlider.value = code.scrollH/code.maxScrollH;
            vSlider.value = code.maxScrollV > 1 ? 1-code.scrollV/code.maxScrollV : 1;
        });
        
        //Sliderの設定
        hSlider = new HSlider(this, 0, 0, function change(event:Event):void{
            scrollH = int(hSlider.value*code.maxScrollH);
        });
        vSlider = new VSlider(this, 0, 0, function change(event:Event):void{
            scrollV = int((1-vSlider.value)*code.maxScrollV);
        });
        hSlider.tick = vSlider.tick = 0.01;
        hSlider.setSliderParams(0, 1, 0);
        vSlider.setSliderParams(0, 1, 1);
        
        //Buttonの設定
        runBt = new PushButton(this, 0, 0, "run", function click(event:MouseEvent):void{
            dispatchEvent(new Event(runBt.label));
            if(runBt.label == "run"){
                code.mouseEnabled = clearBt.enabled = hSlider.enabled = vSlider.enabled = false;
                code.textColor = 0xAAAAAA;
                lineNumber.textColor = 0xCCCCCC;
                runBt.label = "stop";
            }else{
                code.mouseEnabled = clearBt.enabled = hSlider.enabled = vSlider.enabled = true;
                code.textColor = 0x666666;
                lineNumber.textColor = 0x888888;
                runBt.label = "run";
            }            
        });
        clearBt = new PushButton(this, 85, 0, "clear", function click(event:MouseEvent):void{
            code.text = "";
            setLineNumber();
        });
        saveBt = new PushButton(this, 0, 0, "save", function click(event:MouseEvent):void{
            dispatchEvent(new Event(saveBt.label));
        });
        runBt.setSize(80, 20);
        clearBt.setSize(80, 20);
        saveBt.setSize(80, 20);
        
        if(parent) parent.addChild(this);
        this.x = x;
        this.y = y;
        setSize(width, height);
        setLineNumber();
    }
    
    //サイズの変更
    public function setSize(width:Number, height:Number):void{
        //サイズの最小値
        width = Math.max(80, width);
        height = Math.max(100, height);
        
        code.width = width-55;
        code.height = height-30;
        lineNumber.width = 25;
        lineNumber.height = height-30;
        hSlider.y = height-30;
        hSlider.setSize(width-10, 10);
        vSlider.x = width-10;
        vSlider.setSize(10, height-30);
        runBt.y = height-10;
        clearBt.y = height-10;
        saveBt. x = width -80;
        saveBt.y = height-10;
        
        graphics.clear();
        graphics.lineStyle(1, 0x666666);
        graphics.beginFill(0xFFFFFF, 0.8);
        graphics.drawRect(0, 0, width, height-20);
        graphics.endFill();
        graphics.lineStyle(1, 0xCCCCCC);
        graphics.moveTo(24, 0);
        graphics.lineTo(24, height-30);
    }
    //行数の変更
    private function setLineNumber():void{
        lineNumber.text = "1\n";
        while(lineNumber.numLines <= code.numLines){
            lineNumber.appendText(String(lineNumber.numLines)+"\n");
        }
    }
    
    //--------------------
    //getter/setter
    //--------------------
    
    //水平表示位置
    private function set scrollH(value:int):void{
        value = Math.min(Math.max(value, 0), code.maxScrollH);
        code.scrollH = value;
    }
    //垂直表示位置
    private function set scrollV(value:int):void{
        value = Math.min(Math.max(value, 1), code.maxScrollV);
        code.scrollV = lineNumber.scrollV = value;
    }
    //文字列を返す
    public function get text():String{
        return code.text;
    }
    //文字列を行ごとに分割した配列を返す
    public function get texts():Array{
        return code.text.split("\r");
    }
}