/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rbjM
 */






package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;

    [SWF(backgroundColor="0xffffff", frameRate="60")] 


    public class Trick extends Sprite 
    { 
        private var _numBlobs:uint = 3;        
        private var _blogPx:Array = new Array(20 ,20 , 90, 90);
        private var _blogPy:Array = new Array(60, 80, 100, 120);
        private var _blogDx:Array = new Array(1, 1, -1, -1);
        private var _blogDy:Array = new Array(-1, -1, -1, -1);
        private var _bmpData:BitmapData;
        private var _vx:Array = new Array();
        private var _vy:Array = new Array();
        private var _downFlg:Boolean = false;
        
        public function Trick():void 
        {
            scaleX = scaleY = 3;
            _bmpData = new BitmapData(160, 160);
            var bitmap:Bitmap = new Bitmap(_bmpData);
            addChild(bitmap);

            addEventListener(Event.ENTER_FRAME, draw);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, 
                function():void 
                {
                    _downFlg = true;
                }
            );
            stage.addEventListener(MouseEvent.MOUSE_UP, function():void {
                _downFlg = false;
            });
        }
        
        private function draw(e:Event = null):void {
            var x:uint, y:uint, i:uint;
            var color:uint, r:uint, g:uint, b:uint;
            
            for (i = 0; i < _numBlobs; ++i) 
            {
                if(_downFlg){
                    _blogDx[i] += (int)(stage.stageWidth / 2 - stage.mouseX) * 0.0001;
                    _blogDy[i] += (int)(stage.stageHeight / 2 - stage.mouseY) * 0.0001;
                }
                
                _blogPx[i] += _blogDx[i];
                _blogPy[i] += _blogDy[i];
                
                if (_blogPx[i] < 0) {
                    _blogDx[i] = Math.random();
                }
                if (_blogPx[i] > _bmpData.width) {
                    _blogDx[i] = -Math.random();
                }
                if (_blogPy[i] < 0) {
                    _blogDy[i] = Math.random();
                }
                if (_blogPy[i] > _bmpData.height) {
                    _blogDy[i]=-Math.random();
                }
                
                _vx[i] = new Array();
                for (x = 0; x < _bmpData.width; x++) {
                    _vx[i][x] = int(Math.pow(_blogPx[i] - x, 2));
                }

                _vy[i] = new Array();
                for (y = 0; y < _bmpData.height; y++) {
                    _vy[i][y] = int(Math.pow(_blogPy[i] - y, 2));
                }
            }
            
            _bmpData.lock();
            for (y = 0; y < _bmpData.height; y++) {
                for (x = 0; x < _bmpData.width; x++) {
                    var m:int = 1;
                    for (i = 0; i < _numBlobs; i++ ) {
                        m += (60000 * (i + 2) * 3 / _numBlobs) / (_vy[i][y] + _vx[i][x] + 1);
                    }
                    
                    r = Math.min(255, (m + y));
                    g = Math.min(255, (m + x));
                    b = Math.min(255, (x + m + y) / 2);
                    color = r << 16 | g << 8 | b;
                    
                    _bmpData.setPixel(x, y, color);
                }
            }
            _bmpData.unlock();
        }
    }
}
