/**
 * Copyright kenji_clown5 ( http://wonderfl.net/user/kenji_clown5 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rbLp
 */

/*
* 基礎の勉強。
* lineToだけでプヨっとしたシェイプを作ってみる。
* クリックで○と□を切り替えるよ。
* 
* http://twitter.com/#!/kenji_clown5
--------------------------------------------------*/
package    {
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.display.Stage;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    import flash.text.TextField;
    
    [SWF(width = "465", height = "465", frameRate = "60", backgroundColor = "0xffffff")]
    public class Main2 extends Sprite    {
        private var circle:Sprite = new Sprite();  // 円を描画するSprite
        
        public static const particle_n:uint = 1000;  // 構成する点の数
        public static const r:uint = 100;  // 半径
        private static const sp_r:uint = 100;  // 柔らかさ
        private var particles:Array = [];  // 構成する点の位置
        private var defaultPosition:Array = [];  // 構成する点の初期座標
        public static var flg:uint = 0;  // 0:円, 1:四角
        
        public function Main2()    {
            for(var i:uint = 0; i < particle_n; ++i)    {
                particles.push(new Particle(i));  // 構成する点の位置
                defaultPosition.push(new Particle(i));  // 構成する点の初期座標
            }
            circle.x = Math.floor(stage.stageWidth / 2);
            circle.y = Math.floor(stage.stageHeight / 2);
            addChild(circle);
            
            var txt:TextField = new TextField();
            txt.text = "↓ CLICK!";
            txt.x = 200;
            txt.y = 50;
            txt.width = 100;
            txt.height = 15;
            addChild(txt);
            
            circle.addEventListener(Event.ENTER_FRAME, loop);
            circle.addEventListener(MouseEvent.MOUSE_DOWN, changeShape);
        }
        
        // ループ
        private function loop(e:Event):void    {
            var mousePoint:Point = new Point(circle.mouseX, circle.mouseY);  // マウス座標ポイント
            
            for(var i:uint = 0; i < particle_n; ++i)    {
                var spPoint:Point = new Point(defaultPosition[i].x, defaultPosition[i].y);  // 構成する点の初期座標のポイント
                var dis:Number = Point.distance(mousePoint, spPoint);  // 各点とマウスとの距離
                
                if(dis < sp_r)    {
                    var kaku:Number = Math.atan2(spPoint.y - mousePoint.y, spPoint.x - mousePoint.x) + Math.PI;  // マウスと点対象の角度
                    var sp_x:Number = spPoint.x - (sp_r - dis) * Math.cos(kaku);
                    var sp_y:Number = spPoint.y - (sp_r - dis) * Math.sin(kaku);
                }else    {
                    sp_x = defaultPosition[i].x;
                    sp_y = defaultPosition[i].y;
                }
                particles[i].x += (sp_x - particles[i].x) * 0.1;
                particles[i].y += (sp_y - particles[i].y) * 0.1;
            }
            
            setShape();  // 図形描画へ
        }
        
        // 図形を描画
        private function setShape():void    {
            circle.graphics.clear();
            circle.graphics.beginFill(0xffff00, 1);
            circle.graphics.lineStyle(2, 0xff0000, 1);
            circle.graphics.moveTo(particles[0].x, particles[0].y);
            for(var i:uint = 1; i < particle_n; ++i)    {
                circle.graphics.lineTo(particles[i].x, particles[i].y);
            }
            circle.graphics.endFill();
        }
        
        private function changeShape(e:MouseEvent):void    {
            flg++;
            if(flg > 1)    {
                flg = 0;
            }
            for(var i:uint = 0; i < particle_n; ++i)    {
                defaultPosition[i] = new Particle(i);  // 構成する点の初期座標を変更
            }
        }
    }
}

// パーティクルじゃないけど、点の集まりを生成するclass
import Main2;
class Particle    {
    public var x:Number;
    public var y:Number;
    
    public function Particle(n:uint)    {
        if(Main2.flg == 0)    {  // 丸の座標
            var kaku:Number = n / Main2.particle_n * 2 * Math.PI;  // 中心からの角度
            x = Main2.r * Math.cos(kaku);
            y = Main2.r * Math.sin(kaku);
        }else if(Main2.flg == 1)    {  // 四角の座標
            var hen:Number = Main2.r * 2;
            if(n < Main2.particle_n / 4)    {
                x = hen / 2;
                y = hen / (Main2.particle_n / 4) * n - hen / 2;
            }else if(n >= Main2.particle_n / 4 && n < Main2.particle_n / 4 * 2)    {
                x = hen / 2 - hen / (Main2.particle_n / 4) * (n - Main2.particle_n / 4);
                y = hen / 2;
            }else if(n >= Main2.particle_n / 4 * 2 && n < Main2.particle_n / 4 * 3)    {
                x = -hen / 2;
                y = hen / 2 - hen / (Main2.particle_n / 4) * (n - Main2.particle_n / 4 * 2);
            }else    {
                x = hen / (Main2.particle_n / 4) * (n - Main2.particle_n / 4 * 3) - hen / 2;
                y = -hen / 2;
            }
        }
    }
}