/**
 * Copyright agenda23 ( http://wonderfl.net/user/agenda23 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rbAp
 */

/*

[about]
PV3D習得用に
http://www.adamrocker.com/blog/147/papervision3d_sphere_using_tweener.html
から借りてきたやつをゴニョゴニョしたりとか
残像は
http://wonderfl.net/code/82ee9cd66c82066baf94d8c0ea384bc0e97f0ba4
を参考にさせてもらいました。

[usage]
クリックするとゲジゲジします
もいちどクリックすると戻ります
素早くクリックしたりすると頂点がズレます
↑キーと↓キーで動く頂点が変わります
クリックしてから頂点を変更してクリックして戻すと
動く頂点が変わっているのでまたズレます
Rキーを押したらリセットします
動きが止まっていないときにリセットしたら
止まっていない頂点はリセットできずに残ります
マウスホイールをグリグリすると球体のサイズが変わります
フルスクリーンにしないとブラウザがスクロールするのな

[comment]
vertex_selectorが1のときのアニメーションが好みです

*/

package
{
    import flash.display.*;
    import flash.events.*;
	import flash.geom.*;
    import flash.filters.*;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.system.System;
	import flash.text.StyleSheet;
	import flash.text.*;
	import flash.utils.getTimer;
	import flash.ui.Keyboard;
    import org.papervision3d.core.effects.*;
    import org.papervision3d.core.effects.utils.*;
    import org.papervision3d.cameras.Camera3D;
	import org.papervision3d.core.geom.renderables.Vertex3D;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.view.*;
    import org.papervision3d.view.layer.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.special.CompositeMaterial;
	
	import caurina.transitions.*;
	import net.hires.debug.Stats;
	//import org.flashdevelop.utils.FlashConnect;


    [SWF(frameRate=60,backgroundColor=0x000000) ]

    public class Main5 extends Sprite
    {
        private var scene:Scene3D;
        private var viewport:Viewport3D;
        private var camera:Camera3D;
        private var renderer:BasicRenderEngine;
        private var objSphere:Sphere;
		private var gx:Number = 16;
		private var gy:Number = 16;
		private var grad:Number = 80;
		
		private var isTween:Boolean;

		private var key_value:Boolean;
		private var val:Number = 7;
		private var tf:TextField;
		private var str:String = "";
		private var tmpSphere:Sphere;
		private var v:Vertex3D;



        public function Main5()
        {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.quality = StageQuality.LOW;
            init3D();
			addChild(new Stats({ bg: 0x1A1A1A }));
			
			stage.addEventListener(MouseEvent.CLICK, clickObj);
			
			tf = new TextField();
			stage.addChild(tf);
			tf.x = 5;
			tf.y = 120;
			tf.width  = 100;
			tf.height = 20;
			tf.textColor = 0x08FF10;
			tf.multiline = true;
			tf.type = TextFieldType.DYNAMIC;
			tf.text = str;

			
			
			//頂点セレクタ用入力イベント(↑↓キー)
			function keyDownHandler (event:KeyboardEvent):void {
				 if (event.keyCode == Keyboard.UP) {
					key_value = true;
					if (30 > val) {
									val ++;
									}
					tf.text = "vertex_selector : " + String(val);
				//	FlashConnect.trace(val);
				 } else if (event.keyCode == Keyboard.DOWN) {
					key_value = false;
					if (1 < val) {
									val --;
									}
					tf.text = "vertex_selector : " + String(val);
					//FlashConnect.trace(val);
				 } 
				 
			event.updateAfterEvent();  
			}
			stage.addEventListener (KeyboardEvent.KEY_DOWN, keyDownHandler);
			
			//カメラ距離用入力イベント(マウスホイール)
			function mouseWheelHandler (event:MouseEvent):void {
				if (event.delta > 0 ) {
					if(objSphere.scaleX < 4){
					objSphere.scaleX += 0.1;
					objSphere.scaleY += 0.1;
					objSphere.scaleZ += 0.1;
					}
					var scale_num:Number = Math.round(objSphere.scaleX * 10) / 10;
					tf.text = "object_scale : " + String(scale_num);
				}else{
					if(objSphere.scaleX > 0.2){
					objSphere.scaleX -= 0.1;
					objSphere.scaleY -= 0.1;
					objSphere.scaleZ -= 0.1;	
					}
					var scale_num2:Number = Math.round(objSphere.scaleX * 10) / 10;
					tf.text = "object_scale : " + String(scale_num2);
				}
				
			event.updateAfterEvent();  
			}
			stage.addEventListener (MouseEvent.MOUSE_WHEEL, mouseWheelHandler);
			
			
			//頂点リセット用入力イベント(Rキー)
			function keyDownHandler2 (event:KeyboardEvent):void {
				
				 if (event.keyCode == 82) {
					       for each(var v:Vertex3D in objSphere.geometry.vertices) {
							       v.x = v.extra.x0;
							       v.y = v.extra.y0;
							       v.z = v.extra.z0;
							   }
							   isTween = false;
				 }
			event.updateAfterEvent(); 
				}
			
			stage.addEventListener (KeyboardEvent.KEY_DOWN, keyDownHandler2);
			
			
        }
		//描画初期化
        private function init3D():void
        {
            viewport = new Viewport3D(0,0,true);
            viewport.opaqueBackground = 0x000000;
            addChild(viewport);
			
			//残像処理
			var effectLayer:BitmapEffectLayer = new BitmapEffectLayer(viewport, 800, 800,false,0x000000,"crear_pre",true);
            effectLayer.addEffect(new BitmapLayerEffect(new BlurFilter(1.2, 1.2, 1)));
            effectLayer.drawCommand = new BitmapDrawCommand(null, new ColorTransform(1, 1, 1, 0.1,0,0,0,-5), BlendMode.SHADER,false);
            viewport.containerSprite.addLayer(effectLayer);
			
			
			
            renderer = new BasicRenderEngine();

            camera = new Camera3D();
            camera.z = -450;
            camera.focus = 500;
            camera.zoom = 1;

            scene = new Scene3D();

            var colorMat:ColorMaterial = new ColorMaterial( 0x000000, 1 );
            var wireMat:WireframeMaterial = new WireframeMaterial( 0x08FF10 );
            var compoMat:CompositeMaterial = new CompositeMaterial();
            compoMat.addMaterial(colorMat);
            compoMat.addMaterial(wireMat);
            compoMat.doubleSided = false;

            objSphere = new Sphere(compoMat, grad, gx, gy );
            scene.addChild(objSphere);
			

			
			
            effectLayer.addDisplayObject3D(objSphere);

            addEventListener(Event.ENTER_FRAME, onEnterFrame); 
			
            renderer.renderScene(scene, camera, viewport);
			
			
				for each(var v:Vertex3D in objSphere.geometry.vertices) {
				v.extra = {
				x0 : v.x,
				y0 : v.y,
				z0 : v.z
				}
			}
			
        }

        private function onEnterFrame(event:Event):void
        {
			
			
        //    objSphere.rotationY += 2;
              objSphere.rotationY = stage.mouseX;
              objSphere.rotationX = stage.mouseY;
              objSphere.rotationZ += 1;
			  
            renderer.renderScene(scene, camera, viewport);
			
			
			
        }

		
		
    private function clickObj (e:MouseEvent):void {
	  var vertex_selection:Number;
      var num:Number = 1;
	  tf.text = "";
      for each(var i:Vertex3D in objSphere.geometry.vertices) {
		  //頂点選択
        if(num%val == 0) {
          if(isTween) {
            Tweener.addTween(i, { x:i.x*0.5, 
                                  y:i.y*0.5,
                                  z:i.z*0.5,
                                  time:0.5,
                                  delay:0,
                                  transition:"easeInOutElastic"
                                });
          } else {
            Tweener.addTween(i, { x:i.x*2, 
                                  y:i.y*2,
                                  z:i.z*2,
                                  time:1,
                                  delay:Math.random(),
                                  transition:"easeInOutElastic"
                                });
          }
        }
        num++;
      }
      isTween = !isTween;
            renderer.renderScene(scene,camera,viewport);
    }
  }

    }
