/**
 * Copyright leichtgewicht ( http://wonderfl.net/user/leichtgewicht )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rayM
 */

// forked from checkmate's fladdict challenge for professionals
/**
 * Theme:
 * Play with BitmapPatterBuilder.
 * Purpose of this trial is to find the possibility of the dot pattern.
 *
 * by Takayuki Fukatsu aka fladdict
 *
 * Playing with game of life...
 **/
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    import flash.text.TextField;
    import flash.events.Event;
    import flash.filters.ConvolutionFilter;
    import flash.filters.BlurFilter;
    import flash.utils.getTimer;
    
    
    public class Professional extends Sprite {
        
        private static const WIDTH: int = 200;
        private static const HEIGHT: int = 80;
        private static const BACKGROUND_COLOR: Number = 0xFFFFFFFF;
        private static const FOREGROUND_COLOR: Number = 0xFF9900FF;
        
        private var _pattern: Array;
        private var _nextPattern: Array;
        private var _colors: Array;
        private var _nextTime: int = 0;
        
        public function Professional() {
            _colors = [BACKGROUND_COLOR,FOREGROUND_COLOR];
            _pattern = emptyFill();
            _nextPattern = emptyFill();
            stage.scaleMode = StageScaleMode.NO_SCALE;
            addEventListener( Event.ENTER_FRAME, onEnterFrame );
            //filters = [new BlurFilter(6,6,3)];
            scaleX = scaleY = 0.25;
        }
        
        private function emptyFill(): Array
        {
            var pattern: Array = [];
            for( var i: int = 0; i<HEIGHT; i++ )
            {
                var row: Array = [];
                for( var j: int =0; j<WIDTH; j++ )
                {
                    row.push( 0 );
                }
                pattern.push( row );
            }
            return pattern;
        }
        
        private function drawDot( col: int ): void
        {
            var x: int = Math.random()*WIDTH;
            if( x > WIDTH ) x = WIDTH-1;
            var y: int = Math.random()*HEIGHT;
            if( y > HEIGHT ) y = HEIGHT-1;
            var rand: Number = Math.random();
            if( rand > 0.5 ) _pattern[y][x] = col;
            if( x > 0 && rand > 0.25 )
            {
                _pattern[y][x-1] = col;
            }
            if( x < WIDTH-1 && ( rand < 0.25 || rand > 0.5 ) )
            {
                _pattern[y][x+1] = col;
            }
            if( y > 0 && ( rand < 0.5 || rand > 0.75 ) )
            {
                _pattern[y-1][x] = col;
            }
            if( y < HEIGHT-1 && rand < 0.75 )
            {
                _pattern[y+1][x] = col;
            }
        }
        
        private function onEnterFrame( event: Event ): void
        {
            for( var i: int = 0; i<20; i++ )
            {
                // keep it endless
                drawDot(1);
            }
            var newPattern: Array = _nextPattern;
            var w: int = WIDTH/2;
            var h: int = HEIGHT/2;
            var y: int = h;
            while( --y-(-1) )
            {
                var x: int = w;
                while( --x-(-1) )
                {
                    var value: int = _pattern[y][x];
                    var left: int = x-1;
                    if( left < 0 ) left = w-1;
                    var right: int = x+1;
                    if( right > w-1 ) right = 0;
                    var top: int = y-1;
                    if( top < 0 ) top = h-1;
                    var bottom: int = y+1;
                    if( bottom > h-1 ) bottom = 0;
                    var neighbours: int = 
                        _pattern[top][left]+_pattern[top][x]+_pattern[top][right]
                       +_pattern[y][left]+_pattern[y][x]+_pattern[y][right]
                       +_pattern[bottom][left]+_pattern[bottom][x]+_pattern[bottom][right];
                    if( neighbours == 3 )
                    {
                        value = 1;
                    }
                    else
                    if( neighbours < 2 || neighbours > 3 )
                    {
                        value = 0;
                    }
                    newPattern[y][x] = value;
                    newPattern[HEIGHT-1-y][x] = value;
                    newPattern[HEIGHT-1-y][WIDTH-1-x] = value;
                    newPattern[y][WIDTH-1-x] = value;
                }
            }
            _nextPattern = _pattern;
            _pattern = newPattern;
            var g: Graphics = graphics;
            g.clear();
            g.beginBitmapFill( BitmapPatternBuilder.build( _pattern, _colors ) );
            g.drawRect(0,0,480/scaleX,480/scaleY);
            g.endFill();
        }
    }
}

/**-----------------------------------------------------
 * Use following BitmapPatternBuilder class 
 * 
 * DO NOT CHANGE any codes below this comment.
 *
 * -----------------------------------------------------
*/
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Graphics;
    
class BitmapPatternBuilder{
    /**
     * creates BitmapData filled with dot pattern.
     * First parameter is 2d array that contains color index for each pixels;
     * Second parameter contains color reference table.
     *
     * @parameter pattern:Array 2d array that contains color index for each pixel.
     * @parameter colors:Array 1d array that contains color table.
     * @returns BitmapData
     */
    public static function build(pattern:Array, colors:Array):BitmapData{
        var bitmapW:int = pattern[0].length;
        var bitmapH:int = pattern.length;
        var bmd:BitmapData = new BitmapData(bitmapW,bitmapH,true,0x000000);
        for(var yy:int=0; yy<bitmapH; yy++){
            for(var xx:int=0; xx<bitmapW; xx++){
                var color:int = colors[pattern[yy][xx]];
                bmd.setPixel32(xx, yy, color);
            }
        }
        return bmd;
    }
    
    /**
     * short cut function for Graphics.beginBitmapFill with pattern.
     */
    public static function beginBitmapFill(pattern:Array, colors:Array, graphics:Graphics):void{
        var bmd:BitmapData = build(pattern, colors);
        graphics.beginBitmapFill(bmd);
        bmd.dispose();        
    }
}