/**
 * Copyright baudon.thomas ( http://wonderfl.net/user/baudon.thomas )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ranl
 */

package 

{

    import away3d.animators.AnimationSetBase;

    import away3d.containers.View3D;

    import away3d.core.base.Geometry;

    import away3d.entities.Mesh;

    import away3d.materials.ColorMaterial;

    import away3d.primitives.CubeGeometry;

    import away3d.primitives.CylinderGeometry;

    import flash.display.Graphics;

    import flash.display.Sprite;

    import flash.events.Event;

    import flash.events.KeyboardEvent;

    import flash.geom.Vector3D;

    import flash.ui.Keyboard;

    import flash.utils.getTimer;

    

    /**

     * ...

     * @author Thomas BAUDON

     */

    public class Main extends Sprite 

    {

        private var view:View3D;

        private var baseGeometry:CylinderGeometry;

        private var cubeGeometry:CubeGeometry;

        private var baseMesh:Mesh;

        private var greyMat:ColorMaterial;

        private var greenMat:ColorMaterial;

        private var redMat:ColorMaterial;

        private var blueMat:ColorMaterial;

        private var currentCube : Mesh;

        private var arrayMat:Array;

        private var currentColumn : int;

        private var gameState : Vector.<Vector.<uint>>;

        private var towerMaxHeight : uint;

        private var debug : Sprite;

        private var cubeSpeed : Number;

        private var cubeX:int;

        private var cubeY:int;

        
        public function Main():void 

        {

            if (stage) init();

            else addEventListener(Event.ADDED_TO_STAGE, init);

        }

        

        private function init(e:Event = null):void 

        {

            removeEventListener(Event.ADDED_TO_STAGE, init);

            // entry point

            

            this.initGameState();

            this.initAway3d();

            this.createGeometry();

            this.createMaterial();

            this.addBase();

            this.addCube();

            

            this.debug = new Sprite();

            this.addChild(debug);

            

            this.cubeSpeed = 10;

            

            this.stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);

            this.stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);

        }

        

        private function drawDebug() : void

        {

            var g : Graphics = this.debug.graphics;

            g.clear();

            

            for (var i : uint = 0; i < this.gameState.length; ++i)

            {

                for (var j : uint = 0; j < this.gameState[i].length; ++j)

                {

                    g.beginFill((1 - this.gameState[i][j]) * 0xffffff);

                    g.drawRect(j * 5, i * 5, 5,5);

                }

            }

        }

        

        private function initGameState():void 

        {

            this.gameState = new Vector.<Vector.<uint>>();

            this.pushLine();

        }

        

        private function pushLine():void 

        {

            this.gameState.push(new Vector.<uint>());

            for (var i : uint = 0; i < 12; ++i)

            {

                this.gameState[gameState.length - 1].push(0);

            }

        }

        

        private function onKeyDown(e:KeyboardEvent):void 

        {

            var nextColumn : int = 0;

            switch(e.keyCode)

            {

                case Keyboard.LEFT :

                    nextColumn = this.currentColumn - 1;

                    if (nextColumn < 0)

                        nextColumn = 11;

                    if(this.cubeY > this.towerMaxHeight)

                        this.currentColumn = nextColumn;

                    else

                    {

                        if (this.gameState[cubeY][nextColumn] == 0)

                            this.currentColumn = nextColumn;

                    }

                    break;

                    

                case Keyboard.RIGHT :

                    nextColumn  = this.currentColumn + 1;

                    if (nextColumn > 11)

                        nextColumn = 0;

                    if(this.cubeY > this.towerMaxHeight)

                        this.currentColumn = nextColumn;

                    else

                    {

                        if (this.gameState[cubeY][nextColumn] == 0)

                            this.currentColumn = nextColumn;

                    }

                    break

                    break;

            }

        }    

                

        private function addCube():void 

        {

            var idMat : uint = Math.random() * (this.arrayMat.length);

            this.currentCube = new Mesh(this.cubeGeometry, arrayMat[idMat]);

            currentCube.y = 600;

        }

        

        private function onEnterFrame(e:Event):void 

        {

            var camY : uint = 180;

            

            if (!this.view.scene.contains(currentCube))

                this.view.scene.addChild(currentCube);

            

            var rotation : Number = (this.currentColumn * 30 + 15 ) * Math.PI / 180; 

            

            this.view.camera.x = Math.cos(rotation) * 250;

            this.view.camera.z = Math.sin(rotation) * 250;

            this.view.camera.y = -50;

            this.view.camera.lookAt(new Vector3D(0, camY, 0));

            

            if (currentCube)

            {

                var x : Number = this.view.camera.position.x;

                var z : Number = this.view.camera.position.z;

                var lookCube : Vector3D = new Vector3D(x, this.currentCube.y, z);

                currentCube.x = 0;
                currentCube.z = 0;

                currentCube.lookAt(lookCube);

                currentCube.translate(currentCube.forwardVector, 53);



                this.moveCubePos();

            }

            

            this.view.render();

            this.drawDebug();

        }

        

        private function moveCubePos() : void
        {

            if (currentColumn == -1)

                currentColumn = 10;



            cubeX = currentColumn % 12;

            cubeY = (currentCube.y - cubeSpeed - 12) / 16;

            

            if (cubeY <= this.towerMaxHeight)

            {

                if (this.gameState[cubeY][cubeX] != 0 && cubeY >= 0)

                {

                    cubeY++;

                    if (cubeY > this.towerMaxHeight)

                    {

                        this.pushLine();

                        this.towerMaxHeight++;

                    }

                    this.gameState[cubeY][cubeX] = 1;

                    this.currentCube.y = 12  + 16 * cubeY;

                    this.addCube();

    

                }

                else if(cubeY == 0)

                {

                    this.gameState[cubeY][cubeX] = 1;

                    this.currentCube.y = 12 + 16 * cubeY;

                    this.addCube();



                }else {

                    currentCube.translate(new Vector3D(0, -1, 0), this.cubeSpeed);

                }

            }else {

                currentCube.translate(new Vector3D(0, -1, 0), this.cubeSpeed);

            }

        

        }

        

        private function addBase():void 

        {

            this.baseMesh = new Mesh(this.baseGeometry, greyMat);

            this.view.scene.addChild(this.baseMesh);

        }

        

        private function createMaterial() : void

        {

            this.blueMat = new ColorMaterial(0x6633cc);

            this.redMat = new ColorMaterial(0xcc3366);

            this.greenMat = new ColorMaterial(0x33cc66);

            this.greyMat = new ColorMaterial(0x666666);

            

            this.arrayMat = [blueMat, redMat, greenMat];

        }

        

        private function createGeometry():void 

        {

            this.baseGeometry = new CylinderGeometry(64, 64, 8, 12);

            this.cubeGeometry = new CubeGeometry(32, 16, 16);

        }

        

        private function initAway3d():void 

        {

            this.view = new View3D();

            this.addChild(this.view);

        }

        

    }

    

}