/**
 * Copyright lagash ( http://wonderfl.net/user/lagash )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/raju
 */

// forked from dalmacija's 傾斜プラクティス
//傾斜に沿う動き～
//クリックで背景を書き換え

//気になるところ↓
//・マップの端の処理はおかしいかも。
//・計算に正直馬鹿な部分がある。いい具合に簡略化して背景を動かしながらリアルタイム計算にしたい
//・パーティクル同士の判定をこさえたい
//・遅くなりそうな要素がいっぱいあるｗ

package {
    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.display.Bitmap;
	import flash.display.Stage;
	import flash.display.BitmapData;
	import flash.display.DisplayObjectContainer;
	import flash.display.LineScaleMode;
	import flash.display.BlendMode;
	import flash.events.MouseEvent;
	import flash.geom.Matrix;
    import flash.geom.Rectangle;
    import flash.geom.Point;
	import flash.geom.ColorTransform;
	import flash.events.Event;
	import flash.utils.ByteArray;
	import flash.filters.BlurFilter;
	
	//import particle;
	
	import net.hires.debug.Stats;
	
    public class partest extends Sprite {
		var bmp:Bitmap;
		var bmp2:Bitmap;
		var curves:Object;
		var rotationColor:Number;
		
		var baseMatrix: Matrix = new Matrix();
		var baseRect:Rectangle;
		var basePoint:Point;
		var baseColorTransform:ColorTransform;
		
		const maxParticles = 1000;

        static public var forceMap: BitmapData;
        private var COLOR: uint = 0xFFFFFF;
        private var seed: int;
        private var mw: int;
        private var mh: int;
        private var arr: Array;
        private var point: Point;
        private var point2: Point;
        private var colorTf: ColorTransform;
        private var blur: BlurFilter;
		
		private var vecMap:Array;
		
		var frameCounter:Number=0;
		var coefficientOfMass:Number;
		var flg:Boolean;
		
		static public const _TABLE_SIZE:int = 0x10000;
		static public const _PI:Number = Math.PI;
		static public const _RADIANS:Number;// = _DEGREES * (_PI / 180);
		static public const _TWO_PI:Number = 2 * _PI;
		static public const _TWO_PI_SCALE:Number = _TABLE_SIZE / _TWO_PI;
		static public const _HALF_PI:Number = _PI / 2;
		static public const _table:Vector.<Number> = new function ():Vector.<Number>{
			var table:Vector.<Number> = new Vector.<Number>(_TABLE_SIZE, true);
			for (var i:uint = 0; i < _TABLE_SIZE; i++) {
				table[i] = Math.sin(i / _TWO_PI_SCALE);
			}
			return table;
		};
		
		static public var stageWidth;
		static public var stageHeight;
		static public var mouse_X;
		static public var mouse_Y;
		
		private var particles:Vector.<particle>=new Vector.<particle>();
		
        public function partest() {
			super();
			addEventListener(Event.ADDED_TO_STAGE, init);
		}

		private function init(e:Event) {
			stage.frameRate = 30;
			stageWidth = stage.stageWidth;
			stageHeight = stage.stageHeight;
			
			bmp = new Bitmap(new BitmapData(stage.stageWidth, stage.stageHeight, true, 0xff000000), "auto", true);//bitmap処理用
			bmp.alpha = .5;
			bmp2 = new Bitmap(new BitmapData(stage.stageWidth, stage.stageHeight, true, 0xff000000), "auto", true);//bitmap処理用

			basePoint = new Point(0, 0);
			baseRect = new Rectangle(0, 0, stageWidth, stageHeight);
			baseColorTransform = new ColorTransform;
			baseColorTransform.redOffset = baseColorTransform.greenOffset = baseColorTransform.blueOffset = -5;
			
            forceMap = new BitmapData(stageWidth / 2, stageHeight / 2);
			setMap();

			baseMatrix.identity();
			
			stage.addEventListener(MouseEvent.CLICK, mouseClickHandlr);
			//stage.addEventListener(MouseEvent.MOUSE_DOWN, function(e:MouseEvent) { flg = true; } );
			//stage.addEventListener(MouseEvent.MOUSE_UP, function(e:MouseEvent) { flg = false; particles[particles.length - 1].cut = true; } );
			stage.addEventListener(Event.ENTER_FRAME, enterframeHandlr);
			
			addChild(bmp2);
			addChild(bmp);
			addChild(new Stats());
			
			for (var i = 0; i < maxParticles; i++) {
				if(i!=0){particles.push(new particle(stage.stageWidth*Math.random(),stage.stageHeight*Math.random(), particles.length, particles[particles.length-1]));}else{particles.push(new particle(stage.stageWidth*Math.random(),stage.stageHeight*Math.random(),0));}
			}
			
		}
		

		private function mouseClickHandlr(e) {
                    setMap();
		}

		
		private function enterframeHandlr(e)
		{
			frameCounter+=.01;
			coefficientOfMass = (_table[(frameCounter * _TWO_PI_SCALE) & (_TABLE_SIZE - 1)]*_table[(frameCounter * _TWO_PI_SCALE) & (_TABLE_SIZE - 1)])*3;
			
                        
			mouse_X = e.currentTarget.mouseX;
			mouse_Y = e.currentTarget.mouseY;
			var flg_2 = 0;
			bmp.bitmapData.lock();
			
            var col: uint;
            
			for (var i = 0; i < particles.length; i++) {
				var tmpObj = particles[i];
				
				col = i/maxParticles*0x99;
				col = 0x10000 * (col * 0xaa) + 0x100 * (col * 0xaa) + (col * 0x88);
				
				tmpObj.dx = vecMap[int(tmpObj.xx >> 1)][int(tmpObj.yy >> 1)].x*.0000005;
				tmpObj.dy = vecMap[int(tmpObj.xx >> 1)][int(tmpObj.yy >> 1)].y*.0000005;
				
				tmpObj.tx = tmpObj.tx*.999+(tmpObj.dx * uint(tmpObj.dx > 0 && tmpObj.tx < 4) + tmpObj.dx * uint(tmpObj.dx<0 && tmpObj.tx>-4));
				tmpObj.ty = tmpObj.ty*.999+(tmpObj.dy * uint(tmpObj.dy > 0 && tmpObj.ty < 4) + tmpObj.dy * uint(tmpObj.dy<0 && tmpObj.ty>-4));

				tmpObj.xx += tmpObj.tx;
				tmpObj.yy += tmpObj.ty;

				if (tmpObj.xx < 0 || tmpObj.xx >= stageWidth) { tmpObj.xx = int(tmpObj.tx < 0) * (stageWidth-1);}
				if (tmpObj.yy < 0 || tmpObj.yy >= stageHeight) { tmpObj.yy = int(tmpObj.ty < 0) * (stageHeight-1);}
					
					bmp.bitmapData.setPixel(tmpObj.xx, tmpObj.yy, col );
					//bmp.bitmapData.setPixel(tmpObj.xx-1, tmpObj.yy-1, col);
					//bmp.bitmapData.setPixel(tmpObj.xx, tmpObj.yy-1, col);
					//bmp.bitmapData.setPixel(tmpObj.xx, tmpObj.yy-2, col);
					//bmp.bitmapData.setPixel(tmpObj.xx+1, tmpObj.yy-1, col);
					//bmp.bitmapData.setPixel(tmpObj.xx-1, tmpObj.yy+1, col);
					//bmp.bitmapData.setPixel(tmpObj.xx, tmpObj.yy+1, col);
					//bmp.bitmapData.setPixel(tmpObj.xx, tmpObj.yy+2, col);
					//bmp.bitmapData.setPixel(tmpObj.xx+1, tmpObj.yy+1, col);
					//bmp.bitmapData.setPixel(tmpObj.xx-1, tmpObj.yy, col);
					//bmp.bitmapData.setPixel(tmpObj.xx-2, tmpObj.yy, col);
					//bmp.bitmapData.setPixel(tmpObj.xx+1, tmpObj.yy, col);
					//bmp.bitmapData.setPixel(tmpObj.xx+2, tmpObj.yy, col);
				
			}
			
			bmp.bitmapData.colorTransform(baseRect, baseColorTransform);
			bmp.bitmapData.unlock();
			
			
			if (!flg && flg_2==0 || (mouse_X<0 || mouse_X>stageWidth || mouse_Y<0 || mouse_Y>stageHeight)) return;
			if (particles.length > 0) {
				
				do{
					var newX = mouse_X + (Math.random() * 100-50) * flg_2;
					var newY = mouse_Y + (Math.random() * 100-50) * flg_2;
				}while (newX<0 || newX>stageWidth || newY<0 || newY>stageHeight);
				
				particles.push(new particle(newX,newY, particles.length, particles[particles.length-1]));
				particles[0].setObj(particles[particles.length-1]);
			} else {
				
				particles.push(new particle(mouse_X,mouse_Y,0));

			}
			if (particles.length > maxParticles) {
				particles.shift();
			}

		}
		
                function setMap():void{
             forceMap.perlinNoise(mw = forceMap.width >> 2, mh = forceMap.height >> 2, 4, 
                seed = Math.random() * 0xFFFF, true, true, 1);
            arr = [point = new Point(), point2 = new Point()];
			
			vecMap = new Array();
			
			for (var i = 0; i < stageWidth; i++) { vecMap[i] = new Array();
				for (var j = 0; j < stageHeight; j++) {
					var col = forceMap.getPixel(i >> 1, j >> 1);
					bmp2.bitmapData.setPixel(i, j, col);
					
					var dx = 0;
					var dy = 0;
					
					for (var py = -1; py < 2; py++){
						for (var px = -1; px < 2; px++) {
							
							if (px == 0 && py == 0) continue;
							
							var ppx = i + px;
							var ppy = j + py;
							
							if (ppx < 0 || ppx >= stageWidth) { ppx = int(ppx<0)* (stageWidth-1); }
							if (ppy < 0 || ppy >= stageHeight){ ppy = int(ppy<0)* (stageHeight-1);}
							
							var tmpcol = forceMap.getPixel(ppx >> 1, ppy >> 1);
							
							if (px*px + py*py == 1) {
								dx += (col - tmpcol) * px;
								dy += (col - tmpcol) * py;
							}else {
								dx += (col - tmpcol) * px*.7;
								dy += (col - tmpcol) * py*.7;
							}
						}
					}
					vecMap[i][j]=new Point(dx, dy);
				}	
			};

			bmp2.bitmapData.draw(bmp2,null,null,BlendMode.HARDLIGHT);
                   
                }
		
		
		function getLineLength(p:Rectangle):Number
		{
			var vx=p.x-p.width;
			var vy=p.y-p.height;
			var vl=Math.sqrt(Math.pow(vx,2)+Math.pow(vy,2));
			return vl;
		}
		
    }
}


	class particle{
		
		var col:uint = 0;
		var ox:Number=0;
		var oy:Number=0;
		var ol:Number=0;
		var xx:Number=0;
		var yy:Number=0;
		var _x:Number=0;
		var _y:Number=0;
		var tx:Number=0;
		var ty:Number=0;
		var dx:Number=0;
		var dy:Number=0;
		var dl:Number = 0;
		var M:Number=1;
		var cnt:Number=0;
		var obj:particle;
		var cut:Boolean = false;
		var mv:uint;
		var name:String;

		public function particle(... args):void {
			
			ox= xx = args[0];
			oy= yy = args[1];
			name = args[2];
			obj = args[3];
			
			if (args[3]==undefined)obj = this;
			
			var tmptime = new Date();
			cnt = tmptime.milliseconds * .002 * Math.PI;
			tx = 0;//partest._table[((cnt + partest._HALF_PI) * partest._TWO_PI_SCALE) & (partest._TABLE_SIZE - 1)]*3;
			ty = 0;//partest._table[(cnt * partest._TWO_PI_SCALE) & (partest._TABLE_SIZE - 1)]*3;
			col = 0;//Math.random() * 16777215;
			
		}
		
		
		public function setObj(o):void {
			obj = o;
		}
		

	}