/**
 * Copyright tsu_droid ( http://wonderfl.net/user/tsu_droid )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/radi
 */

// forked from buha903's forked from: 2009-3-12 電光掲示板
// forked from hikipuro's 2009-3-12 電光掲示板
// 日本語のテスト
package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.GradientType;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Matrix;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    
    /**
     * 電光掲示板のテスト
     */
    [SWF(width="320", height="240", backgroundColor="0x000000", frameRate="10")]
    public class Main extends Sprite 
    {
        /**
         * 文字列のピクセルを入れるビットマップデータ
         */
        private var data:BitmapData;
        
        /**
         * 1 フレーム経過するごとに一定量ずつ値を足す
         * スクロール値に使用
         */
        private var frameCount:int;
        
        /**
         * 電光掲示板に表示する内容が入ったテキストフィールド
         */
        private var textField:TextField;
        
        /**
         * テキストフィールドのピクセルを取得する時に使うスプライト
         */
        private var sourceSprite:Sprite;
        
        /**
         * コンストラクタ
         */
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        /**
         * 初期化イベント
         * @param    e
         */
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point 
            
            // スプライトの初期化
            sourceSprite = new Sprite();
            
            textField = new TextField();
            textField.autoSize = TextFieldAutoSize.LEFT;
            textField.height = 20;
            textField.background = true;
            textField.backgroundColor = 0x000000;
            textField.x = -1;
            textField.y = -2;
            textField.text = "英ＢＢＣ放送によると、民主化を訴えるエルバラダイ国際原子力機関（ＩＡＥＡ）前事務局長";
            
            var format:TextFormat = new TextFormat();
            format.color = 0x0000FF;
            format.size = 15;
            // 文字の隙間
            format.letterSpacing = 1;
            textField.setTextFormat(format);
            
            // スプライトにテキストフィールドを登録
            sourceSprite.addChild(textField);
            
            // 文字のピクセルが入ったビットマップデータを準備
            data = new BitmapData(textField.width, 16);
            data.draw(sourceSprite);
            
            // アンチエイリアスがかかったフォントで文字が抜けてしまうので、
            // 閾値を超えたピクセルは表示するようにする
            for (var y:int = 0; y < data.height; y++)
            {
                for (var x:int = 0; x < data.width; x++)
                {
                    var color:uint = data.getPixel(x, y);
                    
                    if (color >= 0x000040)
                        data.setPixel(x, y, 0xFF);
                    else
                        data.setPixel(x, y, 0);
                }                
            }
            
            // テキストフィールドを画面に表示する
            addChild(sourceSprite);
            
            // 初期スクロール値を設定
            frameCount = -31;
            
            // フレーム開始イベントの登録
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        /**
         * フレーム開始イベント
         * @param    event
         */
        private function onEnterFrame(event:Event):void 
        {
            // フレーム数のカウント
            frameCount++;
            
            // 文字列サイズを超えたら初期値にする
            if (frameCount > data.width)
                frameCount = -31;
            
            // 画面に描かれた内容をいったんクリア
            graphics.clear();
            
            for (var y:int = 0; y < 16; y++)
            {
                for (var x:int = 0; x < 31; x++)
                {
                    var pixel:uint;
                    
                    // 表示範囲を超えていたら強制的に OFF
                    if (x + frameCount < 0 || x + frameCount > data.width - 1)
                        pixel = 0;
                    else
                        pixel = data.getPixel(x + frameCount, y);
                    
                    if (pixel != 0)
                        drawDot(10 + x * 10, 40 + y * 10, 4.5, 0xFF0000, 0x800000);
                    else
                        drawDot(10 + x * 10, 40 + y * 10, 4.5, 0x600000, 0x400000);
                }
            }
        }
        
        /**
         * 点を描く
         * @param    x            点の中心の X 座標
         * @param    y            点の中心の Y 座標
         * @param    size        点の大きさ
         * @param    colorLight    明るい場所の色
         * @param    colorDark    暗い場所の色
         */
        private function drawDot(x:Number, y:Number, size:Number, colorLight:uint, colorDark:uint):void
        {
            var colors:Array = [colorLight, colorDark];
            var alphas:Array = [1.0, 1.0];
            var ratios:Array = [0, 255];
            var matrix:Matrix = new Matrix();
            matrix.createGradientBox(size * 2, 
                                     size * 2, 
                                     0,
                                     x - size,
                                     y - size);
            
            graphics.lineStyle();
            graphics.beginGradientFill(GradientType.RADIAL, 
                                        colors,
                                        alphas,
                                        ratios,
                                        matrix);
            graphics.drawCircle(x, y, size);
            graphics.endFill();    
        }
        
    }
    
}