/**
 * Copyright arzo ( http://wonderfl.net/user/arzo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rZyg
 */

// forked from ton's fire test
package {
    import flash.events.MouseEvent;
    import flash.display.Sprite;
    import flash.events.Event;
    import net.hires.debug.Stats;
    
    [SWF(width=465,height=465,frameRate=60)]
    public class Main extends Sprite {
        
        private var fire:Fire;
        
        public function Main() {
            fire = new Fire();
            fire.fireX = 200;
            fire.fireY = 400;
            
            addChild(fire);
            
            addChild(new Stats());
            
            stage.addEventListener(MouseEvent.MOUSE_MOVE, update);
        }
        
        private function update(e:Event):void {
            fire.fireX = mouseX;
            fire.fireY = mouseY;
        }
    }
}

import flash.display.Shape;
import flash.display.Sprite;
import flash.events.Event;
import flash.filters.BlurFilter;
import frocessing.color.ColorHSV;

class Fire extends Sprite {
    private static const FRAME_CREATE_PARTICLE_N:int = 3;
    
    private var particles:Vector.<Shape>;
    
    private var color:ColorHSV;
    
    private var _fireX:Number = 0;
    private var _fireY:Number = 0;
    
    public function Fire() {
        particles = new Vector.<Shape>(false);
        
        color = new ColorHSV();
        
        this.filters = [new BlurFilter(4, 16, 1)];
        
        addEventListener(Event.ENTER_FRAME, update);
    }
    
    private function update(e:Event):void {
        createParticles();
        moveParticles();
    }
    
    private function createParticles():void {
        for (var i:int = 0; i < FRAME_CREATE_PARTICLE_N; i++) {
            var p:Shape = new Shape();
            color.h = Math.random() * 15;
            color.v = Math.random() * 0.7 + 0.3;
            p.graphics.beginFill(color.toRGB().value);
            p.graphics.drawCircle(0, 0, Math.random() * 10 + 20);
            p.graphics.endFill();
            p.alpha = Math.random() * 0.5 + 0.5;
            p.blendMode = "add";
            p.x = _fireX + Math.random() * 40 - 20;
            p.y = _fireY + Math.random() * 10 - 5;
            particles.push(p);
            addChild(p);
        }
    }
    
    private function moveParticles():void {
        for each (var p:Shape in particles) {
            
            p.alpha -= Math.random() * 0.02;
            
            p.x += Math.random() * 2 - 1;
            p.y -= 5;
            
            p.scaleX -= Math.random() * 0.05;
            p.scaleY = p.scaleX;
            
            if (p.scaleX <= 0) {
                removeChild(p);
                particles.splice(particles.indexOf(p), 1);
            }
        }
    }
    
    public function get fireX():Number {
        return _fireX;
    }
    
    public function set fireX(value:Number):void {
        _fireX = value;
    }
    
    public function get fireY():Number {
        return _fireY;
    }
    
    public function set fireY(value:Number):void {
        _fireY = value;
    }

}