/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rZgA
 */

package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    
    /**
     * ...
     * @author umhr
     */
    public class WonderflMain extends Sprite 
    {
        
        public function WonderflMain() 
        {
            init();
        }
        private function init():void 
        {
            if (stage) onInit();
            else addEventListener(Event.ADDED_TO_STAGE, onInit);
        }
        
        private function onInit(event:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, onInit);
            // entry point
            
            addChild(new Canvas());
        }
        
        
    }
    
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Shape;
import flash.display.Sprite;
import flash.events.TimerEvent;
import flash.utils.Timer;
/**
 * ...
 * @author umhr
 */
class Canvas extends Sprite 
 {
    
    private var sample:Bitmap = new Bitmap(new BitmapData(465, 465, false, 0xFFFFFFFF));
    public function Canvas() 
    {
        init();
    }
    
    private function init():void 
    {
        addChild(sample);
        
        check();
        var timer:Timer = new Timer(1000);
        timer.addEventListener(TimerEvent.TIMER, onTimer);
        timer.start();
    }
    
    private function onTimer(event:TimerEvent):void 
    {
        check();
    }
    
    private function check():void {
        var i:int;
        var r:int;
        sample.bitmapData.fillRect(sample.bitmapData.rect, 0xFFFFFF);
        
        var shape0:Shape = new Shape();
        for (i = 0; i < 3; i++) 
        {
            r = 100 * Math.random() + 50;
            shape0.graphics.beginFill(0x000000);
            shape0.graphics.drawCircle((465 - r * 2) * Math.random() + r, (465 - r * 2) * Math.random() + r, r);
            shape0.graphics.endFill();
        }
        
        var date:Date = new Date();
        
        var thete:Number = (date.getSeconds() / 60) * 2 * Math.PI;
        
        shape0.graphics.beginFill(0xFF0000);
        shape0.graphics.drawCircle(465*0.5+Math.sin(thete)*200, 465*0.5-Math.cos(thete)*200, 20);
        shape0.graphics.endFill();
        
        thete = (date.getMinutes() / 60) * 2 * Math.PI;
        shape0.graphics.beginFill(0xFF0000);
        shape0.graphics.drawCircle(465*0.5+Math.sin(thete)*150, 465*0.5-Math.cos(thete)*150, 30);
        shape0.graphics.endFill();
        
        thete = (date.getHours() / 12 + (date.getMinutes() /60)/12) * 2 * Math.PI;
        shape0.graphics.beginFill(0xFF0000);
        shape0.graphics.drawCircle(465*0.5+Math.sin(thete)*80, 465*0.5-Math.cos(thete)*80, 40);
        shape0.graphics.endFill();
        
        
        sample.bitmapData.draw(shape0);
        
        var widthList:Array = [30, 20, 10];
        var limitList:Array = [300, 750, 2000];
        var nullCount:int;
        var totalCount:int = 0;
        
        var time:Number = new Date().time;
        
        var n:int = widthList.length;
        for (var j:int = 0; j < n; j++) 
        {
            r = widthList[j];
            nullCount = 0;
            
            var imgCount:int = 0;
            for (i = 0; i < 3000; i++) 
            {
                
                var tx:Number = Math.random() * (sample.width - r*2) + r;
                var ty:Number = Math.random() * (sample.height - r*2) + r;
                
                if (checker(tx, ty, r)) {
                    var shape:Shape = new Shape();
                    shape.graphics.beginFill(0xFFFFFF, 1);
                    shape.graphics.drawCircle(tx, ty, r);
                    shape.graphics.endFill();
                    sample.bitmapData.draw(shape);
                    nullCount = 0;
                    imgCount ++;
                }else {
                    nullCount ++;
                    if (nullCount > limitList[j]) {
                        break;
                    }
                }
                
            }
            totalCount += imgCount;
        }
    }
    
    private function checker(tx:Number, ty:Number, r:int):Boolean {
        
        if(sample.bitmapData.getPixel(tx, ty) > 0){
            return false;
        }
        var theta:Number
        var n:int = 12;
        for (var i:int = 0; i < n; i++) 
        {
            theta = (i / n) * Math.PI * 2;
            if(sample.bitmapData.getPixel(Math.cos(theta) * r + tx, Math.sin(theta) * r + ty) > 0){
                return false;
            }
            
        }
        
        return true;
    }
    
}
