/**
 * Copyright jozefchutka ( http://wonderfl.net/user/jozefchutka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rZAu
 */

// forked from jozefchutka's Brownian motion
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    [SWF(width="465", height="465", frameRate="30", backgroundColor="#FFFFFF")]
    
    public class Brownian extends Sprite
    {
        public static const W:uint = 465;
        public static const H:uint = 465;
        
        private var lastMouseX:int = -1;
        private var lastMouseY:int = -1;
        private var bitmap:Bitmap = new Bitmap();
        
        public function Brownian()
        {
            super();
            
            stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseMove);
            addEventListener(Event.ENTER_FRAME, enterFrame);
            addChild(bitmap);
            bitmap.bitmapData = new BitmapData(W, H, true);
            for(var i:uint = 0; i < 10; i++)
                addChild(new GuideParticle(Math.random() * W, Math.random() * H));
        }
        
        private function mouseMove(event:MouseEvent):void
        {
            if(lastMouseX != -1 && lastMouseY != -1)
            {
                var dx:Number = lastMouseX - mouseX;
                var dy:Number = lastMouseY - mouseY;
                var speed:Number = Math.sqrt(dx * dx + dy * dy);
                generateRunParticle(mouseX, mouseY, speed);
            }
            lastMouseX = mouseX;
            lastMouseY = mouseY;
        }
        
        public function generateRunParticle(x:Number, y:Number, speed:Number)
            :void
        {
            var particle:RunParticle = new RunParticle(x, y, speed);
            addChild(particle);
        }
        
        private function enterFrame(event:Event):void
        {
            var speed:Number, dx:Number, dy:Number;
            for each(var particle:GuideParticle in GuideParticle.list)
            {
                dx = particle.x - particle.lastX;
                dy = particle.y - particle.lastY;
                speed = Math.sqrt(dx * dx + dy * dy);
                generateRunParticle(particle.x, particle.y, speed);
            }
            
            var shape:Shape = new Shape();
            shape.graphics.beginFill(0xFFFFFF, 0.49);
            shape.graphics.drawRect(0, 0, W, H);
            bitmap.bitmapData.draw(shape, null, null, BlendMode.ERASE);
            bitmap.bitmapData.draw(this);
        }
    }
}

import flash.display.Shape;
import flash.events.Event;
import flash.events.TimerEvent;
import flash.utils.Timer;
import __AS3__.vec.Vector;

internal class Particle extends Shape
{
    private static const MAX_SPEED:Number = 1;
    private static const ACCELERATION:Number = 20;
    
    private var targetSpeedX:Number = 0;
    private var targetSpeedY:Number = 0;
    
    private var speedX:Number = 0;
    private var speedY:Number = 0;
    
    private var timer:Timer = new Timer(1000);
    
    public function Particle():void
    {
        addEventListener(Event.ENTER_FRAME, enterFrame);
        timer.addEventListener(TimerEvent.TIMER, changeSpeed);
        timer.start();
        changeSpeed();
    }
    
    protected function enterFrame(event:Event):void
    {
        speedX += (targetSpeedX - speedX) / ACCELERATION;
        speedY += (targetSpeedY - speedY) / ACCELERATION;
        x += speedX;
        y += speedY;
    }
    
    private function changeSpeed(... rest):void
    {
        targetSpeedX = Math.random() * MAX_SPEED * 2 - MAX_SPEED;
        targetSpeedY = Math.random() * MAX_SPEED * 2 - MAX_SPEED;
    }
    
    protected function destroy():void
    {
        timer.stop();
        timer.removeEventListener(TimerEvent.TIMER, changeSpeed);
        removeEventListener(Event.ENTER_FRAME, enterFrame);
        parent.removeChild(this);
    }
}

internal class GuideParticle extends Particle
{
    public static var list:Vector.<GuideParticle> = new Vector.<GuideParticle>();
    public var lastX:int = -1;
    public var lastY:int = -1;
    
    public function GuideParticle(x:Number, y:Number):void
    {
        this.x = x;
        this.y = y;
        
        graphics.beginFill(0x0, 1);
        graphics.drawCircle(0, 0, 1);
        graphics.endFill();
        
        list.push(this);
    }
    
    override protected function enterFrame(event:Event):void
    {
        lastX = x;
        lastY = y;
        super.enterFrame(event);
        if(x > Brownian.W)
            x -= Brownian.W;
        if(x < 0)
            x += Brownian.H;
        if(y > Brownian.H)
            y -= Brownian.H;
        if(y < 0)
            y += Brownian.H;
    }
    
    override protected function destroy():void
    {
        super.destroy();
        list.splice(list.indexOf(this), 1);
    }
}

internal class RunParticle extends Particle
{
    public static var list:Vector.<RunParticle> = new Vector.<RunParticle>();
    public var radius:Number = 0;
    public var color:uint = 0;
    
    private static const DEALPHA:Number = 0.99; //0.9999;
    
    public function RunParticle(x:Number, y:Number, speed:Number):void
    {
        super();
        this.x = x;
        this.y = y;
        color = speed * 10000;
        radius = 0.5;
        
        graphics.beginFill(color, 1);
        graphics.drawCircle(0, 0, radius);
        graphics.endFill();
        
        list.push(this);
    }
    
    override protected function enterFrame(event:Event):void
    {
        super.enterFrame(event);
        alpha *= DEALPHA;
        if(alpha < 0.05)
            destroy();
    }
    
    override protected function destroy():void
    {
        super.destroy();
        list.splice(list.indexOf(this), 1);
    }
}