/**
 * Copyright ug24k8 ( http://wonderfl.net/user/ug24k8 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rZ6A
 */

// forked from ProjectNya's Math.random() で 0 は出るのか？ (1)
////////////////////////////////////////////////////////////////////////////////
// Math.random() で 0 は出るのか？ (1)
////////////////////////////////////////////////////////////////////////////////

package {
    import flash.display.Bitmap;

    import flash.display.Sprite;
    import flash.utils.Timer;
    import flash.events.TimerEvent;

    [SWF(backgroundColor="#FFFFFF", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var label:Label;
        private var timer:Timer;
        private var count:Vector.<int>;
        private var graph:Sprite;

        public function Main() {
            //Wonderfl.capture_delay(1);
            init();
        }

        private function init():void {
            var wondflcolor:WonderflColor = new WonderflColor(465, 465);
            addChild(wondflcolor);
            // グラフ追加
            graph = addChild(new Sprite()) as Sprite;
            graph.graphics.lineStyle(1, 0xff0000, 0.1);
            count = new Vector.<int>(465, true);
            
            //
            label = new Label(200, 20, 20, Label.CENTER);
            addChild(label);
            label.x = 132;
            label.y = 212;
            label.textColor = 0xFFFFFF;
            label.text = "計算中...";
            //
            timer = new Timer(1);
            timer.addEventListener(TimerEvent.TIMER, update, false, 0, true);
            timer.start();
        }
        private function update(evt:TimerEvent):void {
            var count:uint = evt.target.currentCount;
            var n:Number = Math.random();
            label.text = count + " 回目\n(" + n + ")";
            var x:int = n * 465;
            ++Vector.<int>[x];
            var h:int = Vector.<int>[x];
            graph.graphics.moveTo(x, 465);
            graph.graphics.lineTo(x, 465 - h);
            if (n == 0) {
                timer.stop();
                timer.removeEventListener(TimerEvent.TIMER, update);
                label.text = count + " 回目で 0 が出た！";
            }
        }
        
    }

}


//////////////////////////////////////////////////
// Labelクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.TextFieldAutoSize;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;

class Label extends Sprite {
    private var txt:TextField;
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 20;
    private var _height:uint = 20;
    private var size:uint = 12;
    public static const LEFT:String = TextFormatAlign.LEFT;
    public static const CENTER:String = TextFormatAlign.CENTER;
    public static const RIGHT:String = TextFormatAlign.RIGHT;

    public function Label(w:uint, h:uint, s:uint = 12, align:String = LEFT) {
        _width = w;
        _height = h;
        size = s;
        draw(align);
    }

    private function draw(align:String):void {
        txt = new TextField();
        addChild(txt);
        txt.width = _width;
        txt.height = _height;
        txt.autoSize = align;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = size;
        tf.align = align;
        txt.defaultTextFormat = tf;
        textColor = 0x000000;
    }
    public function set text(param:String):void {
        txt.text = param;
    }
    public function set textColor(param:uint):void {
        txt.textColor = param;
    }

}


//////////////////////////////////////////////////
// WonderflColorクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.geom.Matrix;
import flash.display.GradientType;
import flash.display.SpreadMethod;
import flash.display.InterpolationMethod;

class WonderflColor extends Sprite {
    private var color1:uint = 0x00AAE4;
    private var color2:uint = 0x0069A0;

    public function WonderflColor(w:uint, h:uint) {
        draw(w, h);
    }

    private function draw(w:uint, h:uint):void {
        var colors:Array = [color1, color2];
        var alphas:Array = [1, 1];
        var ratios:Array = [0, 255];
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(w*1.5, h*1.5, 0, -w*0.25, -h*0.25);
        graphics.beginGradientFill(GradientType.RADIAL, colors, alphas, ratios, matrix, SpreadMethod.PAD, InterpolationMethod.RGB, 0);
        graphics.drawRect(0, 0, w, h);
        graphics.endFill();
    }

}
