/**
 * Copyright toburau ( http://wonderfl.net/user/toburau )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rYpX
 */

package {
    import flash.display.*;
    import flash.events.*;
    import frocessing.color.ColorHSV;

    [SWF(width="465", height="465", backgroundColor="0x000000", frameRate="60")]

    public class circles extends Sprite {
        private var m_count:int = 0;
        private var color:ColorHSV;

        public function circles() {
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            color = new ColorHSV(0);
            color.h = 0;
        }
        public function onEnterFrame(e:Event):void {
            if(m_count == 0) {
                var dir:int = 0;
                
                if(Math.random() > 0.5) dir=1;
                if(dir==0) {
                    addChild(new parts(dir, color.value));
                } else {
                    addChildAt(new parts(dir, color.value), 0);
                }
                m_count = Math.round(Math.random()*10)+1;
                color.h++;
            }
            m_count--;
        }
    }
}

import flash.display.Sprite;
import flash.display.BlendMode;
import flash.events.Event;
import flash.filters.GlowFilter;
import flash.filters.BlurFilter;
import flash.geom.ColorTransform;

class parts extends Sprite {
    private var m_size:int = 0;
    private var m_speed:int = 0;
    public function parts(dir:int, col:int) {
        var blur:int = 0;
        var colrate:Number = 1.0;
        m_size = Math.round(Math.random()*20) + 10;
        m_speed = Math.round(Math.random()*5)+1;
        y = Math.round(Math.random()*465);
        if(dir==1) {
            m_speed *= -1;
            x = 465+m_size;
            blur = 8;
            colrate = 0.7;
        } else {
            x = -m_size;
            blur = 4;
            colrate = 1.0;
        }
        graphics.clear();
        graphics.beginFill(col);
        graphics.drawCircle(0,0,m_size);
        graphics.endFill();
        filters = [new GlowFilter(col, 1, 10, 10), new BlurFilter(blur, blur)];
        transform.colorTransform = new ColorTransform(colrate,colrate,colrate);
        blendMode = BlendMode.ADD;
        addEventListener(Event.ENTER_FRAME, update);
    }
    public function update(e:Event):void {
        x += m_speed;
        if( (m_speed>0 && x >= 465+m_size) ||
            (m_speed<0 && x < -m_size) ) {
            removeEventListener(Event.ENTER_FRAME, update);
            parent.removeChild(this);
        } else {
            var s:Number = m_speed < 0 ? -0.7 : 0.7;
            scaleX = scaleY = 1.0 + s*Math.sin(x/465*Math.PI);
        }
    }
}