/**
 * Copyright fukt ( http://wonderfl.net/user/fukt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rYMR
 */

// forked from mahjunkz's flash on 2011-6-7
package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.SampleDataEvent;
    import flash.filters.*;
    import flash.geom.*;
    import flash.media.Sound;
    
    /**
     * ...
     */
    
    [SWF(width="1024", height="576", frameRate="30", backgroundColor="#000000")]
    public class LiquidBalls extends Sprite 
    {
        
        public function LiquidBalls():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        protected var compo:Sprite;
        protected var hud:Sprite;
        protected var canvas:BitmapData;
        
        protected var balls:Vector.<Ball>;
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            //stage
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.quality = StageQuality.LOW;
            
            //containers
            stg = new Rectangle(0, 0, 1024, 576);
            canvas = new BitmapData(stg.width, stg.height, false);
            tmpbmp = new BitmapData(stg.width, stg.height, false);
            addChild(new Bitmap(canvas));
            
            hud = new Sprite;
            addChild(hud);
            
            compo = new Sprite;
            compo.filters = [new DropShadowFilter(0,0,0,1,80,80,3)];
            
            balls = new Vector.<Ball>;
            for (var i:int = 0; i < 15; i++)
                    balls.push(compo.addChild(
                    new Ball(stg, stg.width/2, stg.height/2)));
            
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onStageMouseDown);
            
            initSnd();
            
            addEventListener(Event.ENTER_FRAME, onFrame);
        }
        
        protected var snd:Sound;
        protected function initSnd():void
        {
            snd = new Sound;
            snd.addEventListener(SampleDataEvent.SAMPLE_DATA, onSndSeed);
            snd.play();
        }
        
        protected const VOL:Number = .4;
        protected const highFreq:Number = 1;
        protected const lowFreq:Number = .05;
        protected var freq:Number = 0;
        
        protected function onSndSeed(event:SampleDataEvent):void
        {
            for ( var c:int=0; c<8192; c++ ) {
                //event.data.writeFloat(Math.sin((Number(c+event.position)/Math.PI/2))*0.4);
                //event.data.writeFloat(Math.sin((Number(c+event.position)/Math.PI/2))*0.4);
                
                event.data.writeFloat(Math.sin((Number(c + event.position) / Math.PI * freq)) * VOL);
                event.data.writeFloat(Math.sin((Number(c + event.position) / Math.PI * freq)) * VOL);
            }
        }
        
        private function onStageMouseDown(e:MouseEvent):void 
        {
            if (!stg.containsPoint(new Point(mouseX, mouseY))) return;
            
            for (var i:int = 0; i < 5; i++)
                    balls.push(compo.addChild(
                    new Ball(stg, mouseX, mouseY)));
        }
        
        protected var tmpbmp:BitmapData;
        protected var stg:Rectangle;
        
        private var funPixelsPerc:Number = 0;
        
        protected function onFrame(e:Event = null):void 
        {
            tmpbmp.fillRect(tmpbmp.rect, 0xFFFFFF);
            tmpbmp.draw(compo);
            
            canvas.fillRect(canvas.rect, 0xFFFFFF);
            canvas.threshold(tmpbmp, canvas.rect, new Point,
                    '<', 0x050505, 0x000000FF, 0xFFFFFF, false);
            
            
            var nPixels:uint = canvas.rect.width * canvas.rect.height;
            funPixelsPerc = canvas.histogram(canvas.rect)[0][0] / nPixels;
            freq = lowFreq + (highFreq - lowFreq) * (funPixelsPerc);
            trace(funPixelsPerc);
            
            // draw red indicators
            
            hud.graphics.clear();
            var b:Ball;
            for each(b in balls)
            {
                hud.graphics.lineStyle(1, 0x000000);
                hud.graphics.drawCircle(b.x, b.y, b.r);
            }
            
        }
        
    }
    
}

import flash.display.Sprite;
import flash.display.Stage;
import flash.events.Event;
import flash.geom.Point;
import flash.geom.Rectangle;

internal class Ball extends Sprite
{
    protected var stg:Rectangle;
    protected var movect:Point;
    protected var _r:Number;
    
    public function Ball(stg:Rectangle, x:Number, y:Number)
    {
        this.stg = stg;
        
        // r randomization
        var range:Number = 105;
        // simple
        //r = 15+Math.random()*range;
        // log scale
        r = 15 + range-(Math.log(Math.random() * range) * range / Math.log(range));
        
        this.x = x;
        this.y = y;
        // movement vector randomization
        movect = new Point(
                 Math.random() * 6 - 3
                ,Math.random() * 6 - 3
                );
        
        addEventListener(Event.ENTER_FRAME, onFrame);
    }
    
    protected function drawBody(r:Number):void
    {
        graphics.clear();
        graphics.beginFill(0x000000);
        graphics.drawCircle(0, 0, r);
    }
    
    protected function onFrame(e:Event):void 
    {
        //TODO: fix traps
        var fv:Number;
        x += movect.x;
        if (x < 0 || x > stg.width) movect.x*=-1;
        y += movect.y;
        if (y < 0 || y > stg.height) movect.y*=-1;
    }
    
    public function get r():Number { return _r; }
    public function set r(value:Number):void 
    {
        _r = value;
        drawBody(_r);
    }
}