/**
 * Copyright gaziya ( http://wonderfl.net/user/gaziya )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rYBf
 */

// forked from bradsedito's Bezier3D in pure AS3
package 
{    
    import flash.geom.Vector3D
    import flash.geom.Matrix3D
    import flash.geom.PerspectiveProjection
    import flash.geom.Utils3D
    import flash.events.Event
    import flash.display.Sprite
    [SWF(width=465,height=465,frameRate=30)]
     
    public class Bezier3D extends Sprite {
        public function Bezier3D() {
            x = stage.stageWidth / 2
            y = stage.stageHeight / 2
            var points:Vector.<Number>  = new Vector.<Number>()
            var line_width:Vector.<Number> = new Vector.<Number>()
            var lineSize:int = 30                   
            for (var i:int = 0; i<lineSize; i++) {
                line_width.push(Math.random()*6 + 2)
                for (var j:int = 0; j<3; j++) {
                    points.push(
                        Math.random() - 0.5,
                        Math.random() - 0.5,
                        Math.random() - 0.5
                    )
                }
            }                 
            var perspective:PerspectiveProjection = new PerspectiveProjection()
            var proj:Matrix3D = perspective.toMatrix3D()
            var theta:int = 0
            addEventListener(Event.ENTER_FRAME, loop)
            function loop(e:Event):void {
                theta += Math.sqrt(mouseX*mouseX+mouseY*mouseY)/20
                theta %= 360
                var matrix:Matrix3D = new Matrix3D()                
                matrix.appendRotation(theta,new Vector3D(mouseX,mouseY,0))
                matrix.appendTranslation(0,0,2)
                var t_points:Vector.<Number> = new Vector.<Number>()
                matrix.transformVectors(points, t_points)
                var points_2D:Vector.<Number> = new Vector.<Number>()
                Utils3D.projectVectors(proj, t_points, points_2D, new Vector.<Number>())                
                graphics.clear()                        
                for (var i:int=0; i<lineSize; i++){
                    graphics.lineStyle(line_width[i],0)
                    var v:Vector.<Number> = points_2D.slice(i*6,i*6+6)
                    graphics.moveTo(v[0],v[1])                    
                    graphics.curveTo(v[2],v[3],v[4],v[5])                       
                }                   
            }   
        }            
    }
}

