/**
 * Copyright andreyflyagin ( http://wonderfl.net/user/andreyflyagin )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rXNf
 */

package {
	
	  import flash.display.Bitmap;
	  import flash.display.BitmapData;
	  import flash.display.Sprite;
	  import flash.events.Event;
      
 [SWF(width=800, height=800, backgroundColor=0xFFFFFF, frameRate=30)]
 
	public class cubicAttactor extends Sprite
	{
		
		 private var _canvas:BitmapData;
		 private var cities:Array;
		 private var num:int = 11;
		 private var dim:int = 800;
		  private var nudge:Number;
		  private var numtravelers:int = 5000;
		  private var a:int, b:int;
		  private var mind:int=128;
		  private var t:Number;
		  private var dx:Number, dy:Number;


		public function cubicAttactor()
		{
			 this._canvas = new BitmapData(800, 800, false, 0xFFFFFFFF);
			 this.addChild(new Bitmap(this._canvas)) as  Bitmap;
			   
	
				nudge = dim/num;
				var  i:int=0;
					this.cities=[];
				for (var x:int=0;x<num;x++) {
			    for (var y:int=0;y<num;y++) {
			      var p:City = new City(x*nudge+nudge/2,y*nudge+nudge/2,i,nudge,num,getColor(0.17,Math.random()*120+20,Math.random()*50,Math.random()*20));
			      this.cities.push(p);
			      i++;
			    }
			  }
			
			this.addEventListener(Event.ENTER_FRAME, this.update); 

		}
		private function blendColors(color1:uint,color2:uint):uint
		{
		 		var _r:uint,_b:uint,_g:uint,r2:uint,b2:uint,g2:uint,_a:Number;  
				  
	  		    _r=getR(color1);  _g=getG(color1);    _b=getB(color1);
     		     r2=getR(color2);    g2=getG(color2);    b2=getB(color2);
				    
	        	_a = ( color2 >>> 24 ) / 0xff;
  		       _r=_r*(1-_a)+r2*_a;   _g=_g*(1-_a)+g2*_a;   _b=_b*(1-_a)+b2*_a;
					   
	          return getColor(1,_r,_g,_b);
					   
		
		}
		private function getR(colorValue:uint):uint
		{
			return colorValue >> 16 & 0xff;
		
		}
		private function getG(colorValue:uint):uint
		{
			return colorValue >> 8 & 0xff;
		
		}
		private function getB(colorValue:uint):uint
		{
			return colorValue  & 0xff;
		
		}
		private function getColor(_a:Number,_r:uint,_g:uint,_b:uint):uint
		{
			return (Math.round( _a * 0xff ) & 0xFF) << 24 | _r << 16 | _g << 8 | _b ;

		}
			
		private  function update(e:Event):void {
			
		//	this._canvas.lock();
			var tt:uint,tt1:uint;
			
			//var t:Number = getTimer();
			
			var ttt:int=0;
			var t3:Number;
				//trace(getTimer() - t);
					   //   	t3= getTimer();
							for (var n:int=0;n<numtravelers;) {
					    // pick random city A
					    ttt++;
					    a = Math.floor(Math.random()*num*num);
					    b = Math.floor(Math.random()*num*num);
					    //a=18; b=30;
					    if ((a>=num*num) || (b>=num*num)) {
					      // why does this happen?
					      
					    } else if (a!=b) {
					      if (citydistance(a,b)<mind) {
					      	//trace(ttt);
					      //	ttt=0;
					      
					      	
					        // pick random distance between city
					        t = Math.random()*Math.PI;
					        dx = Math.sin(t)*(cities[b].x-cities[a].x)+cities[a].x;
					        dy = Math.sin(t)*(cities[b].y-cities[a].y)+cities[a].y;
					
					        if (Math.random()*1000>990) {
					          // noise
					          dx += Math.random()*3-1.5;
					          dy += Math.random()*3-1.5;
					        }
					         
					         
					         tt1=cities[b].myc;
					          					        tt= blendColors(this._canvas.getPixel32(dx,dy),tt1)
					         this._canvas.setPixel(dx, dy,tt);
					         
					         this._canvas.setPixel(dx, dy,blendColors(this._canvas.getPixel32(dx,dy),cities[a].myc));
					        
					       
					
					        n++;
					      }
					    }
					  }

		 		for (var c:int=0;c<(num*num);c++) {
    					cities[c].move();
					
					      this._canvas.setPixel(cities[c].x, cities[c].y,blendColors(this._canvas.getPixel32(cities[c].x, cities[c].y),getColor(0.53,255,255,255)));
  				}
  				
  				// trace('aaaaaaaaa'+n+'bbbbbbbbbbb');
 
		
		//this._canvas.unlock();
			//trace(getTimer() - t3);
		
		}
		private function citydistance(a:int, b:int):Number {
  		if (a!=b) {
    
    var Dx:Number = cities[b].x-cities[a].x;
    var Dy:Number = cities[b].y-cities[a].y;
    var D:Number = Math.sqrt(Dx*Dx+Dy*Dy);
    return D;
  } else {
    return 0.0;
  }
}

		
	}
	
}

class City
	{
		

		public var x:int;
  		public var y:int;
		public var idx:int;
		public var xp:Number=0, yp:Number=0;
		public var destx:Number=0, desty:Number=0;
		public var nudge:Number;
		public var myc:uint;
		
    	public var vx:Number=0, vy:Number=0;


		public function City(Dx:int, Dy:int, Idx:int, nudge:Number, num:int,myc:uint) {
			this.xp = Dx;
		    this.yp = Dy;
		    x = Dx;
		    y = Dy;
		    idx = Idx;
		    destx = Math.random()*num*nudge+nudge/2;
		    desty = Math.random()*num*nudge+nudge/2;
			this.nudge=nudge;
			this.myc=myc;

		}


		public function move():void {
		    vx+=(destx-xp)/2500;
		    vy+=(desty-yp)/2500;
		
		    vx*=0.973;
		    vy*=0.973;
		    xp+=vx;
		    yp+=vy;
		    x = xp;
		    y = yp;

		  }
	}
