/**
 * Copyright HaraMakoto ( http://wonderfl.net/user/HaraMakoto )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rWOD
 */

package {
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.BlurFilter;
	import flash.filters.DropShadowFilter;
	import flash.filters.GlowFilter;
	import flash.geom.ColorTransform;
	import flash.geom.Point;
//--------------------------------------------------------------------------------//
//　クリックした位置に左上から雷撃発射
//--------------------------------------------------------------------------------//
	[SWF(backgroundColor="0x000000", width="465", height="465", frameRate="60")]
	public class Thundaga extends Sprite
	{
		private var bmp:Bitmap = new Bitmap();
		private var bmd:BitmapData = new BitmapData(465,465,true,0x000000);
		private var ct:ColorTransform = new ColorTransform(1,1,1,1,-2,5,-4,-10);
		private var tt:ThunderBody;
		private var glow0:GlowFilter;
		private var glow1:GlowFilter;
		private var glow3:GlowFilter;
		
		
		public function Thundaga()
		{
			tt = new ThunderBody(bmd);
			addChild(bmp);
			bmp.bitmapData = bmd;
			addChild(tt);
			tt.generateThunder(10,10,300,420)
			addEventListener(Event.ENTER_FRAME, enterFrameHandler);
			addEventListener(Event.ADDED_TO_STAGE, addStageHandler);
			
		}
		
		private function addStageHandler(event:Event):void {
			stage.addEventListener(MouseEvent.CLICK, stageClick);
		}
		
		private function stageClick(event:MouseEvent):void {
			tt.generateThunder(10,10,mouseX,mouseY);
		}
		
		private var blurFilter:BlurFilter = new BlurFilter(2,2);
		private function enterFrameHandler(event:Event):void {
			bmd.colorTransform( bmd.rect, ct );
			bmd.applyFilter(bmd,bmd.rect, new Point(0,0), blurFilter);
		}
	}
}
	import flash.display.Sprite;
	import caurina.transitions.properties.CurveModifiers;
	import caurina.transitions.Tweener;
	import flash.geom.Point;
	import flash.display.BitmapData;
	import caurina.transitions.Equations;
	import flash.geom.Matrix;
	

class ThunderBody extends Sprite {
	private var tPoint:Sprite = new Sprite();
	private var oPoint:Point = new Point(0,0);
	private var graphDrawLayer:Sprite = new Sprite();
	private var myBmd:BitmapData;
	private var _bomb:Bomb;
	private var ThunderNodeList:Array = new Array();
	private var TListNum:int = 10;
	private var TListCounter:int = 0;
	
	public function ThunderBody(bmd:BitmapData) {
		CurveModifiers.init();
		myBmd = bmd;
		_bomb = new Bomb(myBmd);
		makeThunders();
	}
	
	private function makeThunders():void {
		var i:int;
		for(i=0; i<TListNum; i++) {
			var TN:ThunderNode  =new ThunderNode();
			graphDrawLayer.addChild(TN);
			ThunderNodeList.push(TN);
		}
	}
	
	public function generateThunder(sx:Number,sy:Number,tx:Number, ty:Number):void {
		tPoint.x = oPoint.x= sx;
		tPoint.y = oPoint.y = sy;
		var leng:int = 3;
		TListCounter = 0;
		var dxUnit:Number = (tx-sx)/leng;
		var dyUnit:Number = (ty-sy)/leng;
		var bz:Array = new Array();
    	var i:int;
    	for(i=0;i<leng;i++) {
    		bz.push({x:dxUnit*i+(-40+150*Math.random())+sx, y:dyUnit*i+(-75+150*Math.random())*i/leng+sy});
    	}
		for(i=0; i<TListNum; i++) {
			ThunderNodeList[i].reset();
		}
    	
    	Tweener.addTween(tPoint, {x:tx, y:ty, time:0.2, _bezier:bz, transition:Equations.easeNone,onUpdate:drawLine,
    		onComplete:_bomb.makeBomb, onCompleteParams:[tx,ty]});
	}
	
	private function drawLine():void {
		var dPoint:Point = new Point(tPoint.x+5*Math.random(), tPoint.y+5*Math.random());
		graphDrawLayer.graphics.clear();
		graphDrawLayer.graphics.lineStyle(6,0xFFFFFF);
		graphDrawLayer.graphics.moveTo(oPoint.x, oPoint.y);
		graphDrawLayer.graphics.lineTo(dPoint.x, dPoint.y);
		
		//不意のタイミングで枝生成
		if(Math.random()>0.5 && TListCounter<TListNum){
			ThunderNodeList[TListCounter].makeNode(dPoint.x, dPoint.y, 20*Math.random(), 20*Math.random() );
			TListCounter++;
		}
		var i:int = 0;
		for(i=0; i<TListNum; i++) {
			ThunderNodeList[i].update();
		}
		myBmd.draw(graphDrawLayer);
		oPoint.x = dPoint.x;
		oPoint.y = dPoint.y;
	}
}

class ThunderNode extends Sprite {
	private var myBmd:BitmapData;
	private var isStarted:Boolean = false;
	public var vx:Number, vy:Number;
	public var px:Number, py:Number;
	private var counter:int = 0;
	public function ThunderNode() {
		
	}
	
	public function makeNode(sx:Number, sy:Number, _vx:Number, _vy:Number):void {
		isStarted = true;
		px = sx;
		py = sy;
		vx = _vx;
		vy = _vy;
		
	}
	public function update():void {
		if(!isStarted) return;
		vx += 2 * Math.cos(counter*Math.PI/180)-3+Math.random()*10;
		vy += 2 * Math.sin(counter*Math.PI/180)-3+Math.random()*10;
		this.graphics.clear();
		this.graphics.lineStyle(1,0xFFFFFF);
		this.graphics.moveTo(px, py);
		this.graphics.lineTo(px+vx, py+vy);
		px += vx;
		py += vy;
	}
	public function reset():void {
		isStarted = false;
		counter = 360 * Math.random();
		this.graphics.clear();
	}
}

class Bomb extends Sprite {
	private var posList:Array = new  Array();
	public var bombList:Array = new Array();
	public var bombNum:int = 20;
	private var bmd:BitmapData;
	private var blush:Sprite = new Sprite();
	private var bombLayer:Sprite = new Sprite();
	public function Bomb(_bmd:BitmapData) {
		bmd = _bmd;
		var i:int;
		for(i=0; i<bombNum; i++) {
			var _bChild:bombChild = new bombChild();
			posList.push(_bChild); 
			var _bBody:Sprite = new Sprite();
			blushShape(_bBody);
			bombLayer.addChild(_bBody);
			bombList.push(_bBody);
		}
		blushShape(blush);

	}
	
	private function blushShape(sp:Sprite):void {
		sp.graphics.beginFill(0xffffff);
		sp.graphics.drawCircle(0,0,6);
		sp.graphics.endFill();
	}
	
	public function makeBomb(tx:Number, ty:Number):void {
		var i:int;
		for(i=0; i<bombNum; i++) {
			posList[i].vx = -40+80*Math.random();
			posList[i].vy = -40+80*Math.random();
			
			posList[i].x = tx + posList[i].vx;
			posList[i].y = ty + posList[i].vy;
			posList[i].vx *= 0.1;
			posList[i].vy *= 0.1;
			posList[i].scaleVal = Math.random();
			posList[i].counter=0;
			
			bombList[i].x = posList[i].x;
			bombList[i].y = posList[i].y;
		}
		alpha=0;
		Tweener.addTween(this, {alpha:1, time:0.5, transition:Equations.easeOutQuint, onUpdate:onUpdateHandler});
	}
	private function onUpdateHandler():void {
		var i:int;
		for(i=0; i<bombNum; i++) {
			posList[i].update();
			var mtx:Matrix = new Matrix();
			mtx.translate(posList[i].x, posList[i].y);
			bombList[i].scaleX = bombList[i].scaleY = posList[i].scaleVal;
		}
		bmd.draw(bombLayer);
	}
	
}
class bombChild {
	public var x:Number, y:Number;
	public var vx:Number, vy:Number;
	public var scaleVal:Number = 0.1;
	public var scaleStep:Number = 0.1;
	public var scaleTarget:Number = 0.5;
	public var scaleScale:Number;
	public var counter:int = 0;
	private var Deccel:Number = 0.9;
	public function bombChild() {
		scaleStep = 2*Math.random();
		scaleScale = 8*Math.random();
	}
	public function update():void {
		x += vx;
		y += vy;
		vx *= 0.9;
		vy *= 0.9;
		scaleVal = scaleScale * Math.sin(counter*Math.PI/180);
		counter += scaleStep * (180 - counter);
	}
}
