/**
 * Copyright Pcjoe ( http://wonderfl.net/user/Pcjoe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rUdY
 */

// forked from tail_y's AuraEffect
// forked from yasohachi's 魔方陣っぽい何か　
package
{
	/*
	  最初は「魔方陣っぽい何か」を見て、ゲームっぽい！と思い
	  これゲームのオーラ的なエフェクトに
	  使えるかなーなんてやってみたのですが
	  結局2Dキャラに適用するのにPapervision3D使う意味が薄かったので
	  オリジナルに組みなおしてしまいました。
	  着想元ですし、参考にもしたので、Forkは残しますが、全diff状態ですｗ
	  
	  結局のところ、一周して何の意味も無いところに戻ってきた感じだよ！
	  Papervision3Dの上にもやーっとなるエフェクトを
	  そのまま使いたい場合どうするかの参考にどうぞ。
	  BitmapDataの使い方に無駄がある気がしないでもない。クリッピングとか。
	  
	  キャラクター画像はedielecさんから借りました。
	 */
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.MovieClip;
	import flash.display.Sprite;        
	import flash.display.StageQuality;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import flash.geom.ColorTransform;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.system.Security;
	import flash.text.TextField;
	
	import net.hires.debug.Stats;
	
    public class AuraEffect1 extends Sprite
    {
		public static const STAGE_W:uint = 465;
		public static const STAGE_H:uint = 465;
		
		public static const GRAVITY:Number = 1;
		public static const GROUND_Y:int = 400;
		
		public static const CHARACTER_BACE_X:int = 200;
		public static const CHARACTER_BACE_Y:int = 300;
		
		private var _assetLoader:AssetLoader;
		// Display系
		private var _character:Sprite;	// キャラMCを入れておくよ。
		private var _characterBitmapData:BitmapData;	// キャラクターを描画するよ。
		private var _effectBaceBitmapData:BitmapData;	// エフェクトの元になるよ。
		private var _effectBitmapData:BitmapData;	// エフェクトを描画するよ。
		private var _clearBitmap:BitmapData;	// 画像を消すためのBitmapData
		private var _loadingDisplay:TextField;	// loadingって表示するだけ
		// エフェクト
		private var _blur:BlurFilter = new BlurFilter(0, 8, 1);	// オーラ画像を上下方向にぼかす。
		private var _colorTransform:ColorTransform = new ColorTransform(0.95, 0.85, 0.5);	// オーラの上に行くにしたがっての色の変化
		private var _movePoint:Point = new Point(0, -2);	// 上にずらす量
		private var _baceBitmapColorTransform:ColorTransform = new ColorTransform(1, 1, 1, 1, 50, 50, 50);	// オーラの元となる画像はちょっと色を足しておく。
		
		
		private var _rect:Rectangle = new Rectangle(0, 0, STAGE_W, STAGE_H);
		private var _point:Point = new Point(0, 0);
		
		public function AuraEffect1()
		{
             // キャプチャを遅らせます
             Wonderfl.capture_delay( 10 );
			addEventListener(Event.ADDED_TO_STAGE, init);	// flexBuilderとの互換性。
		}
		private function init(e:Event):void {	// ここから開始
			removeEventListener(Event.ADDED_TO_STAGE, init);
			// SWF設定
			stage.frameRate = 20;
			stage.quality = StageQuality.HIGH;
			var bg:Sprite = new Sprite();	// wonderflではキャプチャに背景色が反映されないので、背景色Spriteで覆う。
			bg.graphics.beginFill(0x000000);
			bg.graphics.drawRect(0, 0, STAGE_W, STAGE_H);
			addChild(bg);
			
			// ビットマップ表示を用意して、ステージに追加しておく。
			_effectBitmapData = new BitmapData(STAGE_W, STAGE_H, true, 0x00000000);
			addChild(new Bitmap(_effectBitmapData));
			_characterBitmapData = new BitmapData(STAGE_W, STAGE_H, true, 0x00000000);
			addChild(new Bitmap(_characterBitmapData));
			_clearBitmap = new BitmapData(STAGE_W, STAGE_H, true, 0x00000000);
			_effectBaceBitmapData = new BitmapData(STAGE_W, STAGE_H, true, 0x00000000);
			
			// キャラクターの入れ物
			_character = new Sprite();
			
			// Stats
			addChild(new Stats());
			
			// 必要素材ロード
			_assetLoader = new AssetLoader();
			_assetLoader.addEventListener(Event.COMPLETE, endLoad);
			_assetLoader.loadStart(["http://asset.sipo.jp/wonderfl/character/rpg_character01_stand.swf"]);
			_loadingDisplay = new TextField();
			_loadingDisplay.text = "loading";
			_loadingDisplay.textColor = 0xffffff;
			addChild(_loadingDisplay);
		}
		// 素材読み込み終了。
		private static const SCALE:Number = 1.5;	// ちょっと素材が小さいので大きくしておく。
		private function endLoad(event:Event):void{
			removeChild(_loadingDisplay);
			// 素材もらう。
			var characterInMc:MovieClip = MovieClip(_assetLoader.getAsset(0));
			characterInMc.x = STAGE_W/2 - CHARACTER_BACE_X*SCALE + 50;
			characterInMc.y = STAGE_H/2 - CHARACTER_BACE_Y*SCALE + 200;
			characterInMc.scaleX = SCALE;
			characterInMc.scaleY = SCALE;
			_character.addChild(characterInMc);
			
			// フレーム動作の登録
			addEventListener(Event.ENTER_FRAME, frame);
		}
		
		private function frame(event:Event):void{	// フレーム
			// キャラクターグラフィックをBitmapDataに移す
			_characterBitmapData.lock();	// 忘れずにロック
			_characterBitmapData.copyPixels(_clearBitmap, _rect, _point);
			_characterBitmapData.draw(_character)
			_characterBitmapData.unlock();
			
			// エフェクト描画
			_effectBaceBitmapData.copyPixels(_characterBitmapData, _rect, _point);
			_effectBaceBitmapData.colorTransform(_rect, _baceBitmapColorTransform);
			_effectBitmapData.lock();
			_effectBitmapData.copyPixels(_effectBaceBitmapData, _rect, _point, null, null, true);	// アルファを残して描画
			_effectBitmapData.applyFilter(_effectBitmapData, _rect, _movePoint, _blur);
			_effectBitmapData.colorTransform(_rect, _colorTransform);
			_effectBitmapData.unlock();
		}
    }
}




import flash.display.DisplayObject;
import flash.display.Loader;
import flash.display.LoaderInfo;
import flash.events.Event;
import flash.events.EventDispatcher;
import flash.events.IOErrorEvent;
import flash.net.URLRequest;

// 複数素材を外部からロードできるクラス。
class AssetLoader extends EventDispatcher
{
	
	private var _loaderList:Array;
	private var _urlList:Array;
	private var _loadCount:uint = 0;
	private var _errorCount:uint = 0;
	private var _errorCountMax:uint = 5;
	
	
	public function AssetLoader()
	{
	}
	
	public function loadStart(urlList:Array, errorCountMax:int = 5):void{
		_errorCountMax = errorCountMax;
		_urlList = urlList;
		
		// 読み込み開始
		var loader:Loader;
		_loaderList = [];
		for (var i:int = 0; i < _urlList.length; i++){
			var url:String = _urlList[i];
			loader = new Loader();
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, multiArg(loadEnd, i));
			loader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, multiArg(loadError, i));
			loader.load(new URLRequest(url));
			_loaderList.push(loader);
		}
	}
	private function multiArg(response:Function, ...arg:Array):Function{
		return function (...arg2:Array):void{	response.apply(null, arg2.concat(arg)); };
	}
	
	//  全体のロード割合を返す
	public function getRate():Number{
		var total:Number=0, loaded:Number=0;
		for each(var loader:Loader in _loaderList){
			total += loader.contentLoaderInfo.bytesTotal;
			loaded += loader.contentLoaderInfo.bytesLoaded;
		}
		return loaded/total;
	}
	// ロード終了処理
	private function loadEnd(e:Event, i:int):void{
		_loadCount++;
		if (_loaderList.length == _loadCount) loadEndAll();
	}
	private function loadEndAll():void{
		var e:Event = new Event(Event.COMPLETE);
		dispatchEvent(e);
	}
	// データをもらう
	public function getAsset(i:int):DisplayObject{
		return Loader(_loaderList[i]).content;
	}
	
	// エラー処理
	private function loadError(e:Event, i:int):void{
		_errorCount++;
		if (_errorCountMax <= _errorCount) throw e;
		var loader:Loader = _loaderList[i];
		loader.load(new URLRequest(_urlList[i]));
	}

}
