/**
 * Copyright jozefchutka ( http://wonderfl.net/user/jozefchutka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rTs1
 */

package
{
    import caurina.transitions.Tweener;
    
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    [SWF(width="465", height="465", frameRate="30", backgroundColor="#FFFFFF")]
    
    public class Carousel extends Sprite
    {
        public static const ITEMS_ASIDE:uint = 3;
        public static const ITEM_WIDTH:Number = 150;
        public static const ITEM_HEIGHT:Number = 300;
        
        private var itemsWrapper:Sprite = new Sprite();
        private var isRotating:Boolean = false;
        
        public function Carousel()
        {
            super();
            
            var leftButton:Btn = new Btn();
            leftButton.y = stage.stageHeight;
            leftButton.addEventListener(MouseEvent.CLICK, leftClick);
            addChild(leftButton);
            
            var rightButton:Btn = new Btn();
            rightButton.x = stage.stageWidth;
            rightButton.y = stage.stageHeight;
            rightButton.addEventListener(MouseEvent.CLICK, rightClick);
            addChild(rightButton);
            
            addChild(itemsWrapper)
            for(var i:int = -ITEMS_ASIDE; i <= ITEMS_ASIDE; i++)
                createItem(i);
            
            addEventListener(Event.ENTER_FRAME, enterFrame);
        }
        
        private function createItem(position:int):void
        {
            var item:CarouselItem = new CarouselItem(ITEM_WIDTH, ITEM_HEIGHT, 
                position);
            item.addEventListener(MouseEvent.CLICK, itemClick);
            itemsWrapper.addChild(item);
            moveItem(item, position, false);
        }
        
        private function enterFrame(event:Event):void
        {
            if(isRotating)
                zIndex();
        }
        
        private function leftClick(event:MouseEvent):void
        {
            moveItems(1);
        }
        
        private function rightClick(event:MouseEvent):void
        {
            moveItems(-1);
        }
        
        private function itemClick(event:MouseEvent):void
        {
            var item:CarouselItem = CarouselItem(event.currentTarget);
            if(!item.position)
                trace("go");
                
            moveItems(-item.position);
        }
        
        private function moveItems(n:int):void
        {
            var item:CarouselItem;
            for(var i:uint = 0; i < itemsWrapper.numChildren; i++)
            {
                item = CarouselItem(itemsWrapper.getChildAt(i));
                moveItem(item, item.position + n);
            }
        }
        
        private function moveItem(item:CarouselItem, position:int,
            lazy:Boolean = true):void
        {
            item.position = position;
            var transform:Transform = new Transform(stage.stageWidth, 
                stage.stageHeight, ITEMS_ASIDE, position);
            
            if(!lazy)
            {
                Transform.apply(item, transform);
                return zIndex();
            }
            
            isRotating = true;
            Tweener.addTween(item, {time: 1, x:transform.x, y:transform.y,
                scaleX:transform.scale, scaleY:transform.scale, 
                scaleZ:transform.scale, rotationY:transform.rotationY,
                onComplete:rotationComplete});
        }
        
        private function rotationComplete():void
        {
            isRotating = false;
        }
        
        private function zIndex():void
        {
            var item1:CarouselItem, item2:CarouselItem;
            var scale1:Number, scale2:Number;
            var rotation1:Number, rotation2:Number;
            var index1:Number, index2:Number;
            var w:uint = stage.stageWidth;
            var scaleProblem:Boolean, positionProblem:Boolean;
            for(var i:uint = 0; i < itemsWrapper.numChildren; i++)
            for(var j:uint = i + 1; j < itemsWrapper.numChildren; j++)
            if(itemsWrapper.getChildAt(i) is CarouselItem)
            {
                item1 = CarouselItem(itemsWrapper.getChildAt(i));
                item2 = CarouselItem(itemsWrapper.getChildAt(j));
                
                scale1 = Math.round(item1.scaleX * 2);
                scale2 = Math.round(item2.scaleX * 2);
                
                rotation1 = Math.round(item1.rotationY * 10);
                rotation2 = Math.round(item2.rotationY * 10);
                
                index1 = itemsWrapper.getChildIndex(item1);
                index2 = itemsWrapper.getChildIndex(item2);
                
                scaleProblem = (scale1 > scale2 && index1 < index2) 
                    || (scale1 < scale2 && index1 > index2);
                positionProblem = 
                    (rotation1 > 0 && rotation2 > 0 && item1.x < item2.x) 
                    || (rotation1 < 0 && rotation2 < 0 && item1.x > item2.x);
                
                if(scaleProblem || positionProblem)
                    itemsWrapper.swapChildren(item1, item2);
            }
        }
    }
}

import flash.display.Sprite;
import __AS3__.vec.Vector;
import flash.geom.Transform;
import flash.events.MouseEvent;
import flash.events.Event;

class CarouselItem extends Sprite
{
    public static var list:Vector.<CarouselItem> = new Vector.<CarouselItem>();
    
    private var _position:int = 0;
    
    public function CarouselItem(width:Number, height:Number, position:int):void
    {
        buttonMode = true;
        
        graphics.beginFill(Math.random() * 0xffffff);
        graphics.drawRect(-width / 2, -height / 2, width, height);
        graphics.endFill();
        
        this.position = position;
        
        list.push(this);
    }
    
    public function set position(value:int):void
    {
        _position = value;
    }
    
    public function get position():int
    {
        return _position
    }
    
    public function destroy():void
    {
        list.splice(list.indexOf(this), 1);
        parent.removeChild(this);
    }
}

class Transform extends Object
{
    private var _x:Number = 0;
    private var _y:Number = 0;
    private var _scale:Number = 1;
    private var _rotationY:Number = 0;
    
    private static const ASIDE_SCALE:Number = 0.6;
    private static const LEFT_ROTATION_Y:Number = -40;
    private static const RIGHT_ROTATION_Y:Number = 40;
    
    public function Transform(width:Number, height:Number, aside:uint, 
        position:int):void
    {
        _scale = position == 0 ? 1 : ASIDE_SCALE;
        _rotationY = position > 0 ? RIGHT_ROTATION_Y : position < 0 ? LEFT_ROTATION_Y : 0;
        _x = calcX(width, aside, position);
        _y = height / 2;
    }
    
    public function get scale():Number {return _scale};
    public function get rotationY():Number {return _rotationY};
    public function get x():Number {return _x;}
    public function get y():Number {return _y;}
    
    private function calcX(width:Number, aside:uint, position:int):Number
    {
        var space:Number = width / 2 / (aside + 2);
        if(position > 0)
            position++;
        if(position < 0)
            position--;
        return width / 2 + position * space;
    }
    
    public static function apply(item:CarouselItem, transform:Transform):void
    {
        item.x = transform.x;
        item.y = transform.y;
        item.rotationY = transform.rotationY;
        item.scaleX = transform.scale;
        item.scaleY = transform.scale;
        item.scaleZ = transform.scale;
    }
}

class Btn extends Sprite
{
    public function Btn()
    {
        buttonMode = true;
        graphics.beginFill(Math.random() * 0xffffff);
        graphics.drawCircle(0, 0, 20);
        graphics.endFill();
    }
}