/**
 * Copyright Albert ( http://wonderfl.net/user/Albert )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rTba
 */

package
{

    import flash.display.Sprite;

    import flash.events.MouseEvent;

    import flash.filters.DropShadowFilter;

    import flash.filters.GlowFilter;

    import flash.geom.Point;

    

    public class DragSnap extends Sprite

    {

        public const NUM_POINTS:int = 50;

        public var pts:Vector.<Point> = new Vector.<Point>();

        private var mc:Sprite;

        private var sel:Sprite;

        private var startdragx:int;

        private var startdragy:int;

        private var table:Array;

        private static var tablew:int = 10;

        private static var tableh:int = 10;

        private static var colors:Array = [0x33bb33, 0x3333bb, 0xbb3333, 0xbbbb33, 0xbb33bb, 0x33bbbb];

        private static var maxcolors:int = 6;

        private var draginprogress:Boolean;

        public var vertical:Vector.<DragBlock> = new Vector.<DragBlock>();

        public var horizontal:Vector.<DragBlock> = new Vector.<DragBlock>();

        public var board:Sprite;

        public var m:Sprite;

        public var glow:Sprite;

        public var totalScore:int;

        public var currentScore:int;

        

        public function DragSnap()

        {

            WTrace.initTrace(stage);

            trace("Start dragging a row or a column");

            board = new Sprite();

            addChild(board);

            sel = new Sprite();

            board.addChild(sel);

            table = new Array();

            for (var x:int = 0; x < tablew; ++x)

            {

                for (var y:int = 0; y < tableh; ++y)

                {

                    table.push(null);

                }

                

            }

            

            m = new Sprite();

            board.mask = m;

            addChild(m);

            

            drawtable();

            

            var c:DragBlock;

            for (var i:int = 0; i < NUM_POINTS; i++)

            {

                var px:int = 10 * Math.random();

                var py:int = 10 * Math.random();

                pts[i] = new Point(34 * int(1 + px), 34 * int(1 + py));

                if (table[px + py * tablew])

                    continue;

                c = new DragBlock(pts[i], colors[int(Math.random() * maxcolors)]);

                table[px + py * tablew] = c;

                board.addChild(c);

                

                c.buttonMode = true;

                c.addEventListener(MouseEvent.MOUSE_DOWN, drag);

            }



            glow = new Sprite();

            var gf:GlowFilter = new GlowFilter(0xffffff, 1,10,10, 6); //, 1, true, true);

            glow.filters = [gf];

            board.addChild(glow);

            drawAreas();

        }

        

        private function draw():void

        {

            sel.graphics.clear();

            if (!draginprogress)

                return;

            var vertical:Boolean = dragvertically(mouseX - startdragx, mouseY - startdragy);

            sel.graphics.lineStyle(2, 0xeeccaa);

            sel.graphics.beginFill(0xFFDDAA, vertical ? 0.4 : 0.8);

            sel.graphics.drawRect(17, startdragy - 17, tablew * 34, 34);

            sel.graphics.endFill();

            sel.graphics.beginFill(0xFFDDAA, vertical ? 0.8 : 0.4);

            sel.graphics.drawRect(startdragx - 17, 17, 34, tableh * 34);

            sel.graphics.endFill();

        }

        

        private function drawAreas():void

        {

            currentScore = 0;

            glow.graphics.clear();

            var x:int = 0;

            var y:int = 0;

            var c:int = 0;

            var b:DragBlock;

            //trace("--");

            while (y < tableh)

            {

                var good:Boolean = false;

                if (table[y * tablew + x] != null)

                {

                    c = table[y * tablew + x].color;

                    good = true;

                    if (x > 0)

                    {

                        b = table[(x - 1) + tablew * y];

                        if (b && b.color == c)

                            good = false;

                    }

                    if (y > 0)

                    {

                        b = table[x + tablew * (y - 1)];

                        if (b && b.color == c)

                            good = false;

                    }

                }

                else

                    good = false;

                

                if (good)

                {

                    //trace("good",x,y);

                    var width:int = 0;

                    for (var w:int = x; w < tablew; ++w)

                    {

                        b = table[w + tablew * y];

                        if (b && b.color == c)

                            width++;

                        else

                            break;

                    }

                    if (width > 1)

                    {

                        //trace(x,y);

                        var maxheight:int = 100;

                        var height:int = 0;

                        for (w = 0; w < width; ++w)

                        {

                            height = 0;

                            for (var h:int = y; h < tableh; ++h)

                            {

                                b = table[x + w + tablew * h];

                                if (!b || b.color != c)

                                    break;

                                ++height;

                            }

                            if (w < 2 && height < maxheight)

                                maxheight = height;

                            if (height < 2)

                            {

                                width = w;

                                break;

                            }

                            else if (w > 1 && height < maxheight)

                                maxheight = height;

                            

                        }

                        if (width > 1 && maxheight > 1)

                        {

                            currentScore += width * maxheight* width * maxheight;

                            glow.graphics.lineStyle(2, c, 0.3);

                            glow.graphics.drawRoundRect((x + 1) * 34-17, (y + 1) * 34-17, width * 34, maxheight * 34, 5, 5);

                        }

                    }

                }

                ++x;

                if (x > tablew)

                {

                    x = 0;

                    ++y;

                }

            }

        }

        

        private function drawtable():void

        {

            for (var x:int = 0; x < tablew; ++x)

            {

                for (var y:int = 0; y < tableh; ++y)

                {

                    board.graphics.lineStyle(2, 0xeeccaa);

                    board.graphics.beginFill(0xFFEEDD, 1);

                    board.graphics.drawRect((1 + x) * 34 - 17, (1 + y) * 34 - 17, 34, 34);

                    board.graphics.endFill();

                }

            }

            var dsf:DropShadowFilter = new DropShadowFilter();

            dsf.strength = 1.5; // 11 bytes if already used number, 16 bytes otherwise

            dsf.distance = 0;

            dsf.blurX = 20;

            dsf.blurY = 20;

            dsf.inner = true;

            dsf.color = 0xffffff;

            board.filters = [dsf];

            

            m.graphics.beginFill(0);

            m.graphics.drawRoundRect(34 - 17, 34 - 17, tablew * 34, tableh * 34, 10, 10);

            m.graphics.endFill();

        }

        

        private function drag(event:MouseEvent):void

        {

            mc = event.currentTarget as Sprite;

            //board.setChildIndex(mc,numChildren - 1); //http://www.foundation-flash.com/tutorials/changingdepths/

            stage.addEventListener(MouseEvent.MOUSE_UP, endDrag);

            stage.addEventListener(MouseEvent.MOUSE_MOVE, move);

            startdragx = mc.x;

            startdragy = mc.y;

            draginprogress = true;

            vertical.length = 0;

            horizontal.length = 0;

            var idx:int = 0;

            for (var x:int = 0; x < tablew; x++)

            {

                if (table[x + int((mc.y - 17) / 34) * tablew])

                    horizontal[idx++] = table[x + int((mc.y - 17) / 34) * tablew]

            }

            idx = 0;

            for (var y:int = 0; y < tableh; y++)

            {

                if (table[int((mc.x - 17) / 34) + y * tablew])

                    vertical[idx++] = table[int((mc.x - 17) / 34) + y * tablew];

            }

            move();

            draw();

        }

        

        private function dragvertically(dx:Number, dy:Number):Boolean

        {

            if (Math.abs(dx) < Math.abs(dy))

                return true;

            return false

        }

        

        private function endDrag(event:MouseEvent):void

        {

            stage.removeEventListener(MouseEvent.MOUSE_UP, endDrag);

            stage.removeEventListener(MouseEvent.MOUSE_MOVE, move);

            draginprogress = false;

            //draw();

            snap();

            drawAreas();

        }

        

        private function move(event:MouseEvent = null):void

        {

            var dx:Number = mouseX - startdragx;

            var dy:Number = mouseY - startdragy;

            var vert:Boolean = dragvertically(dx, dy);

            var i:int;

            if (vert)

            {

                for (i = 0; i < horizontal.length; ++i)

                {

                    horizontal[i].y = horizontal[i].pnt.y;

                    horizontal[i].x = horizontal[i].pnt.x;

                }

                for (i = 0; i < vertical.length; ++i)

                {

                    vertical[i].x = startdragx;

                    vertical[i].y = (vertical[i].pnt.y + dy - 17 + tableh * 34) % (tableh * 34) + 17;

                }

                

            }

            else

            {

                for (i = 0; i < vertical.length; ++i)

                {

                    vertical[i].x = vertical[i].pnt.x;

                    vertical[i].y = vertical[i].pnt.y;

                }

                for (i = 0; i < horizontal.length; ++i)

                {

                    horizontal[i].y = startdragy;

                    horizontal[i].x = (horizontal[i].pnt.x + dx - 17 + tablew * 34) % (tablew * 34) + 17;

                }

            }

            draw();

        }

        

        private function snap(event:MouseEvent = null):void

        {

            var dx:Number = mouseX - startdragx;

            var dy:Number = mouseY - startdragy;

            var vert:Boolean = dragvertically(dx, dy);

            var i:int;

            if (vert)

            {

                for (i = 0; i < tableh; ++i)

                {

                    table[int((startdragx - 17) / 34) + i * tablew] = null;

                }

                

                for (i = 0; i < vertical.length; ++i)

                {

                    vertical[i].x = startdragx;

                    vertical[i].y = (int((vertical[i].pnt.y + dy - 17) / 34 + tableh) % tableh + 1) * 34;

                    vertical[i].updatepnt();

                    table[int((startdragx - 17) / 34) + int((vertical[i].y - 17) / 34) * tablew] = vertical[i];

                }

                for (i = 0; i < horizontal.length; ++i)

                {

                    horizontal[i].y = horizontal[i].pnt.y;

                    horizontal[i].x = horizontal[i].pnt.x;

                    horizontal[i].updatepnt();

                }

            }

            else

            {

                for (i = 0; i < tablew; ++i)

                {

                    table[i + int((startdragy - 17) / 34) * tablew] = null;

                }

                for (i = 0; i < vertical.length; ++i)

                {

                    vertical[i].x = vertical[i].pnt.x;

                    vertical[i].y = vertical[i].pnt.y;

                    vertical[i].updatepnt();

                }

                for (i = 0; i < horizontal.length; ++i)

                {

                    horizontal[i].y = startdragy;

                    horizontal[i].x = (int((horizontal[i].pnt.x + dx - 17) / 34 + tablew) % tablew + 1) * 34;

                    horizontal[i].updatepnt();

                    table[int((horizontal[i].x - 17) / 34) + int((startdragy - 17) / 34) * tablew] = horizontal[i];

                }

            }

            draw();

        }

    }

}




    import flash.display.Sprite;
    import flash.geom.Point;
    import flash.geom.Matrix;


class DragBlock extends Sprite
{
    public var pnt:Point;
    public var color:int;
    public function DragBlock(p:Point, gcolor:int)
    {
        color=gcolor;
        myGradient(-17,-17,34,34,color);

        pnt = p;
        super.x = pnt.x;
        super.y = pnt.y;
    }
    
    override public function set x(value:Number):void
    {
        super.x = value;
    }
    
    override public function set y(value:Number):void
    {
        super.y = value;
    }
    
    public function updatepnt():void
   {
        pnt.x = super.x
        pnt.y = super.y
   }
 
    

    protected function myGradient(x:int, y:int, w:int, h:int, color:int):void
    {
        var matrix:Matrix = new Matrix();
        var color3:int = 0xffffff - color;
        var color2:int = color+((((((color3&0xff0000) >> 16)/4*3)<<16) + ((((color3&0x00ff00) >> 8)/4*3)<<8) + (color3&0x0000ff)/4*3));

        matrix.createGradientBox(w, h, 45 * Math.PI / 180, x, y);
        graphics.beginGradientFill("linear", [color2, color], [1.0, 1.0], [0, 255], matrix);            
        graphics.drawRoundRect(x,y,w,h,5,5);
        graphics.endFill();

        matrix.createGradientBox(w, h, 45 * Math.PI / 180, x, y);
        graphics.beginGradientFill("linear", [color, color2], [1.0, 1.0], [0, 255], matrix);
        graphics.drawRoundRect(x+7, y+7, w-14, h-14,3,3);
        graphics.endFill();
    }
}

/////  WONDERFL TRACE /////

import flash.display.Sprite;
import flash.display.Stage;
import flash.text.TextField;
import flash.text.TextFormat;


function inittrace(s:Stage):void
{
    WTrace.initTrace(s);
}

//global trace function
var trace:Function;

//wtreace class
class WTrace
{
        private static var FONT:String = "Fixedsys";
        private static var SIZE:Number = 12;
        private static var TextFields:Array = [];
        private static var trace_stage:Stage;
        
        public static function initTrace(stg:Stage):void
        {
            trace_stage = stg;
            trace = wtrace;
        }
        
        private static function scrollup():void
        {
            // maximum number of lines: 100
            if (TextFields.length > 100) 
            {
                var removeme:TextField = TextFields.shift();
                trace_stage.removeChild(removeme);
                removeme = null;
            }
            for(var x:Number=0;x<TextFields.length;x++)
            {
                (TextFields[x] as TextField).y -= SIZE*1.2;
            }
        }
    
        public static function wtrace(... args):void
        {
        
            var s:String="";
            var tracefield:TextField;
            
            for (var i:int;i < args.length;i++)
            {
                // imitating flash:
                // putting a space between the parameters
                if (i != 0) s+=" ";
                s+=args[i].toString();
            }
            

            tracefield= new TextField();
            tracefield.autoSize = "left";
            tracefield.text = s;
            tracefield.y = trace_stage.stageHeight - 20;

            var tf:TextFormat = new TextFormat(FONT, SIZE);
            tracefield.setTextFormat(tf);
            trace_stage.addChild(tracefield);
            scrollup();                      
            TextFields.push(tracefield);
            
        }
}
