/**
 * Copyright Makoto_Tanaka ( http://wonderfl.net/user/Makoto_Tanaka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rTVX
 */

/**
 *
 * 3D物理エンジンライブラリ[Jiglib]を触ってみた。
 * 参考サイト
 * http://blog.puchiplus.com/2009/07/jiglib-3d-physics-engine.php
 *
 */
package {
    import flash.events.Event;
    
    import org.papervision3d.view.BasicView;
    import org.papervision3d.materials.WireframeMaterial;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.objects.DisplayObject3D;
    
    import jiglib.plugin.papervision3d.Papervision3DPhysics;
    import jiglib.physics.RigidBody;
    
    import net.hires.debug.Stats;

    public class JiglibTest extends BasicView {
        private var _rootNode:DisplayObject3D;
        private var _physics:Papervision3DPhysics;
        private var _floor:RigidBody;
        
        private static const CUBE_SIZE:uint = 150;
        private static const CUBE_NUM:uint = 15;
        
        public function JiglibTest() {
            addChild(new Stats());
            
            _rootNode = new DisplayObject3D;
            scene.addChild(_rootNode);
            
            camera.y = 400;
            camera.z = -2000;
            
            _physics = new Papervision3DPhysics(_rootNode, 9.8);
            
            _floor = _physics.createGround(new WireframeMaterial(0), 2000, 0);
            _floor.y = -500;
            
            for (var i:int=0; i<CUBE_NUM; i++) {
                var matlist:MaterialsList = new MaterialsList();
                matlist.addMaterial(new WireframeMaterial(Math.random()*0xFFFFFF), "all");
                var cube:RigidBody = _physics.createCube(matlist, CUBE_SIZE, CUBE_SIZE, CUBE_SIZE);
                cube.restitution = 1.2;
                cube.friction = 0.2;
                cube.y = CUBE_SIZE * i + 1000;
            }
            
            startRendering();
        }
        
        override protected function onRenderTick(e:Event=null):void {
            _rootNode.rotationY += (stage.stageWidth/2 - stage.mouseX) / 70;
            _physics.step();
            super.onRenderTick(e);
        }

    }
}