/**
 * Copyright mex_takagi ( http://wonderfl.net/user/mex_takagi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rT2C
 */

// forked from mex's 【AS100本ノック】1本目：Hello World
/* 
 * AS100本ノック
 * 1本目のお題は「Hello World」
 * あなたなりの「Hello World」を表現してください。
 * 
 * 
 * 世界中の「Hello World!」を表示します。
 * ↓Google AJAX Language API使って「Hello World」を翻訳しております。
 * http://code.google.com/intl/ja/apis/ajaxlanguage/
 */
package 
{
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.utils.Timer;
    import flash.net.*;
    import com.flashdynamix.utils.SWFProfiler;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.tweens.ITween;
    import org.libspark.betweenas3.easing.*;
    import com.adobe.serialization.json.JSON;
    
    public class FlashTest extends Sprite 
    {
        private var _field:TextField;
        private var _timer:Timer;
        private var langArray:Array = [{c:"アフリカーンス語", i:"af"}, {c:"アルバニア語", i:"sq"}, {c:"アラビア語", i:"ar"}, {c:"ベラルーシ語", i:"be"}, {c:"ブルガリア語", i:"bg"}, 
                                       {c:"カタロニア語", i:"ca"}, {c:"中国語", i:"zh"}, {c:"簡易中国語", i:"zh-CN"}, {c:"中国語", i:"zh-TW"}, 
                                       {c:"クロアチア語", i:"hr"}, {c:"チェク語", i:"cs"}, {c:"デンマーク語", i:"da"}, {c:"エストニア語", i:"et"}, {c:"フィリピン語", i:"tl"}, 
                                       {c:"フィンランド語", i:"fi"}, {c:"フランス語", i:"fr"}, {c:"ガリシア語", i:"gl"}, {c:"ドイツ語", i:"de"}, {c:"ギリシャ語", i:"el"}, 
                                       {c:"ヘブライ語", i:"iw"}, {c:"ヒンディ語", i:"hi"}, {c:"ハンガリー語", i:"hu"}, {c:"アイスランド語", i:"is"}, {c:"インドネシア語", i:"id"}, 
                                       {c:"イタリア語", i:"it"}, {c:"日本語", i:"ja"}, {c:"韓国語", i:"ko"}, {c:"ラトビア語", i:"lv"}, {c:"リトアニア語", i:"lt"}, 
                                       {c:"マケドニア語", i:"mk"}, {c:"マレー語", i:"ms"}, {c:"マルチーズ語", i:"mt"}, {c:"ノルウェー語", i:"no"}, {c:"ペルシャ語", i:"fa"}, 
                                       {c:"ポーランド語", i:"pl"}, {c:"ポルトガル語", i:"pt-PT"}, {c:"ルーマニア語", i:"ro"}, {c:"ロシア語", i:"ru"}, {c:"セルビア語", i:"sr"}, 
                                       {c:"スロバキア語", i:"sk"}, {c:"スロベニア語", i:"sl"}, {c:"スペイン語", i:"es"}, {c:"スワヒリ語", i:"sw"}, {c:"スウェーデン語", i:"sv"}, 
                                       {c:"タガログ語", i:"tl"}, {c:"タイ語", i:"th"}, {c:"トルコ語", i:"tr"}, {c:"ウクライナ語", i:"uk"}, {c:"ヴェトナム語", i:"vi"}];
                                       
        /**
         * constructor
         */
        public function FlashTest() 
        {
            SWFProfiler.init(this);
            _field = new TextField();
            _field.autoSize = "left";
            _field.selectable = false;
            _field.text = "世界のハローワールド";
            _field.x = (stage.stageWidth - _field.width) / 2;
            _field.y = (stage.stageHeight - _field.height) / 2;
            addChild(_field);
            _timer = new Timer(3000);
            _timer.addEventListener(TimerEvent.TIMER, translate);
            _timer.start();
        }
        /**
         * 翻訳開始
         */
        private function translate(event:TimerEvent):void
        {
			var request:URLRequest = new URLRequest ('http://ajax.googleapis.com/ajax/services/language/translate');
			request.method = URLRequestMethod.GET;
			var len:uint = langArray.length;
			var rand:uint = Math.floor(Math.random() * len)
			var to:String = langArray[rand].i; 
			var variables:URLVariables = new URLVariables();
			variables.v = "1.0";
			variables.q = "Hello World!";
			variables.langpair = "en|" + to;
			request.data = variables;
			
			var loader:URLLoader = new URLLoader (request);
			loader.addEventListener(Event.COMPLETE, onComplete(langArray[rand].c));
			loader.load(request);
        }
        /**
         * 翻訳終了
         */
        private function onComplete (country:String):Function
        {
			return function (event:Event):void
			{
				var result:Array = JSON.decode(event.target.data);
				var serif:String = result.responseData.translatedText;
				var human:Sprite = createHuman(serif, country, Math.floor(Math.random() * 0xFFFFFF));
				human.x = Math.floor(Math.random()*((stage.stageWidth - 40) - 40 + 1)) + 40;
				human.y = Math.floor(Math.random()*((stage.stageHeight - 120) - 120 + 1)) + 120;
				addChild(human);
			}
        }
		/**
		 * 人作成
		 * @param	serifStr
		 * @param	country
		 * @param	color
		 * @return
		 */
        private function createHuman(serifStr:String, country:String, color:uint):Sprite
        {
			var human:Sprite = new Sprite();
			var head:Sprite = makeCircle(color);
			var body:Sprite = makeHalfCircle(color);
			var serif:Sprite = makeFukidashi(serifStr, color);
			var plate:Sprite = makePlate(country, color);
			serif.scaleX = 0;
			serif.scaleY = 0;
			head.y = head.height / 2;
			body.x = -body.width / 2;
			body.y = head.y + head.height / 2;
			plate.x = -serif.width / 2
			plate.y = body.y + body.height + plate.height;
			serif.x = -serif.width / 2
			serif.y = -serif.height;
			
			human.addChild(head);
			human.addChild(body);
			human.addChild(plate);
			human.addChild(serif);
			
			var t:ITween = BetweenAS3.tween(serif,{scaleX:1, scaleY:1}, null, 0.5, Bounce.easeOut);
			t.play();
			
			return human;
        }
        /**
         * 吹き出し描画
         */
        private function makeFukidashi(str:String, color:uint):Sprite
        {
			var margin:uint = 4;
			var round:uint = 5;
			var sprite:Sprite = new Sprite();
			var field:TextField = new TextField();
			field.autoSize = "left";
			field.text = str;
			
			var w:Number = field.width + margin * 2;
			var h:Number = field.height + margin * 2;
			
			var temp:Sprite = new Sprite();
			temp.graphics.beginFill(0xFFFFFF);
			temp.graphics.lineStyle(2, color);
			temp.graphics.moveTo(round, 0);
			temp.graphics.lineTo(w - round, 0);
			temp.graphics.curveTo(w, 0, w, round);
			temp.graphics.lineTo(w, h - round);
			temp.graphics.curveTo(w, h, w - round, h);
			temp.graphics.lineTo(w / 2 + round, h);
			temp.graphics.lineTo(w / 2, h + 10);
			temp.graphics.lineTo(w / 2 - round, h);
			temp.graphics.lineTo(round, h);
			temp.graphics.curveTo(0, h, 0, h - round);
			temp.graphics.lineTo(0, round);
			temp.graphics.curveTo(0, 0, round, 0);
			temp.graphics.endFill();
			
			temp.x = -temp.width / 2;
			temp.y = -temp.height;
			field.x = temp.x +  margin;
			field.y = temp.y + margin;
			
			sprite.addChild(temp);
			sprite.addChild(field);
			
			return sprite;
        }
		/**
         * 吹き出し描画
         */
        private function makePlate(str:String, color:uint):Sprite
        {
			var margin:uint = 4;
			var round:uint = 5;
			var sprite:Sprite = new Sprite();
			var field:TextField = new TextField();
			field.autoSize = "left";
			field.text = str;
			
			var w:Number = field.width + margin * 2;
			var h:Number = field.height + margin * 2;
			
			var temp:Sprite = new Sprite();
			temp.graphics.lineStyle(2, color);
                        temp.graphics.beginFill(0xFFFFFF);
			temp.graphics.moveTo(round, 0);
			temp.graphics.lineTo(w - round, 0);
			temp.graphics.curveTo(w, 0, w, round);
			temp.graphics.lineTo(w, h - round);
			temp.graphics.curveTo(w, h, w - round, h);
			temp.graphics.lineTo(round, h);
			temp.graphics.curveTo(0, h, 0, h - round);
			temp.graphics.lineTo(0, round);
			temp.graphics.curveTo(0, 0, round, 0);
			temp.graphics.endFill();
			
			temp.x = -temp.width / 2;
			temp.y = -temp.height;
			field.x = temp.x +  margin;
			field.y = temp.y + margin;
			
			sprite.addChild(temp);
			sprite.addChild(field);
			
			return sprite;
        }
        /**
         * 頭描画
         */
        private function makeCircle(color:uint):Sprite
        {
			var r:uint = 25;
			var temp:Sprite = new Sprite();
			temp.graphics.beginFill(color);
			temp.graphics.drawCircle(0, 0, r);
			temp.graphics.endFill();
			return temp;
        }
        /**
         * 体描画
         */
        private function makeHalfCircle(color:uint):Sprite
        {
			var r:uint = 30;
			var adjust:uint = 5;
			var temp:Sprite = new Sprite();
			temp.graphics.beginFill(color);
			temp.graphics.moveTo(0, r);
			temp.graphics.curveTo(0, 0, r - adjust, 0);
			temp.graphics.curveTo(2 * (r - adjust), 0, 2 *  (r - adjust), r);
			temp.graphics.lineTo(0, r);
			temp.graphics.endFill();
			return temp;
        }
    }
}