/**
 * Copyright GreekFellows ( http://wonderfl.net/user/GreekFellows )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rStj
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.net.URLRequest;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    public class Tracks extends Sprite {
        public var vehicles:Array;
        
        public var bitmapData:BitmapData;
        
        public var bd:BitmapData;
        public var b:Bitmap;
        public var s:Sprite;
        
        public const unit:int = 1;
        
        public function Tracks() {
            vehicles = [];
            
            setup();
        }
        
        public function setup():void {
            var loader:Loader = new Loader();
            loader.load(new URLRequest("http://upload.wikimedia.org/wikipedia/commons/2/2b/Andy_Warhol_by_Jack_Mitchell.jpg"));
            this.addChild(loader);
            
            bitmapData = new BitmapData(465, 465);
            bitmapData.draw(this);
            
            this.removeChild(loader);
            
            bd = new BitmapData(465, 465);
            b = new Bitmap(bd);
            this.addChild(b);
            s = new Sprite();
            
            this.addEventListener(Event.ENTER_FRAME, tracks);
            
            for (var it:int = 0; it < 100; it++) {
                vehicles.push({cx:Math.random() * 465, cy:Math.random() * 465, angle:Math.random() * 360, radius:Math.random() * 80 + 20, x:0, y:0, color:0});
            }
        }
        
        public function tracks(e:Event):void {
            for (var ind:int = 0; ind < vehicles.length; ind++) {
                vehicles[ind].angle++;
                
                vehicles[ind].x = vehicles[ind].cx + Math.cos(vehicles[ind].angle * Math.PI / 180) * vehicles[ind].radius;
                vehicles[ind].y = vehicles[ind].cy + Math.sin(vehicles[ind].angle * Math.PI / 180) * vehicles[ind].radius;
                //vehicles[ind].color = bitmapData.getPixel(vehicles[ind].x, vehicles[ind].y);
                
                s.graphics.beginFill(vehicles[ind].color, 1);
                s.graphics.drawRect(vehicles[ind].x, vehicles[ind].y, 1, 1);
                s.graphics.endFill();
            }
            
            bd.draw(s);
        }
    }
}