/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rSmeB
 */

// forked from tepe's forked from: forked from: スクロールバー (1)
// forked from tepe's forked from: スクロールバー (1)
// forked from ProjectNya's スクロールバー (1)

//矩形エリアにスクロールバーを実装する
//リサイズにあわせてスクロールバーを調整する
//マウスオーバーしないときは表示幅を狭くする
//マウスオーバーでバーの幅を広くする
//スクロールバー上にチャプターを設定する：

//横スクロール実装

////////////////////////////////////////////////////////////////////////////////
//  スクロールバー (1)
////////////////////////////////////////////////////////////////////////////////

package {
    import flash.text.TextField;

    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.geom.Matrix;
    import flash.display.GradientType;
    import flash.display.SpreadMethod;
    import flash.display.InterpolationMethod;

    [SWF(backgroundColor="#FFFFFF", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var panel:Shape;
        private var _mask:Shape;
        private var scrollBar:ScrollBar;

        public function Main() {
            init();
        }

        private function init():void {
            var t:TextField = new TextField();
            //scrollBar.setTF(t);
            t.border = true;
            t.text = "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa\n\n\n\n\n\n\n\n\n\n\n\ncc\n\n\n\n\n\n\n\n\n\n\n\nbb";
            t.multiline=true;
            t.type ="input";
            t.x = 30;
            t.y = 30;
            t.width=300;
            t.height=300;
            addChild(t);
            //scrollBar = new ScrollBar();
            //scrollBar.setTF(t);
            
            var v:vScr = new vScr();
            //var h:hScr = new hScr();
            v.setTF(t);
            //h.setTF(t);
            
        }

    }

}



import flash.display.*;
import flash.events.*;
import flash.text.*;
import flash.ui.*;

class WindowPanel extends Sprite{
    private var _title:String = "";
    private var _mx:Number = 20;
    private var _my:Number = 10;
    private var _target:DisplayObject;
    private var _tf:TextField;
    public function WindowPanel(o:DisplayObject=null){
        if(o!=null)target=o;
        draw();
        addEventListener(MouseEvent.MOUSE_MOVE,onMove);
        addEventListener(MouseEvent.MOUSE_OUT,onOut);
        addEventListener(MouseEvent.MOUSE_DOWN,onDrag);
        addEventListener(MouseEvent.MOUSE_UP,onDrop);
    }
    public function set target(o:DisplayObject):void{
        _target = o;
        addChild(o);
        x = o.x;
        y = o.y;
        o.x=0;
        o.y=0;
        
        draw();
    }
    
    public function set title(t:String):void{
        _title = t;
        draw();
    }


    //タイトル表示
    private function initTF():void{
        _tf = new TextField();
        _tf.text = _title;
        _tf.y = -_my;
        _tf.selectable = false;
        _tf.width = _tf.textWidth+5;
        _tf.height = _tf.textHeight+5;
        addChild(_tf);
    }

    //ウィンドウ更新
    public function draw(c:uint=0x000000,a:Number=0.2):void{
        initTF();
        var w:Number,h:Number;
        if(_target==null){w=this.width;h=this.height;}
        else{ 
            w=_target.width;h=_target.height;
            this.x += _target.x;
            this.y += _target.y;
            _target.x = 0;
            _target.y = 0;
        }
        
        this.graphics.clear();
        this.graphics.lineStyle(0,0x0,a);
        this.graphics.beginFill(c,a);
        this.graphics.drawRect(-_mx,-_my,w+_mx*2,h+_my*2);
        this.graphics.endFill();
    }
    
    private function onOut(e:MouseEvent):void{
        Mouse.cursor = MouseCursor.AUTO;
    }

    private function onMove(e:MouseEvent):void{
        if(e.target == this)Mouse.cursor = MouseCursor.HAND;
        else Mouse.cursor = MouseCursor.AUTO;
    }

        
    private function onDrag(e:MouseEvent):void{
        if(e.target == this){
            this.startDrag();
        }
        draw();
        e.currentTarget.parent.setChildIndex(e.currentTarget,e.currentTarget.parent.numChildren-1); //並べ替え
    }
    private function onDrop(e:MouseEvent):void{
        this.stopDrag();
        draw();
    }
}



////////////////////////////////////////////////////////////////////////////////
//  ScrollBarクラス
////////////////////////////////////////////////////////////////////////////////

import flash.display.*;
import flash.events.*;
import flash.geom.*;
import flash.text.*;
class vScr extends Sprite {
    private var _width:uint = 16;
    private var _height:uint =16;
    
    private var track:Sprite;
    private var thumb:Sprite;

    private var maxHeight:uint;
    private var clickPos:Number;
    private var _enabled:Boolean = true;
    private var txt:TextField;

    public function vScr() {
        init();
    }

    
    
    public function setTF(tf:TextField):void{
        txt = tf;
        txt.addEventListener(Event.SCROLL,onScroll);
        tf.parent.addChild(this);
        resize();
        onScroll();
        
    }
    private function onScroll(e:Event=null):void{
        resize();
        var pos:Number =  maxHeight*(txt.scrollV / txt.maxScrollV);
        if (txt.scrollV == 1) pos = 0;
        if (txt.maxScrollV == txt.scrollV) pos = maxHeight;
        thumb.y = pos;
    }

    
    private function resize():void{        
        this.x = txt.x +txt.width  +1;
        this.y = txt.y;
        this.alpha = 0.5;
        _height = txt.height+1;
        
        if(txt.textHeight < txt.height){//スクロールバー非表示 
            txt.parent.removeChild(this);
            return;
        }
        var n:Number = txt.height / txt.textHeight;
        var thumbHeight:uint = _height*n;
        maxHeight = _height - thumbHeight;
 
        createTrack(_width,_height,0xaaaaaa);
        createThumb(_width,thumbHeight,0x888888);  
        txt.parent.addChild(this);//スクロールバー表示
        
    }

    
    private function init():void {

        track = new Sprite();
        thumb = new Sprite();
        addChild(track);
        addChild(thumb);
        enabled = true;
        thumb.mouseChildren = false;
    }

    

    private function press(evt:MouseEvent=null):void {
        thumb.addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
        //track.addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
        stage.addEventListener(MouseEvent.MOUSE_UP, releaseOutside, false, 0, true);
        stage.addEventListener(Event.MOUSE_LEAVE, leave, false, 0, true);
        clickPos = thumb.mouseY;
        //clickPos = track.mouseY;
        stage.addEventListener(MouseEvent.MOUSE_MOVE, drag, false, 0, true);
    }
    private function release(evt:MouseEvent):void {
        thumb.removeEventListener(MouseEvent.MOUSE_UP, release);
        //track.removeEventListener(MouseEvent.MOUSE_UP, release);
        stage.removeEventListener(MouseEvent.MOUSE_UP, releaseOutside);
        stage.removeEventListener(Event.MOUSE_LEAVE, leave);
        stage.removeEventListener(MouseEvent.MOUSE_MOVE, drag);
    }
    private function releaseOutside(evt:MouseEvent):void {
        thumb.removeEventListener(MouseEvent.MOUSE_UP, release);
        stage.removeEventListener(MouseEvent.MOUSE_UP, releaseOutside);
        stage.removeEventListener(Event.MOUSE_LEAVE, leave);
        stage.removeEventListener(MouseEvent.MOUSE_MOVE, drag);
    }
    private function leave(evt:MouseEvent):void {
        thumb.removeEventListener(MouseEvent.MOUSE_UP, release);
        stage.removeEventListener(MouseEvent.MOUSE_UP, releaseOutside);
        stage.removeEventListener(Event.MOUSE_LEAVE, leave);
        stage.removeEventListener(MouseEvent.MOUSE_MOVE, drag);
    }
    
    private function drag(evt:MouseEvent):void {
        var position:Number = stage.mouseY - clickPos;
        if (position < 0) position = 0;
        if (position > maxHeight) position = maxHeight;
        thumb.y = position;
        txt.scrollV = Math.round(txt.maxScrollV*(position/maxHeight));
        evt.updateAfterEvent();
    }
    
    private function click(evt:MouseEvent):void {        
        var position:Number = track.mouseY - (thumb.height/2);
        if (position < 0) position = 0;
        if (position > maxHeight) position = maxHeight;
 
        thumb.y = position;
        txt.scrollV = Math.round(txt.maxScrollV*(position/maxHeight));
        evt.updateAfterEvent();
        press();
    }
    
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(param:Boolean):void {
        _enabled = param;
        thumb.buttonMode = _enabled;
        thumb.mouseEnabled = _enabled;
        thumb.useHandCursor = _enabled;  
        track.mouseEnabled = _enabled;
        if (_enabled) {
            thumb.addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
            track.addEventListener(MouseEvent.MOUSE_DOWN, click, false, 0, true);
        } else {
            thumb.removeEventListener(MouseEvent.MOUSE_DOWN, press);
            track.removeEventListener(MouseEvent.MOUSE_DOWN, click);
        }
    }
    
    //スクロール表示位置
    private function createThumb(w:uint, h:uint,c:uint):void {
        
        with(thumb){
            graphics.clear();
            graphics.beginFill(c);
            graphics.drawRect(0,0, w-1, h);
            graphics.endFill();
        }
    }
    
    //スクロール範囲
    private function createTrack(w:uint, h:uint,c:uint):void {
        with(track){
            graphics.clear();
            graphics.beginFill(c);
            graphics.drawRect(0,0, w-1, h);
            graphics.endFill();
        }
    }

}


////////////////////////////////////////////////////////////////////////////////
//  ScrollBarクラス
////////////////////////////////////////////////////////////////////////////////

import flash.display.*;
import flash.events.*;
import flash.geom.*;
import flash.text.*;
class hScr extends Sprite {
    private var _width:uint = 16;
    private var _height:uint =16;
    
    private var track:Sprite;
    private var thumb:Sprite;

    private var maxWidth:uint;
    private var clickPos:Number;
    private var _enabled:Boolean = true;
    private var txt:TextField;

    public function hScr() {
        init();
    }

    
    
    public function setTF(tf:TextField):void{
        txt = tf;
        txt.addEventListener(Event.SCROLL,onScroll);
        tf.parent.addChild(this);       
        resize();
        onScroll();
        
    }
    //キー入力イベント
    private function onScroll(e:Event=null):void{
        resize();
        var n:Number = (txt.scrollH / txt.maxScrollH);
        var pos:Number =  maxWidth*n;
        if (txt.scrollH == 1) pos = 0;
        if (txt.maxScrollH == txt.scrollH) pos = maxWidth;
        thumb.x = pos;
    }
    

    public function onChange(e:Event=null):void{
        resize();
    }
    
    
    private function resize():void{        
        this.y = txt.y +txt.height +1;
        this.x = txt.x;
        this.alpha = 0.5;
        _width = txt.width +1;
        
        if(txt.textWidth < txt.width){//スクロールバー非表示 
            txt.parent.removeChild(this);
            return;
        }
        var n:Number = txt.width / txt.textWidth;
        var thumbWidth:uint = _width*n;
        maxWidth = _width - thumbWidth;
 
        createTrack(_width,_height,0xaaaaaa);
        createThumb(thumbWidth,_height,0x888888);  
        txt.parent.addChild(this);//スクロールバー表示
        
    }

    
    private function init():void {

        track = new Sprite();
        thumb = new Sprite();
        addChild(track);
        addChild(thumb);
        enabled = true;
        thumb.mouseChildren = false;
    }

    

    private function press(evt:MouseEvent=null):void {
        thumb.addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
        //track.addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
        stage.addEventListener(MouseEvent.MOUSE_UP, releaseOutside, false, 0, true);
        stage.addEventListener(Event.MOUSE_LEAVE, leave, false, 0, true);
        clickPos = thumb.mouseX;
        //clickPos = track.mouseY;
        stage.addEventListener(MouseEvent.MOUSE_MOVE, drag, false, 0, true);
    }
    private function release(evt:MouseEvent):void {
        thumb.removeEventListener(MouseEvent.MOUSE_UP, release);
        //track.removeEventListener(MouseEvent.MOUSE_UP, release);
        stage.removeEventListener(MouseEvent.MOUSE_UP, releaseOutside);
        stage.removeEventListener(Event.MOUSE_LEAVE, leave);
        stage.removeEventListener(MouseEvent.MOUSE_MOVE, drag);
    }
    private function releaseOutside(evt:MouseEvent):void {
        thumb.removeEventListener(MouseEvent.MOUSE_UP, release);
        stage.removeEventListener(MouseEvent.MOUSE_UP, releaseOutside);
        stage.removeEventListener(Event.MOUSE_LEAVE, leave);
        stage.removeEventListener(MouseEvent.MOUSE_MOVE, drag);
    }
    private function leave(evt:MouseEvent):void {
        thumb.removeEventListener(MouseEvent.MOUSE_UP, release);
        stage.removeEventListener(MouseEvent.MOUSE_UP, releaseOutside);
        stage.removeEventListener(Event.MOUSE_LEAVE, leave);
        stage.removeEventListener(MouseEvent.MOUSE_MOVE, drag);
    }
    
    private function drag(evt:MouseEvent):void {
        var position:Number = stage.mouseX - clickPos;
        if (position < 0) position = 0;
        if (position > maxWidth) position = maxWidth;
        thumb.x = position;
        txt.scrollH = Math.round(txt.maxScrollH*(position/maxWidth));
        evt.updateAfterEvent();
    }
    
    private function click(evt:MouseEvent):void {        
        var position:Number = track.mouseX - (thumb.width/2);
        if (position < 0) position = 0;
        if (position > maxWidth) position = maxWidth;
 
        thumb.x = position;
        txt.scrollH = Math.round(txt.maxScrollH*(position/maxWidth));
        
        evt.updateAfterEvent();
        press();
    }
    
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(param:Boolean):void {
        _enabled = param;
        thumb.buttonMode = _enabled;
        thumb.mouseEnabled = _enabled;
        thumb.useHandCursor = _enabled;  
        track.mouseEnabled = _enabled;
        if (_enabled) {
            thumb.addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
            track.addEventListener(MouseEvent.MOUSE_DOWN, click, false, 0, true);
        } else {
            thumb.removeEventListener(MouseEvent.MOUSE_DOWN, press);
            track.removeEventListener(MouseEvent.MOUSE_DOWN, click);
        }
    }
    
    //スクロール表示位置
    private function createThumb(w:uint, h:uint,c:uint):void {
        
        with(thumb){
            graphics.clear();
            graphics.beginFill(c);
            graphics.drawRect(0,0, w-1, h);
            graphics.endFill();
        }
    }
    
    //スクロール範囲
    private function createTrack(w:uint, h:uint,c:uint):void {
        with(track){
            graphics.clear();
            graphics.beginFill(c);
            graphics.drawRect(0,0, w-1, h);
            graphics.endFill();
        }
    }

}

////////////////////////////////////////////////////////////////////////////////
//  ScrollBarクラス
////////////////////////////////////////////////////////////////////////////////

import flash.display.*;
import flash.events.*;
import flash.geom.*;
import flash.text.*;
class ScrollBar extends Sprite {
    private var _width:uint = 16;
    private var _height:uint;
    
    private var track:Sprite;
    private var thumb:Sprite;

    private var maxHeight:uint;
//    private var target:DisplayObject;
//    private var rect:DisplayObject;
    private var clickPos:Number;
    private var _enabled:Boolean = true;
    private var txt:TextField;

    public function ScrollBar() {
        init();
    }

    
    
    public function setTF(tf:TextField):void{
        txt = tf;
        txt.addEventListener(KeyboardEvent.KEY_DOWN,onKey);
        tf.parent.addChild(this);
        onKey();
        
    }
    //キー入力イベント
    private function onKey(e:KeyboardEvent=null):void{
        resize();
        var pos:Number =  maxHeight*(txt.scrollV / txt.maxScrollV);
        if (txt.scrollV == 1) pos = 0;
        if (txt.maxScrollV == txt.scrollV) pos = maxHeight;
        thumb.y = pos;
        e.updateAfterEvent();
    }

    public function onChange(e:Event=null):void{
        resize();
    }
    
    
    private function resize():void{
        this.x = txt.x +txt.width -_width +1;
        this.y = txt.y;
        this.alpha = 0.5;
        _height = txt.height;
        
        if(txt.textHeight < txt.height){//スクロールバー非表示 
            txt.parent.removeChild(this);
            return;
        }
        var n:Number = txt.height / txt.textHeight;
        var thumbHeight:uint = _height*n;
        maxHeight = _height - thumbHeight;
 
        createTrack(_width,_height,0xaaaaaa);
        createThumb(_width,thumbHeight,0x888888);  
        txt.parent.addChild(this);//スクロールバー表示
        
    }

    
    private function init():void {

        track = new Sprite();
        thumb = new Sprite();
        addChild(track);
        addChild(thumb);
        enabled = true;
        thumb.mouseChildren = false;
    }

    

    private function press(evt:MouseEvent=null):void {
        thumb.addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
        //track.addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
        stage.addEventListener(MouseEvent.MOUSE_UP, releaseOutside, false, 0, true);
        stage.addEventListener(Event.MOUSE_LEAVE, leave, false, 0, true);
        clickPos = thumb.mouseY;
        //clickPos = track.mouseY;
        stage.addEventListener(MouseEvent.MOUSE_MOVE, drag, false, 0, true);
    }
    private function release(evt:MouseEvent):void {
        thumb.removeEventListener(MouseEvent.MOUSE_UP, release);
        //track.removeEventListener(MouseEvent.MOUSE_UP, release);
        stage.removeEventListener(MouseEvent.MOUSE_UP, releaseOutside);
        stage.removeEventListener(Event.MOUSE_LEAVE, leave);
        stage.removeEventListener(MouseEvent.MOUSE_MOVE, drag);
    }
    private function releaseOutside(evt:MouseEvent):void {
        thumb.removeEventListener(MouseEvent.MOUSE_UP, release);
        stage.removeEventListener(MouseEvent.MOUSE_UP, releaseOutside);
        stage.removeEventListener(Event.MOUSE_LEAVE, leave);
        stage.removeEventListener(MouseEvent.MOUSE_MOVE, drag);
    }
    private function leave(evt:MouseEvent):void {
        thumb.removeEventListener(MouseEvent.MOUSE_UP, release);
        stage.removeEventListener(MouseEvent.MOUSE_UP, releaseOutside);
        stage.removeEventListener(Event.MOUSE_LEAVE, leave);
        stage.removeEventListener(MouseEvent.MOUSE_MOVE, drag);
    }
    
    private function drag(evt:MouseEvent):void {
        var position:Number = stage.mouseY - clickPos;
        if (position < 0) position = 0;
        if (position > maxHeight) position = maxHeight;
        thumb.y = position;
        txt.scrollV = Math.round(txt.maxScrollV*(position/maxHeight));
        evt.updateAfterEvent();
    }
    
    private function click(evt:MouseEvent):void {        
        var position:Number = track.mouseY - (thumb.height/2);
        if (position < 0) position = 0;
        if (position > maxHeight) position = maxHeight;
 
        thumb.y = position;
        txt.scrollV = Math.round(txt.maxScrollV*(position/maxHeight));
        evt.updateAfterEvent();
        press();
    }
    
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(param:Boolean):void {
        _enabled = param;
        thumb.buttonMode = _enabled;
        thumb.mouseEnabled = _enabled;
        thumb.useHandCursor = _enabled;  
        track.mouseEnabled = _enabled;
        if (_enabled) {
            //_up();
            //thumb.addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            //thumb.addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            thumb.addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
            track.addEventListener(MouseEvent.MOUSE_DOWN, click, false, 0, true);
        } else {
            //_off();
            //thumb.removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            //thumb.removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
            thumb.removeEventListener(MouseEvent.MOUSE_DOWN, press);
            track.removeEventListener(MouseEvent.MOUSE_DOWN, click);
        }
    }
    
    //スクロール表示位置
    private function createThumb(w:uint, h:uint,c:uint):void {
        
        with(thumb){
            graphics.clear();
            graphics.beginFill(c);
            graphics.drawRect(0,0, w-1, h);
            graphics.endFill();
        }
    }
    
    //スクロール範囲
    private function createTrack(w:uint, h:uint,c:uint):void {
        with(track){
            graphics.clear();
            graphics.beginFill(c);
            graphics.drawRect(0,0, w-1, h);
            graphics.endFill();
        }
    }

}









////////////////////////////////////////////////////////////////////////////////
//  ScrollBarクラス
////////////////////////////////////////////////////////////////////////////////

import flash.display.*;
import flash.events.*;
import flash.geom.*;
import flash.text.*;
class vScrollBar extends Sprite {
    public var id:uint;
    private static var _width:uint = 16;
    private var _height:uint;
    private var track:Sprite;
    private var thumb:Sprite;
    private var base:Shape;
    private var handle:Shape;
    private static var bColor:uint = 0x333333;
    private static var tColor:uint = 0x000000;
    private static var hColor:uint = 0x999999;
    private static var upColor:uint = 0x333333;
    private static var overColor:uint = 0x444444;
    private static var offColor:uint = 0xCCCCCC;
    private static var upColorTrans:ColorTransform;
    private static var overColorTrans:ColorTransform;
    private static var offColorTrans:ColorTransform;
    private static var minHeight:uint = 20;

    private var maxHeight:uint;
    private var thumbHeight:uint = minHeight;
    private var target:DisplayObject;
    private var rect:DisplayObject;
    private var clickPos:Number;
    private var basePos:int;
    private var _enabled:Boolean = true;
    private var txt:TextField;

    public function vScrollBar() {
        init();
    }

    
    
    public function setTF(tf:TextField):void{
        txt = tf;
        txt.addEventListener(KeyboardEvent.KEY_DOWN,onKey);
        tf.parent.addChild(this);
        onKey();
        
    }
    private function onKey(e:KeyboardEvent=null):void{
        onChange();
        var pos:Number =  maxHeight*(txt.scrollV / txt.maxScrollV);
        if (txt.scrollV == 1) pos = 0;
        if (txt.maxScrollV == txt.scrollV) pos = maxHeight;
        thumb.y = pos;
        e.updateAfterEvent();
    }

    public function onChange(e:Event=null):void{
        this.x = txt.x+txt.width;// -_width;
        this.y = txt.y;
        _height = txt.height;
        var n:Number;
        if(txt.height<txt.textHeight){ 
            n = txt.height/txt.textHeight;
            txt.parent.addChild(this);
        }
        else{ 
            n = 1;
            txt.parent.removeChild(this);
        }
        thumbHeight = Math.max(minHeight,_height*n);
        maxHeight = _height - thumbHeight;
        if (thumb.y < 0) thumb.y = 0;
        if (thumb.y > maxHeight) thumb.y = maxHeight;
        createTrack(_width,_height);
        createThumb(_width,thumbHeight);  
    }
    private function init():void {
        
        upColorTrans = new ColorTransform();
        upColorTrans.color = upColor;
        overColorTrans = new ColorTransform();
        overColorTrans.color = overColor;
        offColorTrans = new ColorTransform();
        offColorTrans.color = offColor;
        //*/
        track = new Sprite();
        thumb = new Sprite();
        base = new Shape();
        handle = new Shape();
        
        addChild(track);
        addChild(thumb);
        enabled = true;
        thumb.mouseChildren = false;
    }
    
    private function rollOver(evt:MouseEvent):void {
        _over();
    }
    private function rollOut(evt:MouseEvent):void {
        _up();
    }
    private function press(evt:MouseEvent):void {
        _down();
        thumb.addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
        stage.addEventListener(MouseEvent.MOUSE_UP, releaseOutside, false, 0, true);
        stage.addEventListener(Event.MOUSE_LEAVE, leave, false, 0, true);
        clickPos = thumb.mouseY;
        stage.addEventListener(MouseEvent.MOUSE_MOVE, drag, false, 0, true);
    }
    private function release(evt:MouseEvent):void {
        _up();
        thumb.removeEventListener(MouseEvent.MOUSE_UP, release);
        stage.removeEventListener(MouseEvent.MOUSE_UP, releaseOutside);
        stage.removeEventListener(Event.MOUSE_LEAVE, leave);
        stage.removeEventListener(MouseEvent.MOUSE_MOVE, drag);
    }
    private function releaseOutside(evt:MouseEvent):void {
        _up();
        thumb.removeEventListener(MouseEvent.MOUSE_UP, release);
        stage.removeEventListener(MouseEvent.MOUSE_UP, releaseOutside);
        stage.removeEventListener(Event.MOUSE_LEAVE, leave);
        stage.removeEventListener(MouseEvent.MOUSE_MOVE, drag);
    }
    private function leave(evt:MouseEvent):void {
        _up();
        thumb.removeEventListener(MouseEvent.MOUSE_UP, release);
        stage.removeEventListener(MouseEvent.MOUSE_UP, releaseOutside);
        stage.removeEventListener(Event.MOUSE_LEAVE, leave);
        stage.removeEventListener(MouseEvent.MOUSE_MOVE, drag);
    }
    
    private function drag(evt:MouseEvent):void {
        var position:Number = stage.mouseY - clickPos;
        if (position < 0) position = 0;
        if (position > maxHeight) position = maxHeight;
        thumb.y = position;
        txt.scrollV = Math.round(txt.maxScrollV*(position/maxHeight));
        evt.updateAfterEvent();
    }
    private function click(evt:MouseEvent):void {}
    
    private function _up():void {
        base.transform.colorTransform = upColorTrans;
    }
    private function _over():void {
        base.transform.colorTransform = overColorTrans;
    }
    private function _down():void {
        base.transform.colorTransform = overColorTrans;
    }
    private function _off():void {
        base.transform.colorTransform = offColorTrans;
    }
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(param:Boolean):void {
        _enabled = param;
        thumb.buttonMode = _enabled;
        thumb.mouseEnabled = _enabled;
        thumb.useHandCursor = _enabled;
        track.mouseEnabled = _enabled;
        if (_enabled) {
            _up();
            thumb.addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            thumb.addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            thumb.addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
            track.addEventListener(MouseEvent.CLICK, click, false, 0, true);
        } else {
            _off();
            thumb.removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            thumb.removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
            thumb.removeEventListener(MouseEvent.MOUSE_DOWN, press);
            track.removeEventListener(MouseEvent.CLICK, click);
        }
    }
    
    private function createThumb(w:uint, h:uint):void {
        thumb.addChild(base);
        thumb.addChild(handle);
        handle.y = uint(h/2);
        
        base.graphics.clear();
        base.graphics.beginFill(tColor);
        base.graphics.drawRect(0, 0, w, h+1);
        base.graphics.endFill();
        
        handle.graphics.clear();
        handle.graphics.beginFill(hColor);
        handle.graphics.drawRect(w/4, -4, w/2, 1);
        handle.graphics.endFill();
        handle.graphics.beginFill(hColor);
        handle.graphics.drawRect(w/4, -2, w/2, 1);
        handle.graphics.endFill();
        handle.graphics.beginFill(hColor);
        handle.graphics.drawRect(w/4, 0, w/2, 1);
        handle.graphics.endFill();
        handle.graphics.beginFill(hColor);
        handle.graphics.drawRect(w/4, 2, w/2, 1);
        handle.graphics.endFill();
    }
    
    private function createTrack(w:uint, h:uint):void {
        track.graphics.clear();
        track.graphics.beginFill(bColor,0.5);
        track.graphics.drawRect(0, 0, w, h+1);
        track.graphics.endFill();
    }

}

