/**
 * Copyright hacker_cobulht0 ( http://wonderfl.net/user/hacker_cobulht0 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rSZA
 */

//O'ReillyのHTML5 Canvasを読んで
package {     
    import flash.display.Sprite;
    import flash.events.*;
    
    [SWF(width = "465", height = "465", backgroundColor = 0xffffff, frameRate = "60")]
    
    public class BallCollision extends Sprite{
        private var _Max:uint=8;
        private var _List:Array=new Array();
        
        public function BallCollision(){
            if (stage) init();else addEventListener(Event.ADDED_TO_STAGE,init );
        }
        public function init(ev:Event = null){
            removeEventListener( Event.ADDED_TO_STAGE, init ) ;            
            
            var bg:back_ground=new back_ground();
            addChildAt(bg,0);
            
            for (var q:uint= 0; q < _Max; q++) {
                var _ball:Balls=new Balls();
                _ball.x=_ball.nx;
                _ball.y=_ball.ny;
                addChild(_ball);
                _List.push(_ball);
            }            
            addEventListener(Event.ENTER_FRAME, _EF);
        }
        private function _EF(ev){
            for (var q:uint= 0; q < _List.length; q++) {
                var _ball:Balls=_List[q];
                checkWalls(_ball);
                _ball.nx = _ball.x + _ball.vx;
                _ball.ny = _ball.y + _ball.vy;
                _ball.x=_ball.nx;
                _ball.y=_ball.ny;
                
                for (var j = 0; j < _List.length; j++) {
                        var _ball2:Balls=_List[j];
                    if (hitTestCircle(_ball,_ball2)) {
                        checkCollision(_ball,_ball2);
                    }
                }
            }
        }
        
        private function hitTestCircle(ball1, ball2):Boolean {
            var _Boolean:Boolean = false;
            var dx:Number = ball1.nx - ball2.nx;
            var dy:Number = ball1.ny - ball2.ny;
            var distance:Number = (dx * dx + dy * dy);
            if (distance <= (ball1.radius + ball2.radius) * (ball1.radius + ball2.radius)) {
                _Boolean = true;
            }
            return _Boolean;
        }
        
        private function checkWalls(_ball){
            if (_ball.nx + _ball.radius > 455) {
                _ball.vx = _ball.vx*-1;
                _ball.nx = 455 - _ball.radius;
        
            } else if (_ball.nx - _ball.radius < 5 ) {
                _ball.vx = _ball.vx*-1;
                _ball.nx =  _ball.radius;
        
            } else if (_ball.ny + _ball.radius > 455 ) {
                _ball.vy = _ball.vy*-1;
                _ball.ny = 455 - _ball.radius;
        
            } else if (_ball.ny - _ball.radius < 5) {
                _ball.vy = _ball.vy*-1;
                _ball.ny =  _ball.radius;
            }
        }
        
        function checkCollision(ball1,ball2){
            var dx:Number = ball1.nx - ball2.nx;
            var dy:Number = ball1.ny - ball2.ny;
        
            var collisionAngle:Number = Math.atan2(dy, dx);
        
            var speed1:Number = Math.sqrt(ball1.vx * ball1.vx + ball1.vy * ball1.vy);
            var speed2:Number = Math.sqrt(ball2.vx * ball2.vx + ball2.vy * ball2.vy);
        
            var direction1:Number = Math.atan2(ball1.vy, ball1.vx);
            var direction2:Number = Math.atan2(ball2.vy, ball2.vx);
        
            var vx_1:Number = speed1 * Math.cos(direction1 - collisionAngle);
            var vy_1:Number = speed1 * Math.sin(direction1 - collisionAngle);
            var vx_2:Number = speed2 * Math.cos(direction2 - collisionAngle);
            var vy_2:Number = speed2 * Math.sin(direction2 - collisionAngle);
            
            var final_vx_1:Number = ((ball1.mass - ball2.mass) * vx_1 + (ball2.mass + ball2.mass) * vx_2) / (ball1.mass + ball2.mass);
            var final_vx_2:Number = ((ball1.mass + ball1.mass) * vx_1 + (ball2.mass - ball1.mass) * vx_2) / (ball1.mass + ball2.mass);
        
            var final_vy_1:Number = vy_1;
            var final_vy_2:Number = vy_2;
        
            ball1.vx = Math.cos(collisionAngle) * final_vx_1 + Math.cos(collisionAngle + Math.PI/2) * final_vy_1;
            ball1.vy = Math.sin(collisionAngle) * final_vx_1 + Math.sin(collisionAngle + Math.PI/2) * final_vy_1;
            ball2.vx = Math.cos(collisionAngle) * final_vx_2 + Math.cos(collisionAngle + Math.PI/2) * final_vy_2;
            ball2.vy = Math.sin(collisionAngle) * final_vx_2 + Math.sin(collisionAngle + Math.PI/2) * final_vy_2;
        
            ball1.nx = (ball1.nx += ball1.vx);
            ball1.ny = (ball1.ny += ball1.vy);
            ball2.nx = (ball2.nx += ball2.vx);
            ball2.ny = (ball2.ny += ball2.vy);
        }
    
    }//
}





import flash.display.*;
class back_ground extends Sprite{
public function back_ground( ){
    var bmp:BitmapData = new BitmapData(465*2, 465*2, false, 0xffffff);
    var sh:Sprite = new Sprite();
    
    sh.graphics.lineStyle(1,0x83ccd2);
    sh.graphics.drawRect(0,0,465,465);
    sh.graphics.endFill();
    for (var q:uint= 0; q < 227; q++) {
        sh.graphics.lineStyle();//lineStyle中止
        if(q%2==0){sh.graphics.beginFill(0x59b9c6);}else{sh.graphics.beginFill(0xa2d7dd);}
        sh.graphics.drawRect(5, 5+q*2, 455, 2);
        sh.graphics.endFill();
    }
    bmp.draw(sh);
    addChild(new Bitmap(bmp))
}
}

class Balls extends Sprite{
    public var radius:Number=Math.floor(Math.random()*20)+10;//CircleSize;
    public var angle:Number=Math.floor(Math.random()*360);
    public var speed:Number=Math.floor(Math.random()*3)+1;
    
    public var nx:Number = Math.floor(Math.random()*455)+5;
    public var ny:Number = Math.floor(Math.random()*455)+5;
    public var vx:Number = Math.cos(angle* Math.PI/180)*speed;
    public var vy:Number = Math.sin(angle* Math.PI/180)*speed;
    public var mass:Number=radius;
public function Balls(){
    this.graphics.beginFill(0xFFFFFF);
    this.graphics.drawCircle(0,0,radius);
    this.graphics.endFill();
}
}