/**
 * Copyright siouxcitizen ( http://wonderfl.net/user/siouxcitizen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rS91
 */

// forked from siouxcitizen's Away3D Gold Practice03 WireframePlane 5枚表示
// forked from siouxcitizen's Away3D Gold Practice02 Plane 5枚表示
// forked from siouxcitizen's Away3D Gold Practice01 Plane 1枚表示
//Away3D 4.0 Gold で複数Sphereを表示してみました
//
//以下サイトを参考にさせて頂きしました
//SphereGeometry
//http://away3d.com/livedocs/away3d/4.0/away3d/primitives/SphereGeometry.html
//
//[Away3D] 球体 (2)
//http://www.project-nya.jp/modules/weblog/details.php?blog_id=1727
//
//away3d-tutorials-fp11 / tutorials / scenegraph / basic_view / src / Basic_View.as
//https://github.com/away3d/away3d-tutorials-fp11/blob/master/tutorials/scenegraph/basic_view/src/Basic_View.as
//
package {
    import away3d.containers.View3D;
    import away3d.debug.AwayStats;
    import away3d.entities.Mesh;
    import away3d.materials.ColorMaterial;
    import away3d.primitives.WireframeSphere
    import away3d.primitives.SphereGeometry;
    import away3d.primitives.PrimitiveBase;
    import away3d.lights.DirectionalLight;
    import away3d.materials.lightpickers.StaticLightPicker;

    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Vector3D;

    import flash.display.Bitmap;
    import flash.display.BitmapData;

    [SWF(backgroundColor="#FFFFFF", frameRate="60", width="465", height="465")]
    public class SphereSample extends Sprite {

        private static const ZERO : Vector3D = new Vector3D(0, 0, 0);
        private var _view : View3D;
        private var _sphereGeo : PrimitiveBase;
        private var _sphereMat : ColorMaterial;
        private var _sphere01 : Mesh;
        private var _sphere02 : WireframeSphere;
        private var _sphere03 : WireframeSphere;
        private var _sphere04 : Mesh;
        private var _light : DirectionalLight;

        private var _capture : BitmapData = new BitmapData(465, 465, false, 0x000000);

        public function SphereSample() {

           // wonderfl capture
           Wonderfl.disable_capture();
           //addChild(new Bitmap(_capture)) ;

            _view = new View3D();
            addChild(_view);

            _view.antiAlias = 0;
            _view.backgroundColor = 0x222222;

            _light = new DirectionalLight();
            _light.direction = new Vector3D(1, -1, 1);
            _light.specular = 0.1;
            _light.diffuse = 0.9;
            _light.ambient = 0.1;
            _view.scene.addChild(_light);

            var lightPicker:StaticLightPicker = new StaticLightPicker([_light]);

            _sphereMat =  new ColorMaterial(0xff0000, 1);
            _sphereMat.lightPicker = lightPicker;
            _sphereGeo = new SphereGeometry(100, 16, 16);
            _sphere01 = new Mesh(_sphereGeo, _sphereMat);
            _sphere01.y += 250;
            _view.scene.addChild(_sphere01);

            _sphere02 = new WireframeSphere(100, 16, 16, 0x00ff00, 1);
            _sphere02.x += 250;
            _view.scene.addChild(_sphere02);

            _sphere03 = new WireframeSphere(100, 16, 16, 0x0000ff, 1);
            _sphere03.x -= 250;
            _view.scene.addChild(_sphere03);

            _sphereMat =  new ColorMaterial(0xff00ff, 1);
            _sphereMat.lightPicker = lightPicker;
            _sphereGeo = new SphereGeometry(100, 16, 16);
            _sphere04 = new Mesh(_sphereGeo, _sphereMat);
            _sphere04.y -= 250;
            _view.scene.addChild(_sphere04);

            _view.camera.y = 0;
            _view.camera.z = -700;

            addEventListener(Event.ENTER_FRAME, update);
                   
            addChild(new AwayStats());
        }

        private function update(event : Event) : void {

            _view.rotationX = -(stage.mouseY - (stage.stageHeight >> 1));
            _view.rotationY = stage.mouseX - (stage.stageWidth >> 1);

            _sphere01.rotationX = -(stage.mouseY - (stage.stageHeight >> 1));
            _sphere01.rotationY = stage.mouseX - (stage.stageWidth >> 1);

            _sphere02.rotationX = -(stage.mouseY - (stage.stageHeight >> 1));
            _sphere02.rotationY = stage.mouseX - (stage.stageWidth >> 1);

            _sphere03.rotationX = -(stage.mouseY - (stage.stageHeight >> 1));
            _sphere03.rotationY = stage.mouseX - (stage.stageWidth >> 1);

            _sphere04.rotationX = -(stage.mouseY - (stage.stageHeight >> 1));
            _sphere04.rotationY = stage.mouseX - (stage.stageWidth >> 1);

            _view.camera.lookAt(ZERO);
            _view.render();
            //_view.renderer.queueSnapshot(_capture);
        }
    }
}