/**
 * Copyright Tamanegi_kenshi ( http://wonderfl.net/user/Tamanegi_kenshi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rRxi
 */

package {
    import flash.display.Sprite;
    import flash.events.*;
    import flash.net.URLRequest;
    import flash.net.navigateToURL;
    
    
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.events.InteractiveScene3DEvent;
    import org.papervision3d.materials.*;//ColorMaterial;
    import org.papervision3d.materials.BitmapFileMaterial;
    
    public class FlashTest extends Sprite {
        private var plane:Plane;
        private var camera:Camera3D;
        private var scene:Scene3D;
        private var viewport:Viewport3D;
        private var renderer:BasicRenderEngine;
        
        private var url:URLRequest;
        
        public function FlashTest() {
            init();            
        }//FlashTest
        
        private function init():void{
            camera = new Camera3D();
            camera.z = -500;
            
            scene = new Scene3D();
            
            viewport = new Viewport3D(465, 465);
            viewport.interactive = true;
            viewport.buttonMode = true;
            addChild(viewport);
            
            renderer = new BasicRenderEngine();
            
            var material:ColorMaterial = new ColorMaterial(0xccccc);
            material.interactive = true;
            material.doubleSided = true;
            plane = new Plane(material, 100, 100);
            plane.name = "http://www.yahoo.co.jp";
            scene.addChild(plane);
            
            plane.addEventListener(InteractiveScene3DEvent.OBJECT_CLICK, onClick);
            
            url = new URLRequest("http://www.yahoo.co.jp");

            renderer.renderScene(scene, camera, viewport);
            

            
        }//init
    
        

        
        private function onClick(event:InteractiveScene3DEvent):void{
            var p:Plane = Plane(event.target);
            
            var request:URLRequest = new URLRequest(p.name);
            navigateToURL(request, "_blank");
        }


    }//class
}//package