/**
 * Copyright okoi ( http://wonderfl.net/user/okoi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rQh2
 */

//
//	Perlinノイズテスト。ただのテスト
//	@author okoi
//
package 
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.BitmapDataChannel;
	import flash.display.Sprite;
	import flash.events.Event;
	import com.bit101.components.CheckBox;	
	import com.bit101.components.HSlider;
	import com.bit101.components.Label;
	import flash.events.MouseEvent;
	import flash.geom.Point;
	import flash.ui.Mouse;
	
	public class Main extends Sprite 
	{
		private	var _canvas:BitmapData;
		private var _seed:int;
		
		private var _baseX:int = 0;
		private var baseXlabel:Label;
		
		private var _baseY:int = 0;
		private var baseYLabel:Label;
		
		private var _numOctaves:int = 1;
		private var numOctavesLabel:Label;
		
		private var _stitch:Boolean = false;
		private var stitchCheckBox:CheckBox;
		
		private var _fractalNoise:Boolean = false;
		private var fractalNoiseCheckBox:CheckBox;
		
		private var _channelOptions:uint = 0;
		private var channelRED:CheckBox;
		private var channelBLUE:CheckBox;
		private var channelGREEN:CheckBox;
		private var channelALPHA:CheckBox;
		
		private var _grayScale:Boolean = false;
		private var grayScaleCheckBox:CheckBox;
		
		
		private var _offset:Array;
		private var _offsetFlag:Boolean = false;
		private var offsetCheckBox:CheckBox;
		
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			// entry point
			_canvas = new BitmapData( stage.stageWidth, 300, true, 0x0 );
			addChild( new Bitmap( _canvas ) );
			
			_seed = Math.floor(Math.random() * 0xFFFF);
			
			CreateGUI();
			
			
			addEventListener( Event.ENTER_FRAME, Update );
		}

		private function CreateGUI():void
		{
			//	baseX
			var slider:HSlider = new HSlider(this, 10, 310, ChangeSlider1);
			baseXlabel = new Label(this, 10, 320, "baseX : " + slider.value);
			
			//	baseY
			slider = new HSlider(this, 10, 340, ChangeSlider2);
			baseYLabel = new Label(this, 10, 350, "baseY : " + slider.value);
			
			//	numOctaves
			slider = new HSlider(this, 10, 370, ChangeSlider3);
			slider.minimum = 1;
			slider.maximum = 6;
			numOctavesLabel = new Label(this, 10, 380, "numOctaves : " + slider.value);
			
			//	stitch
			stitchCheckBox = new CheckBox(this, 150, 310, "stitch", ClickStitch);
			_stitch = stitchCheckBox.selected;
			
			//	fractalNoise
			fractalNoiseCheckBox = new CheckBox(this, 150, 325, "fractalNoise", ClickFractalNoise);
			_fractalNoise = fractalNoiseCheckBox.selected;
			
			//	channelOptions
			channelRED 		= new CheckBox(this, 150, 340, "RED", ClickRED);
			channelRED.selected = true;
			channelGREEN 	= new CheckBox(this, 200, 340, "GREEN", ClickGREEN);
			channelGREEN.selected = true;
			channelBLUE 	= new CheckBox(this, 250, 340, "BLUE", ClickBLUE);
			channelBLUE.selected = true;
			channelALPHA 	= new CheckBox(this, 300, 340, "ALPHA", ClickALPHA);
			channelALPHA.selected = true;
			_channelOptions	= BitmapDataChannel.RED | BitmapDataChannel.GREEN | BitmapDataChannel.BLUE | BitmapDataChannel.ALPHA;
			
			//	grayScale
			grayScaleCheckBox = new CheckBox(this, 150, 355, "grayscale", ClickGrayScale);
			_grayScale = grayScaleCheckBox.selected;
			
			//	offset	最大６個作っておく
			_offset = [
				new Point(),
				new Point(),
				new Point(),
				new Point(),
				new Point(),
				new Point()
				];
			
			offsetCheckBox = new CheckBox(this, 150, 370, "scroll top Octaves", ClickOffset);
			_offsetFlag = offsetCheckBox.selected = true;
		}
		
		private function Update(e:Event):void 
		{
			if( _offsetFlag )	_offset[0].x += 2;			//	最初のオクターブだけスクロール
			
			_canvas.perlinNoise(
				_baseX,					//	x 方向で使用する周波数(幅)
				_baseY,					//	y 方向で使用する周波数(高さ)
				_numOctaves,			//	重ねる回数　やりすぎると重い
				_seed,					//	適当な整数
				_stitch,				//	補正があり、タイリング可能なノイズ生成を試みる(第09引数でスクロール時に効果的)
				_fractalNoise,			//	フラクタルノイズの有無。falseの場合、炎や海の波のような視覚効果
				_channelOptions,		// (8 | 4 | 2 | 1),	//	ノイズ生成のチャンネル
				_grayScale,				//	グレースケール化
				_offset					//	第03引数で決めた各レイヤーをスクロールするためのPoint型の配列データ
				);
		}
		
		private function ChangeSlider1(e:Event):void 
		{
			_baseX = e.currentTarget.value;
			baseXlabel.text = "baseX : " + _baseX;
		}
		private function ChangeSlider2(e:Event):void 
		{
			_baseY = e.currentTarget.value;
			baseYLabel.text = "baseY : " + _baseY;
		}		
		private function ChangeSlider3(e:Event):void 
		{
			_numOctaves = e.currentTarget.value;
			numOctavesLabel.text = "numOctaves : " + _numOctaves;
		}			
		private function ClickStitch(e:MouseEvent):void
		{
			_stitch = e.currentTarget.selected;
		}
		private function ClickFractalNoise(e:MouseEvent):void
		{
			_fractalNoise = e.currentTarget.selected;
		}
		private function ClickRED(e:MouseEvent):void
		{
			_channelOptions ^= BitmapDataChannel.RED;
		}
		private function ClickGREEN(e:MouseEvent):void
		{
			_channelOptions ^= BitmapDataChannel.GREEN;
		}		
		private function ClickBLUE(e:MouseEvent):void
		{
			_channelOptions ^= BitmapDataChannel.BLUE;
		}		
		private function ClickALPHA(e:MouseEvent):void
		{
			_channelOptions ^= BitmapDataChannel.ALPHA;
		}	
		private function ClickGrayScale(e:MouseEvent):void
		{
			_grayScale = e.currentTarget.selected;
		}
		private function ClickOffset(e:MouseEvent):void
		{
			_offsetFlag = e.currentTarget.selected;
		}
	}
	
}