/**
 * Copyright folbore ( http://wonderfl.net/user/folbore )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rQGW
 */

//歯車創成
package {
    import flash.display.*;
    import flash.geom.*;
    import flash.events.*;
    
    public class Makegear extends Sprite {
        public var lac_s : Sprite = new Sprite();
        public var gear_s : Sprite = new Sprite();
        public var gear_b : Bitmap;
        public var gear_bd : BitmapData;
        public var base : Sprite = new Sprite();
        public var base2 : Sprite = new Sprite();
        public var lacx : Number , lacy : Number;
        
        //ラックの初期設定
        
        //円の初期設定
        public var da : Number = 150; //歯先円直径
        
        public var matrix:Matrix = new Matrix();
        public var i : Number;
        
        public function Makegear() : void {
            stage.frameRate=2;
            
            gear_s = drawgear();
            gear_s.x = stage.stageWidth/2;
            gear_s.y = stage.stageHeight/2;
            stage.addChild(gear_s);
            
            gear_bd = new BitmapData(stage.stageWidth, stage.stageHeight);
            gear_b = new Bitmap(gear_bd);
            stage.addChild(gear_b);
            
            matrix.translate(-stage.stageWidth/2, -stage.stageHeight/2);
            //matrix.rotate(30*Math.PI/180);
            matrix.translate(stage.stageWidth/2, stage.stageHeight/2);
            gear_bd.draw(stage,matrix);
            //gear_bd.draw(stage);
            //stage.removeChild(gear_s);
            
            lac_s = drawlac();
            lac_s.x = stage.stageWidth / 2;
            lac_s.y = 30;
            stage.addChild(lac_s);
            
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }
        
        public function enterFrameHandler(e:Event) : void {
            //lac_s.y++;
            //i++;
            //matrix.rotate(i * Math.PI / 180);
            //gear_bd.draw(stage,matrix);
            //base2.x++;
        }

        //ラックを描く
        public function drawlac() :Sprite {
            var lac_s1 : Sprite = new Sprite();
            var lac_s2 : Sprite = new Sprite();
            var ha : Number; //歯末のたけ
            var hf : Number; //歯元のたけ
            var p : Number; //基準ピッチ
            var a : Number; //圧力角
            var i : int;        
            
            //ラック設定
            ha = 20;
            hf = 20;
            p = 40;
            a = 20; //度
            z = 7; //歯数
            
            

            //描画
            lacx = -p/2*z;
            lacy = 15;
            a=a/180*Math.PI;
            
            lac_s1.graphics.beginFill(0xFF00FF)
            lac_s1.graphics.lineTo(hf*Math.tan(a)+lacx,0);
            for (i=0 ; i<z ; i++) {
                lac_s1.graphics.lineTo(hf*Math.tan(a)+p*i+lacx,lacy);
                lac_s1.graphics.lineTo(p/2-hf*Math.tan(a)+p*i+lacx,lacy);
                lac_s1.graphics.lineTo(p/2+ha*Math.tan(a)+p*i+lacx,ha+hf+lacy);
                lac_s1.graphics.lineTo(p-ha*Math.tan(a)+p*i+lacx,ha+hf+lacy);
            }
            lac_s1.graphics.lineTo(p+ha*Math.tan(a)+p*(i-1)+lacx,lacy);
            lac_s1.graphics.lineTo(p+ha*Math.tan(a)+p*(i-1)+lacx,0);
            lac_s1.graphics.endFill();
            lac_s2.addChild(lac_s1);
            lac_s1.y = -lacy-hf;
            return lac_s2;
        }

        //ギヤを描く
        public function drawgear() :Sprite {
            var gear_s1 : Sprite = new Sprite();
            
            //描画
            gear_s1.graphics.beginFill(0xFF0000);
            gear_s1.graphics.drawCircle(0, 0, da);
            gear_s1.graphics.endFill();
            return gear_s1;
        }
    }
}