/**
 * Copyright ug24k8 ( http://wonderfl.net/user/ug24k8 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rPVj
 */

// forked from yawakisin's Papervision3d入門 3.2.3
/*
	Flash3D コンテンツ制作のためのPapervision3Dのサンプルテスト	
	
	code 3.2.7
*/

package 
{
	import flash.display.*;
	import flash.events.*;
	import flash.net.*;
	import flash.system.*;
	import org.papervision3d.materials.special.CompositeMaterial;
	import org.papervision3d.view.*;
	import org.papervision3d.materials.*;
	import org.papervision3d.objects.primitives.*;
	
	[SWF(width = "800", height = "600", frameRate = "12", backgroundColor = "#101010")]
	public class CompositeSample extends BasicView {
		
		private var loader:Loader;

		// コンストラクタ
		public function CompositeSample() 
		{
			// Loaderクラスを使用して画像ファイルを読み込む(外部のパスを指定)
			loader = new Loader();
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, compHandler);
			loader.load(
				new URLRequest("http://assets.wonderfl.net/images/related_images/2/29/2957/295773efe549b4206f0ab5e4e776915fb02f95ff"),
				new LoaderContext(true));		
		}
		
		private function compHandler(e:Event):void 
		{
			// マテリアルを作成
			var material:CompositeMaterial = new CompositeMaterial();
			// 黄色のカラーマテリアルをコンポジットマテリアルに追加
//			material.addMaterial(new ColorMaterial(0xffff00));
			// 赤色のワイヤーフレームをコンポジットマテリアルに追加
			material.addMaterial(new WireframeMaterial(0xff0000));
                        // ビットマップテクスチャ
			// 画像ファイルを読み込んだ場合、loaderのcontentプロパティがビットマップ画像になっている
			var bmpData:BitmapData = Bitmap(loader.content).bitmapData;
			material.addMaterial(new BitmapMaterial(bmpData));
			
			// 球体(Sphere)を作成
			// 引数はマテリアル、球面の半径、横のポリゴン分割数、縦のポリゴン分割数
			var sphere:Sphere = new Sphere(material, 500, 10, 10);
			
			// 3D空間に球体を追加
			scene.addChild(sphere);
			
			// レンダリング
			startRendering();
		}
	}
}
