/**
 * Copyright mausuit ( http://wonderfl.net/user/mausuit )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rP2G
 */

package
{
    import flash.utils.Timer;
    import flash.system.LoaderContext;
    import flash.display.BitmapData;
    import flash.system.Security;
    import flash.display.DisplayObject;
    import flash.events.IOErrorEvent;
    import flash.text.TextField;
    import flash.events.TimerEvent;
    import flash.display.Bitmap;
    import flash.net.URLRequest;
    import flash.display.Loader;
    import flash.events.Event;
    import flash.display.Sprite;
    
    [SWF(backgroundColor=0x111111)]
    
    public class FlashTest extends Sprite
    {
        
        private var _pathServer:String = "http://www.mausuit.com.ar/test/wonderfl/galery/images/";
        private var _imagesPath:Array  = ["sunrise.png", "snow.png", "beach.png"];
        private var _loadedImages:uint = 0;
        private var _imagesList:Array  = [];
        private var _bmdList:Array     = [];
        private var _currentImageID:uint;
        private var _changeTimer:Timer;
        
        private var _currentImage:AnimatedImage;
        private var _nextImage:AnimatedImage;
        
        private var _testTxt:TextField = new TextField();
        
        public function FlashTest()
        {
            Security.loadPolicyFile("http://www.mausuit.com.ar/test/wonderfl/galery/images/crossdomain.xml");
            
            _changeTimer = new Timer(5000);
            _changeTimer.addEventListener(TimerEvent.TIMER, changeImage);
            
            loadImages();
        }
        
        
        private function loadImages():void
        {
            // trace
            _testTxt.width = 400;
            addChild(_testTxt);
            
            var imageLoader    :Loader;
            var imageRequest   :URLRequest;
            
            
            for(var i:uint; i < _imagesPath.length; i++)
            {
                imageLoader  = new Loader();
                imageRequest = new URLRequest();
                
                // url image
                imageRequest.url = _pathServer + _imagesPath[i];
                
                // IOErrorEvent is coming soon XD
                imageLoader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, onLoadError);
                imageLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, onImageLoaded);
                imageLoader.load(imageRequest, new LoaderContext(true));
            }

        }
        
        
        private function onLoadError(e:IOErrorEvent):void
        {
            //_myRect.y += 10;
        }

        
        
        private function onImageLoaded(e:Event):void
        {
            var bytesLoader:Loader = new Loader();
            var loader:Loader      = e.target.loader;
            
            //_imagesList.push(loader);
            
            _bmdList.push([
                bytesLoader, 
                loader, 
                new BitmapData(loader.width, loader.height, true, 0x00ffffff)
            ]);
            
            bytesLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, onBytesLoaded);
            bytesLoader.loadBytes(loader.contentLoaderInfo.bytes);
            
        }
        
        
        private function onBytesLoaded(e:Event):void
        {
            // No futuro trabalhar com object em vez de Array
            var currentBmd:BitmapData  = getBmdArray(e.target.loader)[2];
                currentBmd.draw(e.target.loader);
            
            var img:Bitmap = new Bitmap(currentBmd);
            
            var newImage:AnimatedImage = new AnimatedImage(img);
            
            _imagesList.push(newImage);
            _loadedImages++;
            
            if(checkLoading())
            {
                initApp();
            }
        }
        
        
        private function getBmdArray(loader:Loader):Array
        {
            var searchResult:Array;
            
            for(var i:uint; i < _bmdList.length; i++)
            {
                if(_bmdList[i][0] == loader)
                {
                    searchResult = _bmdList[i];
                }
            }
            
            return searchResult;
        }


        
        
        private function checkLoading():Boolean
        {
            if(_loadedImages != _imagesPath.length)
            {
                return false;
            }
            else
            {
                return true;
            }
        }
        
        
        private function initApp():void
        {
            // adiciona a primeira imagem no palco e executa o método animationIN dela
            
            _changeTimer.start();
            
            for(var i:uint; i < _imagesList.length; i++)
            {
                _imagesList[i].y = 80;
                addChild(_imagesList[i]);
            }
            
            _currentImage = _imagesList[_currentImageID];
            _currentImage.animationIN();
        }
        
        
        private function changeImage(e:TimerEvent):void
        {
            // cada x segundos executa o animationOUT da imagem atual, adiciona a nova imagem executando o animationIN dela
            if(_currentImageID == _imagesPath.length - 1)
            {
                _currentImageID = 0;
            }
            else
            {
                _currentImageID++;
            }
            
            _currentImage.animationOUT();
            setChildIndex(_currentImage, numChildren - 1)
            
            _currentImage = _imagesList[_currentImageID];
            _currentImage.animationIN();
        }





    }
}


import flash.text.TextField;
import flash.display.BitmapData;
import flash.display.Sprite;
import flash.events.Event;
import flash.display.Bitmap;
import flash.geom.Matrix;
import com.greensock.TweenLite;
import com.greensock.easing.Quint;

internal class AnimatedImage extends Sprite
{
    
    private var _rows:uint     = 5;
    private var _columns:uint  = 5;
    private var _originalBitmap   :Bitmap;
    public var _piecesCollection  :Array = [];
    
    private var _pieceW   :uint;
    private var _pieceH   :uint;
    
    private var _testTxt:TextField = new TextField();
    
    
    public function AnimatedImage(originalBitmap:Bitmap)
    {
        _originalBitmap = originalBitmap;
        
        _pieceW = Math.ceil(_originalBitmap.width / _columns);
        _pieceH = Math.ceil(_originalBitmap.height / _rows);
        
        addEventListener(Event.ADDED_TO_STAGE, setup);
    }
    
    
    private function setup(e:Event):void
    {
        var pieceBmd :BitmapData;
        var piece    :Bitmap;
        var matrix   :Matrix;
        
        for(var i:uint = 0; i < _rows; i++)
        {
            _piecesCollection[i] = [];
            
            
            for(var j:uint = 0; j < _columns; j++)
            {
                matrix = new Matrix();
                matrix.translate(-_pieceW * j, -_pieceH * i);
                
                pieceBmd = new BitmapData(_pieceW, _pieceH, true, 0x00ffffff);
                pieceBmd.draw(_originalBitmap, matrix);
                
                piece = new Bitmap(pieceBmd);
                
                _piecesCollection[i].push(piece);
                
            }
        }

    }

    
    
    public function animationIN():void
    {
        var currentPiece:Bitmap;
        var counter:uint;
        
        for(var i:uint = 0; i < _rows; i++)
        {
            for(var j:uint = 0; j < _columns; j++)
            {
                currentPiece = _piecesCollection[i][j];
                
                // animation IN code
                //currentPiece.x = 0;
                currentPiece.y = _pieceH * i;
                currentPiece.scaleY = 0;
                addChild(currentPiece);
                
                TweenLite.to(currentPiece, 0.5, {ease:Quint.easeOut, scaleY:1, scaleX:1, delay:counter * 0.1, x:_pieceW * j, y:_pieceH * i});
                
                counter++;
            }

        }

    }
    
    
    public function animationOUT():void
    {
        var currentPiece:Bitmap;
        var counter:uint;
        
        for(var i:uint = 0; i < _rows; i++)
        {
            for(var j:uint = 0; j < _columns; j++)
            {
                currentPiece = _piecesCollection[i][j];
                TweenLite.to(currentPiece, 1, {ease:Quint.easeOut, scaleY:0, delay:counter * 0.2, y:_pieceH * i});
                
                counter++;
            }

        }

    }



}
