/**
 * Copyright alambertsimon ( http://wonderfl.net/user/alambertsimon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rOiZ
 */

// forked from greentec's Away3D Camera clipping example
package 
{
    import away3d.cameras.Camera3D;
    import away3d.containers.Scene3D;
    import away3d.containers.View3D;
    import away3d.controllers.HoverController;
    import away3d.debug.AwayStats;
    import away3d.entities.Mesh;
    import away3d.lights.DirectionalLight;
    import away3d.materials.ColorMaterial;
    import away3d.materials.lightpickers.StaticLightPicker;
    import away3d.primitives.CubeGeometry;
    import com.bit101.components.Label;
    import com.bit101.components.Style;
    import flash.display.*;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    /**
     * ...
     * @author ypc
     */
    [SWF(width = 465, height = 465)]
    public class Main extends Sprite 
    {
        //engine variables
        private var view:View3D;
        private var scene:Scene3D;
        private var camera:Camera3D;
        private var cameraController:HoverController;
        private var awayStats:AwayStats;
        
        //light
        private var light:DirectionalLight;
        private var lightPicker:StaticLightPicker;
        
        //navigation variables
        private var move:Boolean = false;
        private var lastPanAngle:Number;
        private var lastTiltAngle:Number;
        private var lastMouseX:Number;
        private var lastMouseY:Number;
        
        private var lensFarLabel:Label;
        
        //private var source:BitmapData = new BitmapData(465, 465, false, 0x000000);
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            
            Wonderfl.disable_capture();
            
            //addChild(new Bitmap(source));            
            
            initEngine();
            initLight();
            initObject();
            initListener();
            
            Style.LABEL_TEXT = 0xffffff;
            lensFarLabel = new Label(this, 465 - 100, 10, "far : " + String(camera.lens.far));
            lensFarLabel.scaleX = lensFarLabel.scaleY = 1.8;
            
        }
        
        private function initEngine():void
        {
            view = new View3D();
            view.antiAlias = 4;
            
            scene = view.scene;
            camera = view.camera;
            //trace(camera.lens.far);

           
            cameraController = new HoverController(camera);
            cameraController.distance = 1000;
            cameraController.minTiltAngle = 10;
            cameraController.maxTiltAngle = 90;
            cameraController.panAngle = 45;
           cameraController.tiltAngle = 20;
            
            awayStats = new AwayStats(view);
            
        }
        
        private function initLight():void
        {
            light = new DirectionalLight( -0.5, -1, -1);
            light.color = 0xffffff;
            light.ambient = 1;
            scene.addChild(light);
            
            lightPicker = new StaticLightPicker([light]);
        }
        
        private function initObject():void
        {
            var mesh:Mesh;
            var cubeGeometry:CubeGeometry = new CubeGeometry(50, 50, 50, 1, 1, 1, false);
            var colorMaterial:ColorMaterial;
            
            var i:int, j:int;
            var red:int, green:int, blue:int;
            
            for (i = 0; i < 50; i += 1)
            {
                for (j = 0; j < 50; j += 1)
                {
                    red = i / 50 * 255;
                    green = j / 50 * 255;
                    blue = Math.abs(i - j) / 50 * 255;
                    colorMaterial = new ColorMaterial(red << 16 | green << 8 | blue);
                    colorMaterial.lightPicker = lightPicker;
                    
                    mesh = new Mesh(cubeGeometry, colorMaterial);
                    mesh.x = (i - 25) * 100;
                    mesh.z = (j - 25) * 100;
                    
                    scene.addChild(mesh);
                }
            }
            
        }
        
        private function initListener():void
        {
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
            stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
            stage.addEventListener(Event.RESIZE, resizeHandler);
            addEventListener(Event.ENTER_FRAME, render);
            
            addChild(view);
            addChild(awayStats);
        }
        
        private function render(e:Event):void
        {
            if (move)
            {
                cameraController.panAngle = 0.3 * (stage.mouseX - lastMouseX) + lastPanAngle;
                cameraController.tiltAngle = 0.3 * (stage.mouseY - lastMouseY) + lastTiltAngle;
            }
            
            view.render();
            //view.renderer.queueSnapshot(source);
        }
        
        private function onMouseDown(e:MouseEvent):void
        {
            lastPanAngle = cameraController.panAngle;
            lastTiltAngle = cameraController.tiltAngle;
            lastMouseX = stage.mouseX;
            lastMouseY = stage.mouseY;
            move = true;

           
            camera.lens.far %= 5000;
           camera.lens.far += 1000;
            
            
            lensFarLabel.text = "far : " + String(camera.lens.far);

           
        }
        
        private function onMouseUp(e:MouseEvent):void
        {
            move = false;
        }
        
        private function resizeHandler(e:Event):void
        {
            view.width = stage.stageWidth;
            view.height = stage.stageHeight;
            
        }
    }
    
}