/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rNHU
 */

// forked from actionscriptbible's Chapter 37 Example 1
package {
  import flash.display.GradientType;
  import flash.display.Sprite;
  import flash.events.Event;
  import flash.filters.BlurFilter;
  import flash.geom.Matrix;

  public class ch37ex1 extends Sprite {
    protected const NUM_COPIES:int = 28;
    public function ch37ex1() {
      var W:Number = stage.stageWidth;
      var H:Number = stage.stageHeight;
      //オブジェクト作成
      for (var i:int = 0; i < NUM_COPIES; i++) {
        var s:Sprite = new Sprite();
        var m:Matrix = new Matrix();
        m.createGradientBox(40, 40, 0, -20, -20);
        //スプライト設定
        s.graphics.beginGradientFill(GradientType.RADIAL, [0x00ff00, 0xaaffaa],
          [1, 1], [0, 255], m, null, null, 0.6);
        s.graphics.drawCircle(0, 0, 20);
        s.graphics.endFill();
        
        s.x = (Math.random()-0.5)*200 + 0.5*W;// x
        s.y = (Math.random()-0.5)*200 + 0.5*H;// y
        s.z = -(i-NUM_COPIES/2) * W/NUM_COPIES;// z
        
        s.filters = [new BlurFilter(0, 0, 2)];//ブラーフィルター
        addChild(s);
      }
      addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }
    //毎フレーム処理
    protected function onEnterFrame(event:Event):void {
      var focusZ:Number = stage.mouseX - stage.stageWidth/2;
      for (var i:int = 0; i < numChildren; i++) {
        var s:Sprite = Sprite(getChildAt(i));
        
        var blurFilter:BlurFilter = BlurFilter(s.filters[0]);//ブラーフィルター
        var blurAmount:Number = 0.05 * Math.abs(focusZ - s.z);//ブラー量
        blurFilter.blurX = blurAmount;
        blurFilter.blurY = blurAmount;
        s.filters = [blurFilter];
      }
    }
  }
}