/**
 * Copyright _ueueueueue ( http://wonderfl.net/user/_ueueueueue )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rN70
 */

package 
{
	import flash.display.*;
	import flash.events.*;
	import flash.filters.DisplacementMapFilter;
	import flash.filters.DisplacementMapFilterMode;
	import flash.geom.*;
	import flash.text.*;
	import flash.ui.*;
	
	[SWF(width=465,height=465,backgroundColor=0x0)]
	
	/**
	 * ...
	 * @author ue
	 */
	
	public class Main extends Sprite 
	{
		private const NUM:int = 400;
		private var balls:Vector.<Ball> = new Vector.<Ball>(NUM,true);
		private var canvas:BitmapData;
		private var map:BitmapData;
		private var disp:DisplacementMapFilter;
		private var cnt:int = 0;
		private var comp:int = 5;
		
		public function Main():void 
		{
			for (var i:int = 0; i < NUM; i++)
			{
				var b:Ball = new Ball(Math.random() * 465, Math.random() * 465);
				b.vx = Math.random() * 2 - 1;
				b.vy = Math.random() * 2 - 1;
				balls[i] = b;
			}
			map = new BitmapData(465, 465);
			map.perlinNoise(comp, comp, 1, 1, true, true);
			
			disp = new DisplacementMapFilter(
				map, new Point(), 
				BitmapDataChannel.GREEN, 
				BitmapDataChannel.BLUE,
				40, 40,
				DisplacementMapFilterMode.WRAP
			);
			
			canvas = new BitmapData(465, 465, true, 0xFF000000);
			addChild(new Bitmap(canvas));
			
			addEventListener(Event.ENTER_FRAME, update);
		}
		
		private function update(e:Event):void 
		{
			cnt++
			if (cnt % 30 == 0)
			{
				comp += 3;
				if(comp > 32) comp = 5;
				var seed:Number = Math.random() * 20 >> 0 + 1;
				map.perlinNoise(comp, comp, 1, seed, true, true, 7, false, [new Point(), new Point()]);
			}
			for (var i:int = 0; i < balls.length; i++)
			{
				var b:Ball = balls[i] as Ball;
				b.x += b.vx;
				b.y += b.vy;
				b.wrap(stage);
				var mat:Matrix = new Matrix();
				mat.translate(b.x, b.y);
				canvas.draw(b,mat);
			}
			canvas.applyFilter(canvas, canvas.rect, new Point(), disp);
		}
	}
}

import flash.display.Sprite;
import flash.display.Stage;

class Ball extends Sprite
{
	public var vx:Number = 0;
	public var vy:Number = 0;
	public function Ball(x:Number,y:Number)
	{
		this.x = x;
		this.y = y;
		graphics.beginFill(0xFFFFFF);
		graphics.drawCircle(0, 0, 1);
	}
	
	public function wrap(s:Stage):void
	{
		if (this.x < 0)
		{
			this.x = 0;
			vx *= -1;
		}
		else if (this.x > s.stageWidth) 
		{
			this.x = s.stageWidth;
			vx *= -1;
		}
		if (this.y < 0) 
		{
			this.y = 0;
			vy *= -1;
		}
		else if (this.y > s.stageHeight)
		{
			this.y = s.stageHeight;
			vy *= -1;
		}
	}
}