/**
 * Copyright 883108 ( http://wonderfl.net/user/883108 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rMj0
 */

package {
	import flash.display.*;
	import flash.events.*;
	import flash.ui.Keyboard;
	import flash.text.*;

	public class AccelerationDocument2 extends Sprite {
		private var _ship:Ship;
		private var _vr:Number = 0;
		private var _thrust:Number = 0;
		private var _vx:Number = 0;
		private var _vy:Number = 0;

		private var _keyText:TextField;
		private var _velText:TextField;
		public function AccelerationDocument2() {
			init();
		}

		private function init():void {
			var tex:TextField = new TextField  ;
			addChild(tex);
			tex.width = 450;
			tex.x = tex.y = 10;
			tex.multiline = true;
			tex.textColor = 0xffffff;
			tex.text = '矢印キーにあわせてスプライトが移動します。\n';
			
			addChild(_keyText = new TextField);
			_keyText.y = 30;
			_keyText.width = 100;
			_keyText.height = 16;
			_keyText.border = true;
			_keyText.textColor = 0xffffff;
			_keyText.borderColor = 0x333333;

			addChild(_velText = new TextField);
			_velText.width = 200;
			_velText.height = 16;
			_velText.x = stage.stageWidth - (_velText.width + 10)
			_velText.y = 30;
			_velText.textColor = 0xffffff;
			_velText.borderColor = 0x333333;

			// 背景を黒で塗りつぶします。
			graphics.beginFill(0x000000);
			graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
			graphics.endFill();
			// ステージ上にスプライトを配置します。
			addChild(_ship = new Ship);
			_ship.x = stage.stageWidth / 2;
			_ship.y = stage.stageHeight / 2;
			// イベントハンドルを設定します。
			addEventListener(Event.ENTER_FRAME, enterFrameHandler);
			stage.addEventListener(KeyboardEvent.KEY_DOWN, keyDownHandler);
			stage.addEventListener(KeyboardEvent.KEY_UP, keyUpHandler);
		}
		private function enterFrameHandler($event:Event):void {
			_ship.rotation += _vr;
			var angle:Number = _ship.rotation * Math.PI / 180;
			var ax:Number = Math.cos(angle) * _thrust;
			var ay:Number = Math.sin(angle) * _thrust;
			_vx += ax;
			_vy += ay;
			_ship.x += _vx;
			_ship.y += _vy;
			// ステージ内にスプライトを保つ処理を入れます。
			if(_ship.x < 0){
				_ship.x = stage.stageWidth;
			}else if(_ship.x > stage.stageWidth){
				_ship.x = 0;
			}
			if(_ship.y < 0){
				_ship.y = stage.stageHeight;
			}else if(_ship.y > stage.stageHeight){
				_ship.y = 0;
			}
			_velText.text = 'velocity: x = ' + (_vx * 100 | 0)/100 + ', y = ' + (_vy * 100 | 0)/100 + ' px / frame'; 
		}

		private function keyDownHandler($event:KeyboardEvent):void {
			
			switch ($event.keyCode) {
				case Keyboard.LEFT :
					_keyText.text = 'LEFT';
					_vr = -5;
					break;
				case Keyboard.RIGHT :
					_keyText.text = 'RIGHT';
					_vr = 5
					break;
				case Keyboard.UP :
					_keyText.text = 'UP';
					_ship.boost();
					_thrust = 0.2;
					break;
				default :
					break;
			}
		}
		private function keyUpHandler($event:KeyboardEvent):void {
			_vr = 0;
			_thrust = 0;
			_keyText.text = ' - ';
			_ship.stop_boost();
		}
	}
}

import flash.display.Sprite;
import flash.events.Event;
class Ship extends Sprite {
	private var _flame:Sprite;
	private var _body:Sprite;
	public function Ship() {
		init();
	}

	private function init():void {
		addChild(_flame = new Sprite);
		_flame.x=-2;
		_flame.graphics.beginFill(0xd90028, .9);
		_flame.graphics.moveTo(5,0);
		_flame.graphics.lineTo(2, 5);
		_flame.graphics.lineTo(-2, 0);
		_flame.graphics.lineTo(2, -5);
		_flame.graphics.endFill();
		_flame.visible=false;

		addChild(_body = new Sprite);
		_body.graphics.beginFill(0xd90028, .4);
		_body.graphics.lineStyle(0, 0xffffff);
		_body.graphics.moveTo(20, 0);
		_body.graphics.lineTo(0, 10);
		_body.graphics.lineTo(5, 0);
		_body.graphics.lineTo(0, -10);
		_body.graphics.lineTo(20, 0);
		_body.graphics.endFill();
	}

	public function boost():void {
		addEventListener(Event.ENTER_FRAME, enterFrameHandler);
	}

	public function stop_boost():void {
		removeEventListener(Event.ENTER_FRAME, enterFrameHandler);
		_flame.visible=false;
	}

	private function enterFrameHandler($event:Event):void {
		_flame.visible=! _flame.visible;
	}
}