/**
 * Copyright ultraTakePon ( http://wonderfl.net/user/ultraTakePon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rMba
 */

// forked from rsakane's 各種フィルター, ノイズ確認用
/*
 * 上部のボタン - フィルター, ノイズ確認画面の切り替え
 * Copy to Clipboardボタン - ソースコードをクリップボードにコピー
 */
package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import com.bit101.components.*;
	
	public class Main extends Sprite
	{
		private var window:Window;
		private var data:Array;
		
		public function Main()
		{
			window = new Window(this, 0, 0, "");
			window.width = window.height = 465;
			window.draggable = false;
			
			var drop:DropShadow = new DropShadow();
			var blur:Blur = new Blur();
			var glow:Glow = new Glow();
			var bevel:Bevel = new Bevel();
			var perlin:Perlin = new Perlin();
			
			window.content.addChild(perlin);
			window.content.addChild(bevel);
			window.content.addChild(glow);
			window.content.addChild(blur);
			window.content.addChild(drop);
			
			data = [drop, glow, bevel, blur, perlin];
			
			var d:RadioButton = new RadioButton(window, 5, 6, "DropShadow", true, toggle);
			var g:RadioButton = new RadioButton(window, 105, 6, "Glow", false, toggle);
			var be:RadioButton = new RadioButton(window,205, 6, "Bevel", false, toggle);
			var b:RadioButton = new RadioButton(window, 305, 6, "Blur", false, toggle);
			var p:RadioButton = new RadioButton(window, 405, 6, "Perlin", false, toggle);
			d.name = "0", b.name = "3", be.name = "2", g.name = "1", p.name = "4";
			
			d.groupName = b.groupName = be.groupName = g.groupName = p.groupName = "parent";
		}
		
		private function toggle(event:Event):void
		{
			for (var i:int = 0; i < data.length; i++) data[i].visible = false;
			data[int(event.currentTarget.name)].visible = true;
		}
	}
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Sprite;
import flash.events.Event;
import flash.filters.*;
import com.bit101.components.*;
import flash.geom.Point;
import flash.system.System;

class DropShadow extends Sprite
{
	private var window:Panel;
	private var distance:HUISlider;
	private var angle:HUISlider;
	private var cc:ColorChooser;
	private var stepper:NumericStepper;
	private var stepper2:NumericStepper;
	private var scc:ColorChooser;
	private var blurX:HUISlider;
	private var blurY:HUISlider;
	private var strength:HUISlider;
	private var inner:CheckBox;
	private var knockout:CheckBox;
	private var hide:CheckBox;
	private var quality:Window;
	private var low:RadioButton;
	private var medium:RadioButton;
	private var high:RadioButton;
	private var rect:Sprite;
		
	public function DropShadow()
	{
		window = new Panel(this, 0, 0);
		window.width = window.height = 465;
		distance = new HUISlider(window.content, 5, 280, "distance", onChange);
		angle = new HUISlider(window.content, 5, 300, "angle", onChange);
		
		new Label(window.content, 5, 340, "Color");
		cc = new ColorChooser(window.content, 5, 360, 0x0, function(event:Event):void { rect.graphics.clear(), rect.graphics.beginFill(cc.value, stepper.value); rect.graphics.drawRect(0, 0, 100, 100); rect.graphics.endFill() });
		var alpha1:Label = new Label(window.content, 100, 340, "alpha");
		stepper = new NumericStepper(this, 100, 360, function(event:Event):void { rect.graphics.clear(), rect.graphics.beginFill(cc.value, stepper.value); rect.graphics.drawRect(0, 0, 100, 100); rect.graphics.endFill() });
		
		new Label(window.content, 5, 400, "Color of the shadow");
		scc = new ColorChooser(window.content, 5, 420, 0x0, onChange);
		var alpha2:Label = new Label(window.content, 100, 400, "alpha");
		stepper2 = new NumericStepper(this, 100, 420, onChange);
		
		blurX = new HUISlider(window.content, 280, 280, "blurX", onChange);
		blurY = new HUISlider(window.content, 280, 300, "blurY", onChange);
		strength = new HUISlider(window.content, 280, 320, "strength", onChange);
		
		inner = new CheckBox(window.content, 280, 360, "inner", onChange);
		knockout = new CheckBox(window.content, 280, 380, "knockout", onChange);
		hide = new CheckBox(window.content, 280, 400, "hideObject", onChange);
		
		quality = new Window(window.content, 360, 340, "quality");
		low = new RadioButton(quality.content, 5, 5, "LOW", true, onChange);
		medium = new RadioButton(quality.content, 5, 25, "MEDIUM", false, onChange);
		high = new RadioButton(quality.content, 5, 45, "HIGH", false, onChange);
		low.groupName = medium.groupName = high.groupName = "dropshadow";
		
		rect = new Sprite();
		rect.graphics.beginFill(0xED1A3D);
		rect.graphics.drawRect(0, 0, 100, 100);
		rect.graphics.endFill();
		rect.x = (465 - rect.width) / 2;
		rect.y = 80;
		window.content.addChild(rect);
		
		distance.value = 4;
		angle.value = 45;
		angle.maximum = 360;
		blurX.value = blurY.value = 4;
		strength.minimum = strength.value = 1;
		strength.maximum = 30;
		cc.value = 0xED1A3D;
		cc.usePopup = scc.usePopup = true;
		cc.popupAlign = scc.popupAlign = ColorChooser.TOP;
		stepper.step = stepper2.step = 0.1;
		stepper.value = stepper2.value = stepper.max = stepper2.max = 1.0;
		stepper.min = stepper2.min = 0;
		
		onChange();
		
		new PushButton(window, 365, 0, "Copy to Clipboard", copy);
	}
	
	private function copy(event:Event):void
	{
		var q:int = (low.selected) ? 1 : (medium.selected) ? 2 : 3;
		var str:String = "new DropShadowFilter(" + distance.value + "," + angle.value + ",0x" + scc.value.toString(16).toUpperCase() + "," +
						 stepper2.value.toFixed(1) + "," + blurX.value + "," + blurY.value + "," + strength.value + "," + 
						 q + "," + inner.selected + "," + knockout.selected + "," + hide.selected + ")";
		System.setClipboard(str);
	}
	
	private function onChange(event:Event = null):void
	{
		var q:int = (low.selected) ? 1 : (medium.selected) ? 2 : 3;
		rect.filters = [new DropShadowFilter(distance.value, angle.value, scc.value, stepper2.value, blurX.value, blurY.value, strength.value, q, inner.selected, knockout.selected, hide.selected)];
	}
}

class Glow extends Sprite
{
	private var window:Panel;
	private var cc:ColorChooser;
	private var stepper:NumericStepper;
	private var stepper2:NumericStepper;
	private var scc:ColorChooser;
	private var blurX:HUISlider;
	private var blurY:HUISlider;
	private var strength:HUISlider;
	private var inner:CheckBox;
	private var knockout:CheckBox;
	private var quality:Window;
	private var low:RadioButton;
	private var medium:RadioButton;
	private var high:RadioButton;
	private var rect:Sprite;
		
	public function Glow()
	{
		window = new Panel(this, 0, 0);
		window.width = window.height = 465;
		
		new Label(window.content, 5, 280, "Color");
		cc = new ColorChooser(window.content, 5, 300, 0x0, function(event:Event):void { rect.graphics.clear(), rect.graphics.beginFill(cc.value, stepper.value); rect.graphics.drawRect(0, 0, 100, 100); rect.graphics.endFill() });
		var alpha1:Label = new Label(window.content, 100, 280, "alpha");
		stepper = new NumericStepper(this, 100, 300, function(event:Event):void { rect.graphics.clear(), rect.graphics.beginFill(cc.value, stepper.value); rect.graphics.drawRect(0, 0, 100, 100); rect.graphics.endFill() });
		
		new Label(window.content, 5, 340, "Color of the shadow");
		scc = new ColorChooser(window.content, 5, 360, 0x0, onChange);
		var alpha2:Label = new Label(window.content, 100, 340, "alpha");
		stepper2 = new NumericStepper(this, 100, 360, onChange);
		
		blurX = new HUISlider(window.content, 280, 280, "blurX", onChange);
		blurY = new HUISlider(window.content, 280, 300, "blurY", onChange);
		strength = new HUISlider(window.content, 280, 320, "strength", onChange);
		
		inner = new CheckBox(window.content, 280, 360, "inner", onChange);
		knockout = new CheckBox(window.content, 280, 380, "knockout", onChange);
		
		quality = new Window(window.content, 360, 340, "quality");
		low = new RadioButton(quality.content, 5, 5, "LOW", true, onChange);
		medium = new RadioButton(quality.content, 5, 25, "MEDIUM", false, onChange);
		high = new RadioButton(quality.content, 5, 45, "HIGH", false, onChange);
		low.groupName = medium.groupName = high.groupName = "glow";
		
		rect = new Sprite();
		rect.graphics.beginFill(0x0);
		rect.graphics.drawRect(0, 0, 100, 100);
		rect.graphics.endFill();
		rect.x = (465 - rect.width) / 2;
		rect.y = 80;
		window.content.addChild(rect);
		
		blurX.value = blurY.value = 4;
		strength.minimum = strength.value = 1;
		strength.maximum = 30;
		cc.value = 0x0;
		scc.value = 0x009AD6;
		cc.usePopup = scc.usePopup = true;
		cc.popupAlign = scc.popupAlign = ColorChooser.TOP;
		stepper.step = stepper2.step = 0.1;
		stepper.value = stepper2.value = stepper.max = stepper2.max = 1.0;
		stepper.min = stepper2.min = 0;
		
		onChange();
		
		new PushButton(window, 365, 0, "Copy to Clipboard", copy);
	}
	
	private function copy(event:Event):void
	{
		var q:int = (low.selected) ? 1 : (medium.selected) ? 2 : 3;
		var str:String = "new GlowFilter(0x" + scc.value.toString(16).toUpperCase() + "," +
						 stepper2.value.toFixed(1) + "," + blurX.value + "," + blurY.value + "," + strength.value + "," + 
						 q + "," + inner.selected + "," + knockout.selected + ")";
		System.setClipboard(str);
	}
	
	private function onChange(event:Event = null):void
	{
		var q:int = (low.selected) ? 1 : (medium.selected) ? 2 : 3;
		rect.filters = [new GlowFilter(scc.value, stepper2.value, blurX.value, blurY.value, strength.value, q, inner.selected, knockout.selected)];
	}
}

class Bevel extends Sprite
{
	private var window:Panel;
	private var cc:ColorChooser;
	private var distance:HUISlider;
	private var angle:HUISlider;
	private var stepper:NumericStepper;
	private var stepper2:NumericStepper;
	private var stepper3:NumericStepper;
	private var scc:ColorChooser;
	private var hcc:ColorChooser;
	private var blurX:HUISlider;
	private var blurY:HUISlider;
	private var strength:HUISlider;
	private var knockout:CheckBox;
	private var quality:Window;
	private var type:Window;
	private var inner:RadioButton;
	private var outer:RadioButton;
	private var full:RadioButton;
	private var low:RadioButton;
	private var medium:RadioButton;
	private var high:RadioButton;
	private var rect:Sprite;
		
	public function Bevel()
	{
		window = new Panel(this, 0, 0);
		window.width = window.height = 465;
		
		
		new Label(window.content, 5, 280, "Color");
		cc = new ColorChooser(window.content, 5, 300, 0x0, function(event:Event):void { rect.graphics.clear(), rect.graphics.beginFill(cc.value, stepper.value); rect.graphics.drawRect(0, 0, 100, 100); rect.graphics.endFill() });
		new Label(window.content, 100, 280, "alpha");
		stepper = new NumericStepper(this, 100, 300, function(event:Event):void { rect.graphics.clear(), rect.graphics.beginFill(cc.value, stepper.value); rect.graphics.drawRect(0, 0, 100, 100); rect.graphics.endFill() });
		
		new Label(window.content, 5, 340, "Color of the shadow");
		scc = new ColorChooser(window.content, 5, 360, 0x0, onChange);
		new Label(window.content, 100, 340, "alpha");
		stepper2 = new NumericStepper(this, 100, 360, onChange);
		
		new Label(window.content, 5, 400, "Color of the highlight");
		hcc = new ColorChooser(window.content, 5, 420, 0x0, onChange);
		new Label(window.content, 100, 400, "alpha");
		stepper3 = new NumericStepper(this, 100, 420, onChange);
		
		distance = new HUISlider(window.content, 280, 220, "distance", onChange);
		angle = new HUISlider(window.content, 280, 240, "angle", onChange);
		blurX = new HUISlider(window.content, 280, 260, "blurX", onChange);
		blurY = new HUISlider(window.content, 280, 280, "blurY", onChange);
		strength = new HUISlider(window.content, 280, 300, "strength", onChange);
		knockout = new CheckBox(window.content, 280, 320, "knockout", onChange);
		
		type = new Window(window.content, 240, 340, "type");
		inner = new RadioButton(type.content, 5, 5, "INNER", true, onChange);
		outer = new RadioButton(type.content, 5, 25, "OUTER", false, onChange);
		full = new RadioButton(type.content, 5, 45, "FULL", false, onChange);
		inner.groupName = outer.groupName = full.groupName = "bevel_type";
		
		quality = new Window(window.content, 360, 340, "quality");
		low = new RadioButton(quality.content, 5, 5, "LOW", true, onChange);
		medium = new RadioButton(quality.content, 5, 25, "MEDIUM", false, onChange);
		high = new RadioButton(quality.content, 5, 45, "HIGH", false, onChange);
		low.groupName = medium.groupName = high.groupName = "bevel_quality";
		
		rect = new Sprite();
		rect.graphics.beginFill(0xED1A3D);
		rect.graphics.drawRect(0, 0, 100, 100);
		rect.graphics.endFill();
		rect.x = (465 - rect.width) / 2;
		rect.y = 80;
		window.content.addChild(rect);
		
		distance.value = 4;
		angle.value = 45;
		angle.maximum = 360;
		blurX.value = blurY.value = 4;
		strength.minimum = strength.value = 1;
		strength.maximum = 30;
		cc.value = 0xED1A3D;
		scc.value = 0x0;
		hcc.value = 0xFFFFFF;
		cc.usePopup = scc.usePopup = hcc.usePopup = true;
		cc.popupAlign = scc.popupAlign = hcc.popupAlign = ColorChooser.TOP;
		stepper.step = stepper2.step = stepper3.step = 0.1;
		stepper.value = stepper2.value = stepper3.value = stepper.max = stepper2.max = stepper3.max = 1.0;
		stepper.min = stepper2.min = stepper3.min = 0;
		
		onChange();
		
		new PushButton(window, 365, 0, "Copy to Clipboard", copy);
	}
	
	private function copy(event:Event):void
	{
		var q:int = (low.selected) ? 1 : (medium.selected) ? 2 : 3;
		var t:String = (inner.selected) ? "inner" : (outer.selected) ? "outer" : "full";
		var str:String = "new BevelFilter(" + distance.value + "," + angle.value + ",0x" + hcc.value.toString(16).toUpperCase() + "," + 
						 stepper3.value.toFixed(1) + ",0x" + scc.value.toString(16).toUpperCase() + "," + stepper2.value.toFixed(1) + "," + blurX.value + "," + 
						 blurY.value + "," + strength.value + "," + q + ",\"" + t + "\"," + knockout.selected + ")";
		System.setClipboard(str);
	}
	
	private function onChange(event:Event = null):void
	{
		var q:int = (low.selected) ? 1 : (medium.selected) ? 2 : 3;
		var t:String = (inner.selected) ? "inner" : (outer.selected) ? "outer" : "full";
		rect.filters = [new BevelFilter(distance.value, angle.value, hcc.value, stepper3.value, scc.value, stepper2.value, blurX.value, blurY.value, strength.value, q, t, knockout.selected)];
	}
}

class Blur extends Sprite
{
	private var window:Panel;
	private var cc:ColorChooser;
	private var stepper:NumericStepper;
	private var blurX:HUISlider;
	private var blurY:HUISlider;
	private var quality:Window;
	private var low:RadioButton;
	private var medium:RadioButton;
	private var high:RadioButton;
	private var rect:Sprite;
		
	public function Blur()
	{
		window = new Panel(this, 0, 0);
		window.width = window.height = 465;
		
		new Label(window.content, 5, 280, "Color");
		cc = new ColorChooser(window.content, 5, 300, 0x0, function(event:Event):void { rect.graphics.clear(), rect.graphics.beginFill(cc.value, stepper.value); rect.graphics.drawRect(0, 0, 100, 100); rect.graphics.endFill() });
		var alpha1:Label = new Label(window.content, 100, 280, "alpha");
		stepper = new NumericStepper(this, 100, 300, function(event:Event):void { rect.graphics.clear(), rect.graphics.beginFill(cc.value, stepper.value); rect.graphics.drawRect(0, 0, 100, 100); rect.graphics.endFill() });
		
		blurX = new HUISlider(window.content, 280, 280, "blurX", onChange);
		blurY = new HUISlider(window.content, 280, 300, "blurY", onChange);
		
		quality = new Window(window.content, 360, 340, "quality");
		low = new RadioButton(quality.content, 5, 5, "LOW", true, onChange);
		medium = new RadioButton(quality.content, 5, 25, "MEDIUM", false, onChange);
		high = new RadioButton(quality.content, 5, 45, "HIGH", false, onChange);
		low.groupName = medium.groupName = high.groupName = "blur";
		
		rect = new Sprite();
		rect.graphics.beginFill(0xED1A3D);
		rect.graphics.drawRect(0, 0, 100, 100);
		rect.graphics.endFill();
		rect.x = (465 - rect.width) / 2;
		rect.y = 80;
		window.content.addChild(rect);
		
		blurX.value = blurY.value = 4;
		stepper.value = stepper.max = 1.0;
		stepper.step = 0.1;
		stepper.min = 0;
		cc.value = 0xED1A3D;
		cc.usePopup = true;
		cc.popupAlign = ColorChooser.BOTTOM;
		
		onChange();
		
		new PushButton(window, 365, 0, "Copy to Clipboard", copy);
	}
	
	private function copy(event:Event):void
	{
		var q:int = (low.selected) ? 1 : (medium.selected) ? 2 : 3;
		var str:String = "new BlurFilter(" + blurX.value + "," + blurY.value + "," + q + ")";
		System.setClipboard(str);
	}
	
	private function onChange(event:Event = null):void
	{
		var q:int = (low.selected) ? 1 : (medium.selected) ? 2 : 3;
		rect.filters = [new BlurFilter(blurX.value, blurY.value, q)];
	}
}

class Perlin extends Sprite
{
	private var window:Panel;
	private var baseX:HUISlider;
	private var baseY:HUISlider;
	private var num:HUISlider;
	private var random:HUISlider;
	private var offsets:HUISlider;
	private var xOffset:HUISlider;
	private var yOffset:HUISlider;
	private var stitch:CheckBox;
	private var fractal:CheckBox;
	private var grayScale:CheckBox;
	private var channel:Window;
	private var red:CheckBox;
	private var green:CheckBox;
	private var blue:CheckBox;
	private var alpha2:CheckBox;
	private var rect:Bitmap;
		
	public function Perlin()
	{
		window = new Panel(this, 0, 0);
		window.width = window.height = 465;
		
		baseX = new HUISlider(window.content, 5, 280, "baseX", onChange);
		baseY = new HUISlider(window.content, 5, 300, "baseY", onChange);
		num = new HUISlider(window.content, 5, 320, "numOctaves", onChange);
		random = new HUISlider(window.content, 5, 340, "randomSeed", onChange);
		
		offsets = new HUISlider(window.content, 5, 380, "numOffsets", onChange);
		xOffset = new HUISlider(window.content, 5, 400, "xOffset", onChange);
		yOffset = new HUISlider(window.content, 5, 420, "yOffset", onChange);
		
		stitch = new CheckBox(window.content, 280, 280, "stitch", onChange);
		fractal = new CheckBox(window.content, 280, 300, "fractal", onChange);
		grayScale = new CheckBox(window.content, 280, 320, "grayScale", onChange);
		
		channel = new Window(window.content, 280, 340, "channelOptions");
		red = new CheckBox(channel.content, 5, 5, "RED", onChange);
		green = new CheckBox(channel.content, 5, 25, "GREEN", onChange);
		blue = new CheckBox(channel.content, 5, 45, "BLUE", onChange);
		alpha2 = new CheckBox(channel.content, 5, 65, "ALPHA", onChange);
		
		rect = new Bitmap(new BitmapData(200, 200, false, 0x0));
		rect.x = (465 - rect.width) / 2;
		rect.y = 40;
		window.content.addChild(rect);
		
		baseX.value = 100;
		baseY.value = 100;
		baseX.maximum = baseY.maximum = 200;
		num.minimum = 1;
		num.value = num.maximum = 5;
		offsets.maximum = 5;
		
		red.selected = green.selected = blue.selected = true;
		
		onChange();
		
		new PushButton(window, 365, 0, "Copy to Clipboard", copy);
	}
	
	private function copy(event:Event):void
	{
		var c:int = 0;
		if (red.selected) c += 1;
		if (green.selected) c += 2;
		if (blue.selected) c += 4;
		if (alpha2.selected) c += 8;
		
		var str:String = ".perlinNoise(" + baseX.value + "," + baseY.value + "," + num.value + "," + random.value + "," + 
						 stitch.selected + "," + fractal.selected + "," + c + "," + grayScale.selected;
		
		if (offsets.value)
		{
			var offset:String = ",[new Point(" + xOffset.value + "," + yOffset.value + ")";
			for (var i:int = 1; i < offsets.value; i++)
			{
				offset += ", new Point(" + xOffset.value + "," + yOffset.value + ")"
			}
			str += offset + "]";
		}
		str += ");";
		System.setClipboard(str);
	}
	
	private function onChange(event:Event = null):void
	{
		var c:int = 0;
		if (red.selected) c += 1;
		if (green.selected) c += 2;
		if (blue.selected) c += 4;
		if (alpha2.selected) c += 8;
		
		var array:Array = null;
		if (offsets.value > 0)
		{	
			array = [];
			for (var i:int = 0; i < offsets.value; i++)
			{
				array.push(new Point(xOffset.value, yOffset.value));
			}
		}
		rect.bitmapData.perlinNoise(baseX.value, baseY.value, num.value, random.value, stitch.selected, fractal.selected, c, grayScale.selected, array);
	}
}