/**
 * Copyright zahir ( http://wonderfl.net/user/zahir )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rMXX
 */

/*
	Bitmapにscale9Gridを適用させるサンプル(以前のものの焼き直し
	MITライセンス！
	　>>意味は判ってない！( キリッ
	
	Spriteクラスを基底しにした方が良かったかな？
 */
package{
	import flash.display.Bitmap;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
	
	public class ScalingBitmapTest extends Sprite{
		private var l:Loader;
		private var sb:ScalingBitmap;
		public function ScalingBitmapTest(){
			l = new Loader();
			l.contentLoaderInfo.addEventListener(Event.COMPLETE, function(e:Event):void{
				var bmp:Bitmap = l.content as Bitmap;
				
				sb = new ScalingBitmap ( bmp.bitmapData , 40, 40, 40, 40, true);
				addChild( sb );
				
				sb.width = 350;
				sb.height = 250;
				sb.smooth = true;
				sb.update();
				
				stage.addEventListener( MouseEvent.MOUSE_MOVE, onMove );
			});
			l.load( new URLRequest("http://zahir.coresv.com/wonderfl/img/scalingBitmapTest.png"), new LoaderContext(true) );
		}
		private function onMove(e:MouseEvent):void{
			sb.width = mouseX + 25;
			sb.height = mouseY + 25;
			sb.update();
		}
	}
}


import flash.display.BitmapData;
import flash.display.Graphics;
import flash.display.Shape;
import flash.geom.Matrix;
import flash.geom.Rectangle;
	
class ScalingBitmap extends Shape{
	private var $bitmapData$:BitmapData;
	private var $smooth$:Boolean = false;
	
	private var $bottom$:int = 0;
	private var $left$:int = 0;
	private var $right$:int = 0;
	private var $top$:int = 0;
	
	protected var w:int;
	protected var h:int;
	
	protected var newWidth:int;
	protected var newHeight:int;
	
	
	public function ScalingBitmap(	bitmapData:BitmapData,
														left:int = 0, top:int = 0, right:int = 0, bottom:int = 0,
														smooth:Boolean = false){
		this.bitmapData = bitmapData.clone();
		
		this.left = left;
		this.top = top;
		this.right = right;
		this.bottom = bottom;
		this.smooth = smooth;
		
		width = w;
		height = h;
		update();
	}
	
	public function get bottom():int{
		return $bottom$;
	}
	public function set bottom( value:int ):void{
		$bottom$ = (value < 0) ? 0 : value;
	}
	
	public function get left():int{
		return $left$;
	}
	public function set left( value:int ):void{
		$left$ = (value < 0) ? 0 : value;
	}
	
	public function get right():int{
		return $right$;
	}
	public function set right( value:int ):void{
		$right$ = (value < 0) ? 0 : value;
	}
	
	public function get top():int{
		return $top$;
	}
	public function set top( value:int ):void{
		$top$ = (value < 0) ? 0 : value;
	}
	
	public function get innerHight():int{
		return ( h - ( top + bottom ) );
	}
	public function get innerWidth():int{
		return ( w - ( left + right ) );
	}
	
	public function get bitmapData():BitmapData{
		return $bitmapData$;
	}
	public function set bitmapData( value:BitmapData ):void{
		$bitmapData$ = value;
		w = bitmapData.width;
		h = bitmapData.height;
	}
	
	public function get smooth():Boolean{
		return $smooth$;
	}
	public function set smooth( value:Boolean ):void{
		$smooth$ = value;
	}
	
	protected function get g():Graphics{ return super.graphics; }
	override public function get graphics():Graphics{ return null }
	
	override public function set scale9Grid(innerRectangle:Rectangle):void{}
	
	override public function set height(value:Number):void{
		var n:int = top + bottom;
		value = (value < 0) ? 0 : value;
		value = (value < n) ? n :value;
		newHeight = value;
	}
	override public function set width(value:Number):void{
		var n:int = left + right;
		value = (value < 0) ? 0 : value;
		value = (value < n) ? n :value;
		newWidth = value;
	}
	
	public function update():void{
		var offsetX:int = w - ( left + right );
		var offsetY:int = h - ( top + bottom );
		scale9Grid = new Rectangle(left, top, offsetX,offsetY);
		
		draw();
	}
	
	protected function draw():void{
		var iw:Number = w - ( left + right );
		var ih:Number = h - ( top + bottom );
		
		var innerWidth:Number = newWidth  - ( left + right );
		var innerHeight:Number = newHeight - ( top + bottom );
		
		var _sx:Number = innerWidth / iw;
		var _sy:Number = innerHeight / ih;
		
		var offsetX1:Number = left - left * _sx;
		var offsetX2:Number = newWidth % w;
		
		var offsetY1:Number = top - top * _sy;
		var offsetY2:Number = newHeight % h;
		
		var r:int = newWidth - right;
		var b:int = newHeight - bottom;
		
		g.clear();
		
		// top
		drawRect(0,0, left,top );
		drawRect(left,0, innerWidth,top, createBox( _sx, 1, offsetX1, 0) );
		drawRect(r,0, right,top, createBox( 1, 1, offsetX2, 0 ) );
		
		// middle
		drawRect(0,top, left, innerHeight, createBox(1,_sy, 0,offsetY1 ) );
		drawRect(left,top, innerWidth, innerHeight, createBox(_sx,_sy,offsetX1, offsetY1 ) );
		drawRect(r,top, right, innerHeight, createBox(1,_sy, offsetX2,offsetY1 ) );
		
		// bottom
		drawRect(0, b, left,top , createBox(1,1, 0, offsetY2));
		drawRect(left,b, innerWidth,top, createBox( _sx, 1, offsetX1, offsetY2 ) );
		drawRect(r,b, right,top, createBox( 1, 1, offsetX2, offsetY2 ) );
	}
	
	
	protected function drawRect( _x:int, _y:int, _width:int, _height:int, matrix:Matrix = null ):void{
		g.beginBitmapFill( bitmapData, matrix, true, smooth );
		g.drawRect( _x, _y, _width,_height );
		g.endFill();
	}
	
	protected function createBox( scaleX:Number = 1, scaleY:Number = 1, offsetX:Number = 0, offsetY:Number = 0):Matrix{
		var m:Matrix = new Matrix();
		m.scale( scaleX, scaleY );
		m.translate( offsetX, offsetY );
		return m;
	}
	//
}