/**
 * Copyright hacker_8ybuv6rh ( http://wonderfl.net/user/hacker_8ybuv6rh )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rMR1
 */

// forked from narutohyper's Alternativa3D Sprite3Dを使っての、Particle処理　明日の為の第一歩
// forked from clockmaker's [Alternativa3D] Basic Template
package {

	import alternativ5.engine3d.materials.*;
	import alternativ5.engine3d.primitives.*;
	import alternativ5.engine3d.core.*;
	import alternativ5.types.Texture;
	import alternativ5.types.Point3D;
	import alternativ5.utils.*

	import flash.display.Sprite;
	import flash.display.BitmapData;
	import flash.display.Bitmap;
	import flash.events.Event;

	
	[SWF(width = 200, height = 400, frameRate = 10, backgroundColor=0)]
	/**
	 * Alternativa3D Sprite3Dを使っての、Particle処理　明日の為の第一歩
	 * 
	 * Particle処理、明日の為の第一歩ｗ
	 * ただ動かすだけなら、1000個でFPS24くらいはでますね 
	 *
	 * @narutohyper
	 */

	/**
	 * Alternativa3D を簡単に扱うためのベーシックテンプレート
	 * @author Yasu (clockmaker)
	 */
	public class SimpleDemo extends Sprite {

		public function SimpleDemo():void {
			
			// テンプレートを作成します
			var template:BasicTemplate = new BasicTemplate();
			addChild(template);

			// FPS display launch 
			FPS.init(stage); 

			//-----------------------------------------------
			//Boxの作成
			//-----------------------------------------------
				// マテリアルを作成します 
				var materialA:DevMaterial = new DevMaterial(); 

				// プリミティブを作成します 
				var box:Object3D = new Object3D; 
				template.scene.root.addChild(box); 
				
				var i:uint;
				for (i=0;i<1000;i++) {
					var temp:Particle=new Particle(box,10,(Math.random()*0xFFFFFF))
				}


			var angle:uint=0


			// Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
			// レンダリング前に実行したい処理を記述します。
			template.onPreRender = function():void {


				// 立方体を回転させます (角度はラジアン)
				box.rotationY += 3 * Math.PI / 180;



			
				// マウスがステージの高さ何%の位置にあるか算出
				var rateY:Number = mouseY / stage.stageHeight;
				
				// カメラの高さの座標を調整
				// イージングの公式 対象の値 += (目標値 - 現在の値) * 減速率
				template.camera.y += ( - 1000 * rateY - template.camera.y) * 0.1;
				
				// カメラの座標を中央に向かせる
				template.cameraContoller.lookAt(new Point3D());
			}
		}
	}
}


import alternativ5.engine3d.materials.*;
import alternativ5.engine3d.primitives.*;
import alternativ5.engine3d.core.Sprite3D;
import alternativ5.types.Texture;
import alternativ5.types.Point3D;

import flash.display.Sprite;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.geom.Matrix
import flash.filters.BlurFilter;
import flash.filters.BitmapFilterQuality;

class Particle {
	public function Particle(scene:Object3D,size:Number,color:uint,age:Number=0) {

		//-----------------------------------------------
		// スプライト3Dの作成
		//-----------------------------------------------
			var tempSprite:Sprite = new Sprite()

			tempSprite.graphics.beginFill(color,1)
			tempSprite.graphics.drawCircle(0,0,size/2)
			tempSprite.graphics.beginFill(0xFFFFFFF,1)
			tempSprite.graphics.drawCircle(0,0,size/4)

			var filter:BlurFilter = new BlurFilter(3, 3, BitmapFilterQuality.HIGH);
			var myFilters:Array = [filter]
			tempSprite.filters = myFilters;


			// スプライト3D用のマテリアルを作成します
			var bmd:BitmapData = new BitmapData(tempSprite.width*2,tempSprite.height*2,true, 0x00000000)

			var mtr:Matrix=new Matrix();
			mtr.translate(tempSprite.width, tempSprite.height)
			bmd.draw(tempSprite,mtr)
			var material:SpriteTextureMaterial = new SpriteTextureMaterial(new Texture(bmd),1,true);

			// スプライト3Dを作成します
			var sp:Sprite3D = new Sprite3D();
			sp.material=material;

			// 3Dシーンのルートに追加します
			scene.addChild(sp);

			sp.x=Math.random()*2000-1000
			sp.y=Math.random()*2000-1000
			sp.z=Math.random()*2000-1000

	}
}





/**
 * ソースが長くなるので、comment削除しちゃいました
 * コメントはフォーク元をご覧ください。

 * BasicTemplate for Alternativa3D
 * Alternativa3Dを扱いやすくするためのテンプレートです
 * @author Yasu
 */
import alternativ5.engine3d.controllers.CameraController;
import alternativ5.engine3d.core.Camera3D;
import alternativ5.engine3d.core.Object3D;
import alternativ5.engine3d.core.Scene3D;
import alternativ5.engine3d.display.View;
import flash.display.Sprite;
import flash.display.StageAlign;
import flash.display.StageQuality;
import flash.display.StageScaleMode;
import flash.events.Event;
class BasicTemplate extends Sprite{
	public var scene:Scene3D;
	public var view:View;
	public var camera:Camera3D;
	public var cameraContoller:CameraController;
	
	private var _viewWidth:int;
	private var _viewHeight:int;
	private var _scaleToStage:Boolean;

	public function BasicTemplate(viewWidth:int=640, viewHeight:int=480, scaleToStage:Boolean = true) {
		_viewWidth = viewWidth;
		_viewHeight = viewHeight;
		_scaleToStage = scaleToStage;
		
		// Creating scene
		scene = new Scene3D();
		scene.splitAnalysis = false; // not analysis for performance
		scene.root = new Object3D();
		
		// Adding camera
		camera = new Camera3D();
		camera.z = -1000;
		scene.root.addChild(camera);
		
		// camera contoller
		cameraContoller = new CameraController(this);
		cameraContoller.camera = camera;
		
		// set view
		view = new View();
		view.camera = camera;
		addChild(view);
		
		// stage
		if (stage) init();
		else addEventListener(Event.ADDED_TO_STAGE, init);
	}
	
	protected function atInit():void {}
	
	private var _onInit:Function = function():void { };
	public function get onInit():Function { return _onInit; }
	public function set onInit(value:Function):void {
		_onInit = value;
	}
	
	protected function atPreRender():void {}
	
	private var _onPreRender:Function = function():void{};
	public function get onPreRender():Function { return _onPreRender; }
	public function set onPreRender(value:Function):void {
		_onPreRender = value;
	}
	
	protected function atPostRender():void {
	}
	
	protected var _onPostRender:Function = function():void{};
	public function get onPostRender():Function { return _onPostRender; }
	public function set onPostRender(value:Function):void {
		_onPostRender = value;
	}
	
	public function startRendering():void {
		addEventListener(Event.ENTER_FRAME, onRenderTick);
	}

	public function stopRendering():void {
		removeEventListener(Event.ENTER_FRAME, onRenderTick);
	}
	
	public function singleRender():void {
		onRenderTick();
	}
	
	private function init(e:Event = null):void {
		stage.scaleMode = StageScaleMode.NO_SCALE;
		stage.align = StageAlign.TOP_LEFT;
		stage.quality = StageQuality.HIGH;

		stage.addEventListener(Event.RESIZE, onResize);
		onResize(null);
		
		startRendering();
		
		atInit();
		_onInit();
		
	}
	
	private function onRenderTick(e:Event = null):void {
		atPreRender();
		_onPreRender();
		scene.calculate();
		atPostRender();
		_onPostRender();
	}
	
	private function onResize(event:Event = null):void {
		if (_scaleToStage) {
			view.width = stage.stageWidth;
			view.height = stage.stageHeight;
		}else {
			view.width = _viewWidth;
			view.height = _viewHeight;
		}
	}
}
