/**
 * Copyright yprops ( http://wonderfl.net/user/yprops )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rKzW
 */

package {
    import flash.geom.Point;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.Graphics;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        
        //-------定数------------
        
        private const MOVE_RATE :Number = 0.1;
        
        
        //--------変数-------------
        
        private var bg :Sprite;
        private var mover :Sprite;
        private var moverTargetPoint :Point;
        
        //-------コンストラクタ-------
        
        public function FlashTest() {
            
            //背景設置（何かしら表示物がある場所でないととクリックイベントを出さないので設置）
            bg = makeRectSp(0xFFCCCC, 1, 0,0,300,300);
            addChild(bg);
            
            //動くモノ設置
            mover = makeRectSp(0x000000, 0.5, -50,-50,100,100);
            moverTargetPoint = new Point();
            mover.addEventListener(Event.ENTER_FRAME, moverUpdate);
            addChild(mover);
            
            //クリック受付用
            addEventListener(MouseEvent.CLICK, onClicked);
        }
        
        
        //--------リスナー----------
        
        private function onClicked(ev:MouseEvent) :void{
            moverTargetPoint = new Point(ev.stageX, ev.stageY);
            
            //※ MouseEvent.stageX, stageY ... ステージ上のマウス位置。
            //※ MouseEvent.localX, localY ... イベント発行したオブジェクト上のマウス位置。
        }
        
        
        
        //--------メソッド----------
        
        private function makeRectSp(color :int, alpha :Number, x :Number,y :Number,w :Number,h :Number) :Sprite{
            var sp :Sprite = new Sprite();
            var g :Graphics = sp.graphics;
            g.beginFill(color, alpha);
            g.drawRect(x, y, w, h);
            g.endFill();
            return sp;
        }
        
        
        //--------mover用----------
        
        private function moverUpdate(ev:Event) :void{
            
            //クリックしたときのマウス位置をターゲットとする場合
            mover.x += (moverTargetPoint.x - mover.x) * MOVE_RATE;
            mover.y += (moverTargetPoint.y - mover.y) * MOVE_RATE;
            
            //常にマウス位置をターゲットとする場合
            //mover.x += (mouseX - mover.x) * MOVE_RATE;
            //mover.y += (mouseY - mover.y) * MOVE_RATE;
        }
        
    }
}