/**
 * Copyright Hakuhin ( http://wonderfl.net/user/Hakuhin )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rK5y
 */

// -------------------------------------------------
//
// 円状にサインカーブで伸縮するフィルタ
// 
//　Pixel Bender Toolkit　のプレビュー時のような速度が
//　出ると思ってたんですけど、使用用法が違うのかしら。
//　
//　名称　Bender なんですね。ずっと Blender だと思ってました…
//
// -------------------------------------------------
package {
	import flash.events.*;
	import flash.display.*;
	import flash.net.*;
	import flash.text.*;
	import flash.utils.*;
	import flash.system.*;
	import flash.geom.*;
	import flash.filters.*;
	import flash.ui.*;

    public class Main extends Sprite {
        public function Main() {



// -------------------------------------------------
// コンストラクタ
// -------------------------------------------------

// フレームレート       
stage.frameRate = 60;

// 100%表示
stage.scaleMode = StageScaleMode.NO_SCALE;

// 左上
stage.align = StageAlign.TOP_LEFT;
stage.align = "TL";

// スプライトを配置
var board : Sprite = new Sprite();
addChild(board);

// リソース読み込み開始
load();


// -------------------------------------------------
// 読み込み
// -------------------------------------------------
function load():void{

	// 画像のURL
	var graphic_url:String = "http://actionscript.web.officelive.com/wonderfl/bg000.jpg";

	// ローダー
	var loader_obj : Loader = new Loader();
	
	// 読み込み開始
	var url : URLRequest = new URLRequest(graphic_url);
	loader_obj.load(url);
	
	// 読み込み終了
	var info : LoaderInfo = loader_obj.contentLoaderInfo;
	info.addEventListener (Event.INIT,LoaderInfoInitFunc);
	function LoaderInfoInitFunc (event : Event):void {

		// 読み込んだ画像を表示
		board.addChild(loader_obj);

		// 初期化へ
		init();
	}
}


// -------------------------------------------------
// 初期化
// -------------------------------------------------
function init():void{

	// ステージサイズ
	var w:uint;
	var h:uint;	
	
	// リサイズ時にフィット
	stage.addEventListener(Event.RESIZE,ResizeFunc);
	function ResizeFunc(e:Event):void{
		w = stage.stageWidth;
		h = stage.stageHeight;
		board.width = w;
		board.height = h;
	}
	ResizeFunc(null);
	
	// シェーダバイトコード
	var binary : ByteArray = CustomFilterGetByteArray();
	
	// シェーダ作成
	var shader:Shader = new Shader();
	shader.byteCode = binary;
	var filter:ShaderFilter = new ShaderFilter(shader); 

	// パラメータアクセス用
	var data : ShaderData  = shader.data;
	var param : ShaderParameter;

	// パラメータ
	var phase:Number = 0;		// 位相
	var amplitude:Number = 10;	// 振幅
	var cycle:Number = 100;		// 周期

	addEventListener(Event.ENTER_FRAME,function(e:Event):void{
		
		// 位相を変化
		phase += 0.01;
		if(phase > 1)	phase -= 1;

		// 位置
		param = data.position;
		param.value = [mouseX,mouseY];					

		// 位相
		param = data.phase;
		param.value = [phase];

		// 振幅
		param = data.amplitude;
		param.value = [amplitude];

		// 周期
		param = data.cycle;
		param.value = [cycle];

		// 適応
		board.filters = [filter];
	});
	
	// テキスト表示
	var tf : TextField = new TextField();
	tf.x = 5;
	tf.y = 5;
	tf.width = 200;
	tf.height = 40;
	tf.border = true;
	tf.background = true;
	addChild(tf);
	addEventListener(Event.ENTER_FRAME,function(e:Event):void{
		var str:String = "";
		str += "振幅:" + amplitude + "　(上下キーで変更)\n";
		str += "周期:" + cycle + "　(左右キーで変更)\n";
		
		tf.text = str;
	});
	
	
	// キー操作
	stage.addEventListener(KeyboardEvent.KEY_DOWN, KeyDown);
	function KeyDown(event:KeyboardEvent):void{
		if(event.keyCode == Keyboard.UP)		amplitude -= 1;
		if(event.keyCode == Keyboard.DOWN)	amplitude += 1;
		if(event.keyCode == Keyboard.LEFT)	cycle -= 10;
		if(event.keyCode == Keyboard.RIGHT)	cycle += 10;
		
		if(amplitude < 0)	amplitude = 0;
		if(cycle < 0)	cycle = 0;
	};

}


// -------------------------------------------------
// シェーダバイトコード
// -------------------------------------------------
function CustomFilterGetByteArray():ByteArray{

	var a:ByteArray = new ByteArray();
	var f:Function;

	f = a.writeUnsignedInt;
	f(0xa5010000); f(0x00a41600); f(0x43697263); f(0x6c655761); 
	f(0x76654369); f(0x72636c65); f(0x46696c74); f(0x6572a00c); 
	f(0x6e616d65); f(0x73706163); f(0x65006375); f(0x72766520); 
	f(0x77617665); f(0x20636972); f(0x636c6500); f(0xa00c7665); 
	f(0x6e646f72); f(0x0048616b); f(0x7568696e); f(0x00a00876); 
	f(0x65727369); f(0x6f6e0001); f(0x00a00c64); f(0x65736372); 
	f(0x69707469); f(0x6f6e0089); f(0x7e8ff382); f(0xc9835483); 
	f(0x43839383); f(0x4a815b83); f(0x7582c590); f(0x4c8f6b82); 
	f(0xb782e983); f(0x74834283); f(0x8b835e00); f(0xa1010200); 
	f(0x000c5f4f); f(0x7574436f); f(0x6f726400); f(0xa3000473); 
	f(0x726300a1); f(0x02040100); f(0x0f647374); f(0x00a10102); 
	f(0x00000370); f(0x6f736974); f(0x696f6e00); f(0xa2026465); 
	f(0x6661756c); f(0x7456616c); f(0x75650000); f(0x00000000); 
	f(0x000000a2); f(0x0c646573); f(0x63726970); f(0x74696f6e); 
	f(0x00897e82); f(0xcc928690); f(0x538dc095); f(0x5700a101); 
	f(0x01020008); f(0x6379636c); f(0x6500a201); f(0x6d696e56); 
	f(0x616c7565); f(0x003f8000); f(0x00a20164); f(0x65666175); 
	f(0x6c745661); f(0x6c756500); f(0x42c80000); f(0xa20c6465); 
	f(0x73637269); f(0x7074696f); f(0x6e009467); f(0x82aa88ea); 
	f(0x8efc82b7); f(0x82e992b7); f(0x82b300a1); f(0x01010200); 
	f(0x04706861); f(0x736500a2); f(0x016d696e); f(0x56616c75); 
	f(0x65000000); f(0x0000a201); f(0x6d617856); f(0x616c7565); 
	f(0x003f8000); f(0x00a20164); f(0x65666175); f(0x6c745661); 
	f(0x6c756500); f(0x00000000); f(0xa20c6465); f(0x73637269); 
	f(0x7074696f); f(0x6e009467); f(0x82cc88ca); f(0x918a00a1); 
	f(0x01010200); f(0x02616d70); f(0x6c697475); f(0x646500a2); 
	f(0x016d696e); f(0x56616c75); f(0x65000000); f(0x0000a201); 
	f(0x64656661); f(0x756c7456); f(0x616c7565); f(0x00412000); 
	f(0x00a20c64); f(0x65736372); f(0x69707469); f(0x6f6e0094); 
	f(0x6782cc97); f(0x6882ea95); f(0x9d001d03); f(0x00c10000); 
	f(0x10001d02); f(0x00100000); f(0x80000202); f(0x00100300); 
	f(0x00001d03); f(0x00200200); f(0xc0001d02); f(0x00100000); 
	f(0xc0000202); f(0x00100300); f(0x40001d03); f(0x00100200); 
	f(0xc0001d04); f(0x00c10300); f(0xb0001d02); f(0x00100400); 
	f(0x40000602); f(0x00100400); f(0x00001d03); f(0x00200200); 
	f(0xc0001d02); f(0x00100400); f(0x00000302); f(0x00100400); 
	f(0x00001d03); f(0x00100400); f(0x40000303); f(0x00100400); 
	f(0x40001d04); f(0x00200200); f(0xc0000104); f(0x00200300); 
	f(0xc0001602); f(0x00100400); f(0x80001d03); f(0x00100200); 
	f(0xc0000402); f(0x00100200); f(0x00000302); f(0x00100300); 
	f(0xc0001d04); f(0x00200200); f(0xc0001a02); f(0x00100400); 
	f(0x80001d04); f(0x00100400); f(0x80000204); f(0x00100200); 
	f(0xc0001d04); f(0x00200400); f(0xc0001d02); f(0x00100400); 
	f(0x80000102); f(0x00100200); f(0x40003204); f(0x001043b4); 
	f(0x00001d05); f(0x00800200); f(0xc0000305); f(0x00800400); 
	f(0xc0003202); f(0x00103c8e); f(0xfa350302); f(0x00100500); 
	f(0x00000c04); f(0x00100200); f(0xc0001d02); f(0x00100400); 
	f(0xc0000302); f(0x00100200); f(0x80001d03); f(0x00100200); 
	f(0xc0000d02); f(0x00100300); f(0x80001d04); f(0x00100200); 
	f(0xc0000304); f(0x00100300); f(0xc0000103); f(0x00800400); 
	f(0xc0000c02); f(0x00100300); f(0x80001d04); f(0x00100200); 
	f(0xc0000304); f(0x00100300); f(0xc0000103); f(0x00400400); 
	f(0xc0003105); f(0x00f10300); f(0x10001d01); f(0x00f30500); 
	
	f = a.writeShort;
	f(0x1b00); 

	return a;
}

            
        }
    }
}


// ↓ pbk ファイルのコード
/* -----------------------------------------------------------------------------
	パラメータ
	position		円の中心座標
	cycle			波が一周する長さ
	phase			波の位相 ( 0 ～ 1 までゆっくり変化させる)
	amplitude		波の揺れ幅
 ----------------------------------------------------------------------------- */
/*
<languageVersion : 1.0;>
kernel CircleWaveCircleFilter<
	namespace : "curve wave circle";
	vendor : "Hakuhin";
	version : 1;
	description : "円状にサインカーブで伸縮するフィルタ";
>{
	input image4 src;	// 入力イメージ
	output pixel4 dst;	// 出力ピクセル


	// -------------------------------------
	// パラメータ
	// -------------------------------------
	parameter float2 position<
		defaultValue:float2(0.0 , 0.0);
		description : "円の中心座標";
	>;
	parameter float cycle<
		minValue:float(1.0);
		defaultValue:float(100.0);
		description : "波が一周する長さ";
	>;
	parameter float phase<
		minValue:float(0.0);
		maxValue:float(1.0);
		defaultValue:float(0);
		description : "波の位相";
	>;
	parameter float amplitude<
		minValue:float(0.0);
		defaultValue:float(10.0);
		description : "波の揺れ幅";
	>;


	// -------------------------------------
	// ピクセルごとに実行される関数
	// -------------------------------------
	void evaluatePixel(){
		// ピクセルの位置を取得
		float2 pos = outCoord();

		// 位置から中心座標までのベクトルを取得
		float2 v = float2(position.x - pos.x,position.y - pos.y);

		// ベクトルからラジアンを取得
		float rad = atan(v.y , v.x);

		// ベクトルから長さを求める
		float distance = sqrt((v.x * v.x) + (v.y * v.y));
		
		// 周期に丸める
		float d = distance / cycle;
		d = d - floor(d);
		
		// オフセットを取得して座標に加算
		distance = sin(radians((d + phase) * 360.0)) * amplitude;
		pos.x += cos(rad) * distance;
		pos.y += sin(rad) * distance;

		// ソースイメージからピクセルカラーを取得して出力
		dst = sampleLinear(src,pos);
	}
}
*/




// -------------------------------------------------
// 外部画像をサムネイルとしてキャプチャ
// -------------------------------------------------
import flash.net.*;
import flash.events.*;
import flash.display.*;
import flash.geom.*;
function ThumbnailCapture(url:String,time:uint,stage:Stage):void{

	// キャプチャタイミング
	Wonderfl.capture_delay( time );

	
	// スプライト作成
	var sprite : Sprite = new Sprite();

	// ステージ最前面に配置
	stage.addChildAt(sprite,stage.numChildren);
	
	// ローダー
	var loader_obj : Loader = new Loader();
	loader_obj.contentLoaderInfo.addEventListener (Event.INIT,function(e:Event):void{

		// メモリからインスタンス化
		var loader_memory : Loader = new Loader();
		loader_memory.contentLoaderInfo.addEventListener (Event.INIT,function(e:Event):void{

			// キャプチャ
			var bmp : BitmapData = new BitmapData(loader_memory.width,loader_memory.height,true,0);
			sprite.addChild(loader_memory);
			bmp.draw(sprite);
			sprite.removeChild(loader_memory);
			loader_memory.unload();
			loader_obj.unload();
			loader_memory = null;
			loader_obj = null;
			
			
			// 画像を配置
			var bmp_obj : Bitmap = new Bitmap(bmp);
			bmp_obj .width = stage.stageWidth;
			bmp_obj .height = stage.stageHeight;
			stage.addChild(bmp_obj );
			
		});
		
		// 読み込み開始
		loader_memory.loadBytes(loader_obj.contentLoaderInfo.bytes);
	});
	
	// 読み込み開始
	loader_obj.load(new URLRequest(url));
}