/**
 * Copyright bkzen ( http://wonderfl.net/user/bkzen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rJJ4
 */

package  
{
    import com.bit101.components.PushButton;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.DropShadowFilter;
    import flash.geom.ColorTransform;
    import flash.text.TextField;
    import flash.text.TextFormat;
    
    /**
     * BitmapData がアルファを持つとおかしい。
     * @author jc at bk-zen.com
     */
    [SWF (backgroundColor = "0x000000", frameRate = "30", width = "465", height = "465")]
    public class Test57 extends Sprite 
    {
        private var bmd: BitmapData;
        private var colorTf: ColorTransform;
        private var color: uint;
        private var txt:TextField;
        private var test:PushButton;
        
        public function Test57() 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(event: Event = null): void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            //
            //var color: uint = 0x49001FFF;
            color = 0xFF001FFF;
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            addChild(new Bitmap(bmd = new BitmapData(465, 465, true, color), "auto", true));
            //colorTf = new ColorTransform(0.98, 0.98, 1, 1, -1, -1, -1);
            colorTf = new ColorTransform(1, 1, 1, 1, -1, -1, -1);
            addChild(txt = new TextField());
            txt.width  = stage.stageWidth;
            txt.height = stage.stageHeight;
            txt.defaultTextFormat = new TextFormat("Verdana", 12, 0xFFFFFF);
            txt.wordWrap = true;
            txt.filters = [new DropShadowFilter(1, 45, 0, 1, 5, 5, 100)];
            test = new PushButton(this, 0, 0, "Test", onClick);
            test.x = stage.stageWidth  - test.width;
            test.y = stage.stageHeight - test.height;
            onClick();
        }
        
        private function onClick(event: MouseEvent = null): void 
        {
            bmd.fillRect(bmd.rect, color);
            var a: int = (color >> 0x18) & 0xFF;
            var r: int = (color >> 0x10) & 0xFF;
            var g: int = (color >> 0x08) & 0xFF;
            var b: int = (color >> 0x00) & 0xFF;
            var na: int = a * colorTf.alphaMultiplier + colorTf.alphaOffset;
            var nr: int = r * colorTf.redMultiplier   + colorTf.redOffset;
            var ng: int = g * colorTf.greenMultiplier + colorTf.greenOffset;
            var nb: int = b * colorTf.blueMultiplier  + colorTf.blueOffset;
            
                 if (na < 0x00) na = 0x00;
            else if (na > 0xFF) na = 0xFF;
                 if (nr < 0x00) nr = 0x00;
            else if (nr > 0xFF) nr = 0xFF;
                 if (ng < 0x00) ng = 0x00;
            else if (ng > 0xFF) ng = 0xFF;
                 if (nb < 0x00) nb = 0x00;
            else if (nb > 0xFF) nb = 0xFF;
            traceReset();
            atrace("塗る色:\t\t\t", colStr(color, 4, true));
            atrace("塗られた色32:\t", colStr(bmd.getPixel32(1, 1), 4, true));
            atrace("塗られた色24:\t", colStr(bmd.getPixel(1, 1), 3, true));
            atrace("古 A: " + colStr(a),  "古 R: " + colStr(r),  "古 G: " + colStr(g),  "古 B: " + colStr(b));
            atrace("新 A: " + colStr(na), "新 R: " + colStr(nr), "新 G: " + colStr(ng), "新 B: " + colStr(nb));
            atrace();
            atrace(colorTf, "を適用");
            atrace();
            atrace("計算で求めた色:\t\t\t\t\t", colStr(na << 0x18 | nr << 0x10 | ng << 0x08 | nb << 0x00, 4, true));
            bmd.colorTransform(bmd.rect, colorTf);
            atrace("ColorTransform を適用した色32:\t", colStr(bmd.getPixel32(1, 1), 4, true));
            atrace("ColorTransform を適用した色24:\t", colStr(bmd.getPixel(1, 1), 3, true));
            if ((--a) < 0)
            {
                test.removeEventListener(MouseEvent.CLICK, onClick);
            }
            else 
            {
                color = a << 0x18 | r << 0x10 | g << 0x08 | b << 0x00;
                atrace("Test ボタンをクリックで次の色へ");
            }
        }
        
        private function traceReset():void 
        {
            txt.text = "";
        }
        
        private function atrace(...args): void
        {
            txt.appendText(args.join(", ") + "\n");
        }
        
        /**
         * カラーを 16進数の文字列にする。
         * @param    color    : 対象カラー
         * @param    p        : 
         * @param    isHead    : 
         * @return
         */
        private function colStr(color: uint, p: uint = 1, isHead: Boolean = false): String
        {
            p <<= 1;
            var str: String = color.toString(16).toUpperCase();
            var i: uint, n: uint = p - str.length < 0 ? 0 : p - str.length;
            for (i = 0; i < n; i++) 
            {
                str = "0" + str;
            }
            return (isHead ? "0x" : "") + str;
        }
    }
}