/**
 * Copyright kt3k ( http://wonderfl.net/user/kt3k )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rIwB
 */

// forked from kt3k's Stray Dots
package
{
    import flash.utils.ByteArray;
    import flash.net.URLRequest;
    import flash.media.SoundChannel;
    import flash.media.Sound;    
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.filters.*;

    [SWF(frameRate="60", backgroundColor="#000000")]

    public class Main extends Sprite
    {
        private var soundsource:String = "http://penv.org/gnossiennes.mp3";
        private var soundon:Boolean = true;
        
        private var bytes:ByteArray;

        private var blur:BitmapFilter;
        private var container:Sprite;
        private var source:Sprite;
        private var bmpd:BitmapData;
        
        private var rect:Sprite;
        private var straydot:StrayDot;
        private var sc:StrayDot;
        private var i:Number = 0;
        
        private var snd:Sound = new Sound();
        private var soundChannel:SoundChannel;

        public function Main()
        {
            stage.scaleMode = StageScaleMode.SHOW_ALL;
            stage.quality = StageQuality.LOW;            
            init();
            if (soundon) initSound();
            addEventListener(Event.ENTER_FRAME, update);
        }

        private function init():void
        {
        }
        
        private function initSound():void
        {
            snd.load(new URLRequest(soundsource));
            soundChannel = snd.play(0,9999);
        }


        private function update(e:Event = null):void
        {         
        }     
    }
}

// utils
class StrayDot
{
    public var r:Number = 127;
    public var g:Number = 127;
    public var b:Number = 127;
    public var velocity:Number;
   
    public function StrayDot(v:Number = 1):void
    {
        velocity = v;
    }
    
    public function next(v:Number = 0):void
    {
        var x:Number = uniform(-1, 1);
        var y:Number = uniform(-1, 1);
        var z:Number = uniform(-1, 1);
        
        var n:Number = Math.sqrt(x*x + y*y + z*z);
        
        var velo:Number = velocity;
        if (v) velo = v;
        
        x *= velo / n;
        y *= velo / n;
        z *= velo / n;
        
        r += x;
        g += y;
        b += z;
        this.normalize();
    }
    
    public function normalize():void
    {
        if (r < 0) r = -r;
        if (g < 0) g = -g;
        if (b < 0) b = -b;
        if (r > 255) r = 510 - r;
        if (g > 255) g = 510 - g;
        if (b > 255) b = 510 - b;
    }
}

function dice(n:Number = 6):Number
{
    return Math.round(Math.random() * n);
}

function uniform(x:Number, y:Number):Number
{
    if (x > y) {
        x, y = y, x;
    }
    return x + Math.random() * (y - x)
}


function lucky(luck:Number):Boolean
{
    return Math.random() < luck;
}
