/**
 * Copyright nikolajy ( http://wonderfl.net/user/nikolajy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rIkN
 */

// forked from jozefchutka's onBoard on Maps
// forked from jozefchutka's onBoard - Massive Collaborative Painting
/*
--- README FIRST ------------------------------------
If "Peer-Assisted Networking" security panel appears:
  1. click "remember"
  2. click "Allow"
  3. reload flash (or webpage)

-----------------------------------------------------
ROTATE: [Ctrl] + mouse move
ZOOM: double click, [Page Up], [Page Down]
MOVE: mouse drag

embed to html:
<iframe src="http://onboard.yoz.sk/?board=maps"></iframe>
*/

package
{
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.net.URLRequest;
    import flash.net.URLVariables;
    import flash.system.Security;

    [SWF(width="465", height="465", frameRate="30", backgroundColor="#ffffff")]
    public class WonderflApp extends Sprite
    {
        private var loader:Loader = new Loader();
        
        public function WonderflApp():void
        {
            Security.allowDomain("onboard.yoz.sk");
            
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            stage.addEventListener(Event.RESIZE, onStageResize);
            
            var data:URLVariables = new URLVariables();
            data.path = "http://onboard.yoz.sk";
            data.board = "maps";
            //data.x = 0;
            //data.y = 0;
            //data.scale = 1;
            //data.rotation = 0;
            data.color = 0x000000;
            data.size = 1;
            
            data.FBclientId = "110363680930";
            data.FBredirectURI = "http://onboard.yoz.sk/callback.html"; 
            data.FBscope = "publish_stream,offline_access";
            
            var request:URLRequest = new URLRequest("http://onboard.yoz.sk/flash/onBoard2Maps.swf");
            request.data = data;
            
            addChild(loader);
            loader.load(request);
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, loaderComplete);
        }
        
        private function loaderComplete(event:Event):void
        {
            var onboard:Object = Object(loader.content);
            onboard.resize(stage.stageWidth, stage.stageHeight);
        }
        
        public function onStageResize(event:Event):void
        {
            if(!loader.content)
                return;
            var onboard:Object = Object(loader.content);
            onboard.resize(stage.stageWidth, stage.stageHeight);
        }
    }
}