/**
 * Copyright mapache ( http://wonderfl.net/user/mapache )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rGss
 */

// forked from nijitaro's PaperVision3DでDAEファイルを読み込んでみる
/**
 * PaperVision3DでDAEファイルを読み込んでみる
 * 
 * 3Dモデルは http://blog.r3c7.net/?p=121 より
 * ありがとうございます！
 * 
 * [感想]
 * ほんとにdaeファイルをloadしたら終わった。
 * すごい簡単だ！
 * 
 * [課題]
 * 1. 元記事を見るとネギ振っている。
 * 2. モデルが小さかったのでcamera.zoomで大きくしている。
 *    scaleで大きくしたらyawの角速度が上がってしまった。
 *    普通にmodelを大きくしたい。
 * 
 * - org.papervision3d.objects.parsers.DAE;
 * - DAE.load(filename:String);
 */
package {
    import flash.events.Event;
    
    import org.papervision3d.objects.parsers.DAE;
    import org.papervision3d.view.BasicView;

    [SWF(frameRate=50, backgroundColor="#222222")]
    public class Main extends BasicView
    {
        public var model:DAE;
        
        public function Main()
        {
            // DAEクラスのインスタンスmodelを作成
            model = new DAE();
            // daeファイルを読み込む。これだけでOK。めっちゃ簡単。
            // negimiku.daeファイルは、miku.pngを読むように設定されているのでマテリアルとかもいらない。
            model.load("http://latinwebtools.com/vicsamples/AnimacionMicrosoft.DAE");
            // サイズ調整 (今回はモデルが1つなのでこれで平気そうにみえる。ホントはmodelを大きくした          い)    
            
            
            
            //camera.zoom = 100;            
            // シーンにaddChild
            scene.addChild(model);
            // レンダリング開始
            startRendering();
        }
        override protected function onRenderTick(event:Event=null):void
        {  
            // Y軸回転を少しだけ。
           // model.yaw(0.1);
            // SuperクラスのonRenderTickを実行
            //super.onRenderTick(event);
        }
    }
}
